/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import com.google.inject.Inject;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.ChatHandler;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.hive.druid.io.druid.server.metrics.DataSourceTaskIdHolder;

@Path(value="/druid/worker/v1")
public class ChatHandlerResource {
    public static final String TASK_ID_HEADER = "X-Druid-Task-Id";
    private final ChatHandlerProvider handlers;
    private final String taskId;

    @Inject
    public ChatHandlerResource(ChatHandlerProvider handlers, DataSourceTaskIdHolder taskIdHolder) {
        this.handlers = handlers;
        this.taskId = taskIdHolder.getTaskId();
    }

    @Path(value="/chat/{id}")
    public Object doTaskChat(@PathParam(value="id") String handlerId, @Context HttpHeaders headers) {
        List requestTaskId;
        if (this.taskId != null && (requestTaskId = headers.getRequestHeader(TASK_ID_HEADER)) != null && !requestTaskId.contains(this.taskId)) {
            return null;
        }
        Optional<ChatHandler> handler = this.handlers.get(handlerId);
        if (handler.isPresent()) {
            return handler.get();
        }
        return null;
    }
}

