/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.data.EmptyIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.ListIndexed;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.joda.time.Interval;
import org.roaringbitmap.IntIterator;

public class IncrementalIndexAdapter
implements IndexableAdapter {
    private static final Logger log = new Logger(IncrementalIndexAdapter.class);
    private final Interval dataInterval;
    private final IncrementalIndex<?> index;
    private final Map<String, DimensionAccessor> accessors;

    public IncrementalIndexAdapter(Interval dataInterval, IncrementalIndex<?> index, BitmapFactory bitmapFactory) {
        this.dataInterval = dataInterval;
        this.index = index;
        List<IncrementalIndex.DimensionDesc> dimensions = index.getDimensions();
        this.accessors = Maps.newHashMapWithExpectedSize(dimensions.size());
        for (IncrementalIndex.DimensionDesc dimension : dimensions) {
            this.accessors.put(dimension.getName(), new DimensionAccessor(dimension));
        }
        int rowNum = 0;
        for (IncrementalIndex.TimeAndDims timeAndDims : index.getFacts().keySet()) {
            Object[] dims = timeAndDims.getDims();
            for (IncrementalIndex.DimensionDesc dimension : dimensions) {
                int dimIndex = dimension.getIndex();
                DimensionAccessor accessor = this.accessors.get(dimension.getName());
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    accessor.indexer.processRowValsToUnsortedEncodedArray(null);
                    continue;
                }
                ColumnCapabilitiesImpl capabilities = dimension.getCapabilities();
                if (!capabilities.hasBitmapIndexes()) continue;
                MutableBitmap[] bitmapIndexes = accessor.invertedIndexes;
                DimensionIndexer indexer = accessor.indexer;
                indexer.fillBitmapsFromUnsortedEncodedArray(dims[dimIndex], rowNum, bitmapIndexes, bitmapFactory);
            }
            ++rowNum;
        }
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.index.size();
    }

    @Override
    public Indexed<String> getDimensionNames() {
        return new ListIndexed<String>(this.index.getDimensionNames(), String.class);
    }

    @Override
    public Indexed<String> getMetricNames() {
        return new ListIndexed<String>(this.index.getMetricNames(), String.class);
    }

    @Override
    public Indexed<Comparable> getDimValueLookup(String dimension) {
        DimensionAccessor accessor = this.accessors.get(dimension);
        if (accessor == null) {
            return null;
        }
        DimensionIndexer indexer = accessor.dimensionDesc.getIndexer();
        return indexer.getSortedIndexedValues();
    }

    @Override
    public Iterable<Rowboat> getRows() {
        return new Iterable<Rowboat>(){

            @Override
            public Iterator<Rowboat> iterator() {
                final List<IncrementalIndex.DimensionDesc> dimensions = IncrementalIndexAdapter.this.index.getDimensions();
                final DimensionHandler[] handlers = new DimensionHandler[dimensions.size()];
                final DimensionIndexer[] indexers = new DimensionIndexer[dimensions.size()];
                for (IncrementalIndex.DimensionDesc dimension : dimensions) {
                    handlers[dimension.getIndex()] = dimension.getHandler();
                    indexers[dimension.getIndex()] = dimension.getIndexer();
                }
                return Iterators.transform(IncrementalIndexAdapter.this.index.getFacts().entrySet().iterator(), new Function<Map.Entry<IncrementalIndex.TimeAndDims, Integer>, Rowboat>(){
                    int count = 0;

                    @Override
                    public Rowboat apply(Map.Entry<IncrementalIndex.TimeAndDims, Integer> input) {
                        IncrementalIndex.TimeAndDims timeAndDims = input.getKey();
                        Object[] dimValues = timeAndDims.getDims();
                        int rowOffset = input.getValue();
                        Object[] dims = new Object[dimValues.length];
                        for (IncrementalIndex.DimensionDesc dimension : dimensions) {
                            Object sortedDimVals;
                            int dimIndex = dimension.getIndex();
                            if (dimIndex >= dimValues.length || dimValues[dimIndex] == null) continue;
                            DimensionIndexer indexer = indexers[dimIndex];
                            dims[dimIndex] = sortedDimVals = indexer.convertUnsortedEncodedArrayToSortedEncodedArray(dimValues[dimIndex]);
                        }
                        Object[] metrics = new Object[IncrementalIndexAdapter.this.index.getMetricAggs().length];
                        for (int i = 0; i < metrics.length; ++i) {
                            metrics[i] = IncrementalIndexAdapter.this.index.getMetricObjectValue(rowOffset, i);
                        }
                        return new Rowboat(timeAndDims.getTimestamp(), dims, metrics, this.count++, handlers);
                    }
                });
            }
        };
    }

    @Override
    public IndexedInts getBitmapIndex(String dimension, int index) {
        DimensionAccessor accessor = this.accessors.get(dimension);
        if (accessor == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        ColumnCapabilitiesImpl capabilities = accessor.dimensionDesc.getCapabilities();
        DimensionIndexer indexer = accessor.dimensionDesc.getIndexer();
        if (!capabilities.hasBitmapIndexes()) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        int id = indexer.getUnsortedEncodedValueFromSorted(index);
        if (id < 0 || id >= indexer.getCardinality()) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        MutableBitmap bitmapIndex = accessor.invertedIndexes[id];
        if (bitmapIndex == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        return new BitmapIndexedInts(bitmapIndex);
    }

    @Override
    public String getMetricType(String metric) {
        return this.index.getMetricType(metric);
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.index.getCapabilities(column);
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.index.getDimensionHandlers();
    }

    static class BitmapIndexedInts
    implements IndexedInts {
        private final MutableBitmap bitmapIndex;

        BitmapIndexedInts(MutableBitmap bitmapIndex) {
            this.bitmapIndex = bitmapIndex;
        }

        @Override
        public int size() {
            return this.bitmapIndex.size();
        }

        @Override
        public int get(int index) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                final IntIterator baseIter;
                {
                    this.baseIter = BitmapIndexedInts.this.bitmapIndex.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.baseIter.hasNext();
                }

                @Override
                public Integer next() {
                    return this.baseIter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void fill(int index, int[] toFill) {
            throw new UnsupportedOperationException("fill not supported");
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class DimensionAccessor {
        private final IncrementalIndex.DimensionDesc dimensionDesc;
        private final MutableBitmap[] invertedIndexes;
        private final DimensionIndexer indexer;

        public DimensionAccessor(IncrementalIndex.DimensionDesc dimensionDesc) {
            this.dimensionDesc = dimensionDesc;
            this.indexer = dimensionDesc.getIndexer();
            this.invertedIndexes = dimensionDesc.getCapabilities().hasBitmapIndexes() ? new MutableBitmap[this.indexer.getCardinality() + 1] : null;
        }
    }
}

