/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.google.common.io.InputSupplier;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class GenericIndexedWriter<T>
implements Closeable {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ObjectStrategy<T> strategy;
    private boolean objectsSorted = true;
    private T prevObject = null;
    private CountingOutputStream headerOut = null;
    private CountingOutputStream valuesOut = null;
    int numWritten = 0;

    public GenericIndexedWriter(IOPeon ioPeon, String filenameBase, ObjectStrategy<T> strategy) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
    }

    public void open() throws IOException {
        this.headerOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("header")));
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("values")));
    }

    public void write(T objectToWrite) throws IOException {
        if (this.objectsSorted && this.prevObject != null && this.strategy.compare(this.prevObject, objectToWrite) >= 0) {
            this.objectsSorted = false;
        }
        byte[] bytesToWrite = this.strategy.toBytes(objectToWrite);
        ++this.numWritten;
        this.valuesOut.write(Ints.toByteArray(bytesToWrite.length));
        this.valuesOut.write(bytesToWrite);
        this.headerOut.write(Ints.toByteArray((int)this.valuesOut.getCount()));
        this.prevObject = objectToWrite;
    }

    private String makeFilename(String suffix) {
        return String.format("%s.%s", this.filenameBase, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.headerOut.close();
        this.valuesOut.close();
        long numBytesWritten = this.headerOut.getCount() + this.valuesOut.getCount();
        Preconditions.checkState(this.headerOut.getCount() == (long)(this.numWritten * 4), "numWritten[%s] number of rows should have [%s] bytes written to headerOut, had[%s]", this.numWritten, this.numWritten * 4, this.headerOut.getCount());
        Preconditions.checkState(numBytesWritten < Integer.MAX_VALUE, "Wrote[%s] bytes, which is too many.", numBytesWritten);
        try (OutputStream metaOut = this.ioPeon.makeOutputStream(this.makeFilename("meta"));){
            metaOut.write(1);
            metaOut.write(this.objectsSorted ? 1 : 0);
            metaOut.write(Ints.toByteArray((int)numBytesWritten + 4));
            metaOut.write(Ints.toByteArray(this.numWritten));
        }
    }

    public long getSerializedSize() {
        return 10L + this.headerOut.getCount() + this.valuesOut.getCount();
    }

    public InputSupplier<InputStream> combineStreams() {
        return ByteStreams.join(Iterables.transform(Arrays.asList("meta", "header", "values"), new Function<String, InputSupplier<InputStream>>(){

            @Override
            public InputSupplier<InputStream> apply(final String input) {
                return new InputSupplier<InputStream>(){

                    @Override
                    public InputStream getInput() throws IOException {
                        return GenericIndexedWriter.this.ioPeon.makeInputStream(GenericIndexedWriter.this.makeFilename(input));
                    }
                };
            }
        }));
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        ReadableByteChannel from = Channels.newChannel(this.combineStreams().getInput());
        ByteStreams.copy(from, channel);
    }
}

