/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.query.lookup.LookupBean;
import org.apache.hive.druid.io.druid.query.lookup.LookupConfig;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupSnapshotTaker;

@ManageLifecycle
public class LookupReferencesManager {
    private static final Logger LOGGER = new Logger(LookupReferencesManager.class);
    private final ConcurrentMap<String, LookupExtractorFactory> lookupMap = new ConcurrentHashMap<String, LookupExtractorFactory>();
    private final ReadWriteLock startStopLock = new ReentrantReadWriteLock(true);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final LookupSnapshotTaker lookupSnapshotTaker;

    @Inject
    public LookupReferencesManager(LookupConfig lookupConfig, @Json ObjectMapper objectMapper) {
        this.lookupSnapshotTaker = Strings.isNullOrEmpty(lookupConfig.getSnapshotWorkingDir()) ? null : new LookupSnapshotTaker(objectMapper, lookupConfig.getSnapshotWorkingDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        this.startStopLock.writeLock().lock();
        try {
            if (!this.started.getAndSet(true)) {
                if (this.lookupSnapshotTaker != null) {
                    List<LookupBean> lookupBeanList = this.lookupSnapshotTaker.pullExistingSnapshot();
                    for (LookupBean lookupBean : lookupBeanList) {
                        this.put(lookupBean.name, lookupBean.factory);
                    }
                }
                LOGGER.info("Started lookup factory references manager", new Object[0]);
            }
        }
        finally {
            this.startStopLock.writeLock().unlock();
        }
    }

    @LifecycleStop
    public void stop() {
        this.startStopLock.writeLock().lock();
        try {
            if (this.started.getAndSet(false)) {
                if (this.lookupSnapshotTaker != null) {
                    this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
                }
                LOGGER.info("Stopping lookup factory references manager", new Object[0]);
                for (String lookupName : this.lookupMap.keySet()) {
                    ((LookupExtractorFactory)this.lookupMap.remove(lookupName)).close();
                }
            }
        }
        finally {
            this.startStopLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String lookupName, LookupExtractorFactory lookupExtractorFactory) {
        try {
            this.startStopLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        try {
            boolean noPrior;
            this.assertStarted();
            if (this.lookupMap.containsKey(lookupName)) {
                LOGGER.warn("lookup [%s] is not add, another lookup with the same name already exist", lookupName);
                boolean e = false;
                return e;
            }
            if (!lookupExtractorFactory.start()) {
                throw new ISE("start method returned false for lookup [%s]", lookupName);
            }
            boolean bl = noPrior = null == this.lookupMap.putIfAbsent(lookupName, lookupExtractorFactory);
            if (noPrior) {
                if (this.lookupSnapshotTaker != null) {
                    this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
                }
            } else if (!lookupExtractorFactory.close()) {
                throw new ISE("Error closing [%s] on race condition", lookupName);
            }
            boolean bl2 = noPrior;
            return bl2;
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Map<String, LookupExtractorFactory> lookups) {
        HashMap<String, LookupExtractorFactory> failedExtractorFactoryMap = new HashMap<String, LookupExtractorFactory>();
        try {
            this.startStopLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        try {
            this.assertStarted();
            for (Map.Entry<String, LookupExtractorFactory> entry : lookups.entrySet()) {
                String lookupName = entry.getKey();
                LookupExtractorFactory lookupExtractorFactory = entry.getValue();
                if (this.lookupMap.containsKey(lookupName)) {
                    LOGGER.warn("lookup [%s] is not add, another lookup with the same name already exist", lookupName);
                    continue;
                }
                if (!lookupExtractorFactory.start()) {
                    failedExtractorFactoryMap.put(lookupName, lookupExtractorFactory);
                    continue;
                }
                if (null != this.lookupMap.putIfAbsent(lookupName, lookupExtractorFactory)) {
                    LOGGER.warn("lookup [%s] is not add, another lookup with the same name already exist", lookupName);
                    if (lookupExtractorFactory.close()) continue;
                    LOGGER.error("Failed to properly close stale lookup [%s]", lookupExtractorFactory);
                    continue;
                }
                if (this.lookupSnapshotTaker == null) continue;
                this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
            }
            if (!failedExtractorFactoryMap.isEmpty()) {
                throw new ISE("was not able to start the following lookup(s) [%s]", failedExtractorFactoryMap.keySet().toString());
            }
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateIfNew(String lookupName, LookupExtractorFactory lookupExtractorFactory) {
        boolean update = false;
        try {
            this.startStopLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        try {
            this.assertStarted();
            LookupExtractorFactory prior = (LookupExtractorFactory)this.lookupMap.get(lookupName);
            update = lookupExtractorFactory.replaces(prior);
            if (update) {
                boolean racy;
                if (!lookupExtractorFactory.start()) {
                    throw new ISE("Could not start [%s]", lookupName);
                }
                do {
                    if (prior == null) {
                        racy = null != this.lookupMap.putIfAbsent(lookupName, lookupExtractorFactory);
                    } else {
                        boolean bl = racy = !this.lookupMap.replace(lookupName, prior, lookupExtractorFactory);
                    }
                    if (!racy) continue;
                    prior = (LookupExtractorFactory)this.lookupMap.get(lookupName);
                    update = lookupExtractorFactory.replaces(prior);
                } while (racy && update);
                if (prior != null && update && !prior.close()) {
                    LOGGER.error("Error closing [%s]:[%s]", lookupName, prior);
                }
                if (!update && !lookupExtractorFactory.close()) {
                    LOGGER.error("Error closing [%s]:[%s]", lookupExtractorFactory);
                }
            }
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String lookupName) {
        try {
            this.startStopLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        try {
            LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)this.lookupMap.remove(lookupName);
            if (lookupExtractorFactory != null) {
                LOGGER.debug("Removed lookup [%s]", lookupName);
                if (this.lookupSnapshotTaker != null) {
                    this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
                }
                boolean bl = lookupExtractorFactory.close();
                return bl;
            }
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LookupExtractorFactory get(String lookupName) {
        try {
            this.startStopLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        try {
            LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)this.lookupMap.get(lookupName);
            this.assertStarted();
            LookupExtractorFactory lookupExtractorFactory2 = lookupExtractorFactory;
            return lookupExtractorFactory2;
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    public Map<String, LookupExtractorFactory> getAll() {
        try {
            this.startStopLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        try {
            this.assertStarted();
            HashMap<String, LookupExtractorFactory> hashMap = Maps.newHashMap(this.lookupMap);
            return hashMap;
        }
        finally {
            this.startStopLock.readLock().unlock();
        }
    }

    private void assertStarted() throws ISE {
        if (this.isClosed()) {
            throw new ISE("lookup manager is closed", new Object[0]);
        }
    }

    public boolean isClosed() {
        return !this.started.get();
    }

    private List<LookupBean> getAllAsList() {
        return Lists.newArrayList(Collections2.transform(this.lookupMap.entrySet(), new Function<Map.Entry<String, LookupExtractorFactory>, LookupBean>(){

            @Override
            @Nullable
            public LookupBean apply(@Nullable Map.Entry<String, LookupExtractorFactory> input) {
                LookupBean lookupBean = new LookupBean();
                lookupBean.factory = input.getValue();
                lookupBean.name = input.getKey();
                return lookupBean;
            }
        }));
    }
}

