/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.incremental.OffheapIncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.OnheapIncrementalIndex;

public class GroupByQueryHelper {
    public static final String CTX_KEY_SORT_RESULTS = "sortResults";

    public static <T> Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>> createIndexAccumulatorPair(GroupByQuery query, GroupByQueryConfig config, StupidPool<ByteBuffer> bufferPool) {
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        QueryGranularity gran = query.getGranularity();
        long timeStart = query.getIntervals().get(0).getStartMillis();
        long granTimeStart = gran.iterable(timeStart, timeStart + 1L).iterator().next();
        List<AggregatorFactory> aggs = Lists.transform(query.getAggregatorSpecs(), new Function<AggregatorFactory, AggregatorFactory>(){

            @Override
            public AggregatorFactory apply(AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        });
        final List<String> dimensions = Lists.transform(query.getDimensions(), new Function<DimensionSpec, String>(){

            @Override
            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        });
        boolean sortResults = query.getContextValue(CTX_KEY_SORT_RESULTS, true);
        HashSet<String> otherNames = Sets.newHashSet();
        for (AggregatorFactory aggregatorFactory : aggs) {
            otherNames.add(aggregatorFactory.getName());
        }
        for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
            otherNames.add(postAggregator.getName());
        }
        ArrayList<DimensionSchema> dimensionSchemas = Lists.newArrayList();
        for (DimensionSpec dimension : query.getDimensions()) {
            if (otherNames.contains(dimension.getOutputName())) continue;
            dimensionSchemas.add(new StringDimensionSchema(dimension.getOutputName()));
        }
        IncrementalIndexSchema incrementalIndexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(dimensionSchemas, null, null)).withMetrics(aggs.toArray(new AggregatorFactory[aggs.size()])).withQueryGranularity(gran).withMinTimestamp(granTimeStart).build();
        IncrementalIndex index = query.getContextValue("useOffheap", false) != false ? new OffheapIncrementalIndex(incrementalIndexSchema, false, true, sortResults, querySpecificConfig.getMaxResults(), bufferPool) : new OnheapIncrementalIndex(incrementalIndexSchema, false, true, sortResults, querySpecificConfig.getMaxResults());
        Accumulator accumulator = new Accumulator<IncrementalIndex, T>(){

            @Override
            public IncrementalIndex accumulate(IncrementalIndex accumulated, T in) {
                if (in instanceof MapBasedRow) {
                    try {
                        MapBasedRow row = (MapBasedRow)in;
                        accumulated.add(new MapBasedInputRow(row.getTimestamp(), (List<String>)dimensions, row.getEvent()));
                    }
                    catch (IndexSizeExceededException e) {
                        throw new ResourceLimitExceededException(e.getMessage());
                    }
                } else {
                    throw new ISE("Unable to accumulate something of type [%s]", in.getClass());
                }
                return accumulated;
            }
        };
        return new Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>>(index, accumulator);
    }

    public static <T> Pair<Queue, Accumulator<Queue, T>> createBySegmentAccumulatorPair() {
        ConcurrentLinkedQueue init = new ConcurrentLinkedQueue();
        Accumulator accumulator = new Accumulator<Queue, T>(){

            @Override
            public Queue accumulate(Queue accumulated, T in) {
                if (in == null) {
                    throw new ISE("Cannot have null result", new Object[0]);
                }
                accumulated.offer(in);
                return accumulated;
            }
        };
        return new Pair<Queue, Accumulator<Queue, T>>(init, accumulator);
    }

    public static IncrementalIndex makeIncrementalIndex(GroupByQuery query, GroupByQueryConfig config, StupidPool<ByteBuffer> bufferPool, Sequence<Row> rows) {
        Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, config, bufferPool);
        return (IncrementalIndex)rows.accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
    }

    public static Sequence<Row> postAggregate(final GroupByQuery query, IncrementalIndex index) {
        return Sequences.map(Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs(), query.isDescending())), new Function<Row, Row>(){

            @Override
            public Row apply(Row input) {
                MapBasedRow row = (MapBasedRow)input;
                return new MapBasedRow(query.getGranularity().toDateTime(row.getTimestampFromEpoch()), row.getEvent());
            }
        });
    }
}

