/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;

public class HyperUniquesAggregator
implements Aggregator {
    private final String name;
    private final ObjectColumnSelector selector;
    private HyperLogLogCollector collector;

    public HyperUniquesAggregator(String name, ObjectColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.collector = HyperLogLogCollector.makeLatestCollector();
    }

    @Override
    public void aggregate() {
        this.collector.fold((HyperLogLogCollector)this.selector.get());
    }

    @Override
    public void reset() {
        this.collector = HyperLogLogCollector.makeLatestCollector();
    }

    @Override
    public Object get() {
        return HyperLogLogCollector.makeCollector(this.collector.getStorageBuffer().duplicate());
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("HyperUniquesAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("HyperUniquesAggregator does not support getLong()");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new HyperUniquesAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

