/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.guava.DefaultingHashMap;

public class CountingMap<K>
extends DefaultingHashMap<K, AtomicLong> {
    public CountingMap() {
        super(new Supplier<AtomicLong>(){

            @Override
            public AtomicLong get() {
                return new AtomicLong(0L);
            }
        });
    }

    public long add(K key, long value) {
        return ((AtomicLong)this.get(key)).addAndGet(value);
    }

    public Map<K, Long> snapshot() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.entrySet()) {
            builder.put(entry.getKey(), ((AtomicLong)entry.getValue()).get());
        }
        return builder.build();
    }
}

