/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.EmitterBuilder;
import org.apache.hive.druid.com.metamx.emitter.core.LoggingEmitter;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;

public class Emitters {
    private static final Logger log = new Logger(Emitters.class);
    private static final String LOG_EMITTER_PROP = "org.apache.hive.druid.com.metamx.emitter.logging";
    private static final String HTTP_EMITTER_PROP = "org.apache.hive.druid.com.metamx.emitter.http";

    public static Emitter create(Properties props, HttpClient httpClient, Lifecycle lifecycle) {
        return Emitters.create(props, httpClient, new ObjectMapper(), lifecycle);
    }

    public static Emitter create(Properties props, HttpClient httpClient, ObjectMapper jsonMapper, Lifecycle lifecycle) {
        HashMap<String, Map<String, Object>> jsonified = Maps.newHashMap();
        if (props.getProperty(LOG_EMITTER_PROP) != null) {
            jsonified.put("logging", Emitters.makeLoggingMap(props));
        } else if (props.getProperty(HTTP_EMITTER_PROP) != null) {
            jsonified.put("http", Emitters.makeHttpMap(props));
        } else {
            throw new ISE("Unknown type of emitter. Please set [%s] or [%s]", LOG_EMITTER_PROP, HTTP_EMITTER_PROP);
        }
        return jsonMapper.convertValue(jsonified, EmitterBuilder.class).build(jsonMapper, httpClient, lifecycle);
    }

    static Map<String, Object> makeHttpMap(Properties props) {
        HashMap<String, Object> httpMap = Maps.newHashMap();
        String urlProperty = "org.apache.hive.druid.com.metamx.emitter.http.url";
        String baseUrl = props.getProperty("org.apache.hive.druid.com.metamx.emitter.http.url");
        if (baseUrl == null) {
            throw new IAE("Property[%s] must be set", "org.apache.hive.druid.com.metamx.emitter.http.url");
        }
        httpMap.put("recipientBaseUrl", baseUrl);
        httpMap.put("flushMillis", Long.parseLong(props.getProperty("org.apache.hive.druid.com.metamx.emitter.flushMillis", "60000")));
        httpMap.put("flushCount", Integer.parseInt(props.getProperty("org.apache.hive.druid.com.metamx.emitter.flushCount", "300")));
        httpMap.put("flushTimeOut", Long.parseLong(props.getProperty("org.apache.hive.druid.com.metamx.emitter.http.flushTimeOut", String.valueOf(Long.MAX_VALUE))));
        if (props.containsKey("org.apache.hive.druid.com.metamx.emitter.http.basicAuthentication")) {
            httpMap.put("basicAuthentication", props.getProperty("org.apache.hive.druid.com.metamx.emitter.http.basicAuthentication"));
        }
        if (props.containsKey("org.apache.hive.druid.com.metamx.emitter.http.batchingStrategy")) {
            httpMap.put("batchingStrategy", props.getProperty("org.apache.hive.druid.com.metamx.emitter.http.batchingStrategy").toUpperCase());
        }
        if (props.containsKey("org.apache.hive.druid.com.metamx.emitter.http.maxBatchSize")) {
            httpMap.put("maxBatchSize", Integer.parseInt(props.getProperty("org.apache.hive.druid.com.metamx.emitter.http.maxBatchSize")));
        }
        if (props.containsKey("org.apache.hive.druid.com.metamx.emitter.http.maxBufferSize")) {
            httpMap.put("maxBufferSize", Long.parseLong(props.getProperty("org.apache.hive.druid.com.metamx.emitter.http.maxBufferSize")));
        }
        return httpMap;
    }

    static Map<String, Object> makeLoggingMap(Properties props) {
        HashMap<String, Object> loggingMap = Maps.newHashMap();
        loggingMap.put("loggerClass", props.getProperty("org.apache.hive.druid.com.metamx.emitter.logging.class", LoggingEmitter.class.getName()));
        loggingMap.put("logLevel", props.getProperty("org.apache.hive.druid.com.metamx.emitter.logging.level", "debug"));
        return loggingMap;
    }
}

