/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.HttpEmitterConfig;
import org.apache.hive.druid.com.metamx.emitter.core.HttpPostEmitter;
import org.apache.hive.druid.com.metamx.emitter.core.LoggingEmitter;
import org.apache.hive.druid.com.metamx.emitter.core.LoggingEmitterConfig;
import org.apache.hive.druid.com.metamx.emitter.core.NoopEmitter;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;

public class EmitterBuilder {
    @JsonProperty(value="http")
    private HttpEmitterConfig httpEmitterConfig = null;
    @JsonProperty(value="logging")
    private LoggingEmitterConfig loggingEmitterConfig = null;

    public HttpEmitterConfig getHttpEmitterConfig() {
        return this.httpEmitterConfig;
    }

    public void setHttpEmitterConfig(HttpEmitterConfig httpEmitterConfig) {
        this.httpEmitterConfig = httpEmitterConfig;
    }

    public LoggingEmitterConfig getLoggingEmitterConfig() {
        return this.loggingEmitterConfig;
    }

    public void setLoggingEmitterConfig(LoggingEmitterConfig loggingEmitterConfig) {
        this.loggingEmitterConfig = loggingEmitterConfig;
    }

    public Emitter build(ObjectMapper objectMapper, HttpClient httpClient, Lifecycle lifecycle) {
        if (this.loggingEmitterConfig != null) {
            return this.buildLogging(objectMapper, lifecycle);
        }
        if (this.httpEmitterConfig != null) {
            return this.buildHttp(httpClient, objectMapper, lifecycle);
        }
        return this.buildNoop(lifecycle);
    }

    public Emitter buildNoop(Lifecycle lifecycle) {
        NoopEmitter retVal = new NoopEmitter();
        lifecycle.addManagedInstance(retVal);
        return retVal;
    }

    public Emitter buildLogging(ObjectMapper objectMapper, Lifecycle lifecycle) {
        LoggingEmitter retVal = new LoggingEmitter(this.loggingEmitterConfig, objectMapper);
        lifecycle.addManagedInstance(retVal);
        return retVal;
    }

    public Emitter buildHttp(HttpClient httpClient, ObjectMapper objectMapper, Lifecycle lifecycle) {
        HttpPostEmitter retVal = new HttpPostEmitter(this.httpEmitterConfig, httpClient, objectMapper);
        lifecycle.addManagedInstance(retVal);
        return retVal;
    }
}

