/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.collections.spatial;

import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutableNode;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutablePoint;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.com.metamx.collections.spatial.Node;
import org.apache.hive.druid.com.metamx.collections.spatial.Point;
import org.apache.hive.druid.com.metamx.collections.spatial.RTree;

public class RTreeUtils {
    private static ObjectMapper jsonMapper = new ObjectMapper();

    public static double getEnclosingArea(Node a, Node b) {
        Preconditions.checkArgument(a.getNumDims() == b.getNumDims());
        double[] minCoords = new double[a.getNumDims()];
        double[] maxCoords = new double[a.getNumDims()];
        for (int i = 0; i < minCoords.length; ++i) {
            minCoords[i] = Math.min(a.getMinCoordinates()[i], b.getMinCoordinates()[i]);
            maxCoords[i] = Math.max(a.getMaxCoordinates()[i], b.getMaxCoordinates()[i]);
        }
        double area = 1.0;
        for (int i = 0; i < minCoords.length; ++i) {
            area *= maxCoords[i] - minCoords[i];
        }
        return area;
    }

    public static double getExpansionCost(Node node, Point point) {
        Preconditions.checkArgument(node.getNumDims() == point.getNumDims());
        if (node.contains(point.getCoords())) {
            return 0.0;
        }
        double expanded = 1.0;
        for (int i = 0; i < node.getNumDims(); ++i) {
            double min = Math.min(point.getCoords()[i], node.getMinCoordinates()[i]);
            double max = Math.max(point.getCoords()[i], node.getMinCoordinates()[i]);
            expanded *= max - min;
        }
        return expanded - node.getArea();
    }

    public static void enclose(Node[] nodes) {
        for (Node node : nodes) {
            node.enclose();
        }
    }

    public static Iterable<ImmutablePoint> getBitmaps(ImmutableRTree tree) {
        return RTreeUtils.depthFirstSearch(tree.getRoot());
    }

    public static Iterable<ImmutablePoint> depthFirstSearch(ImmutableNode node) {
        if (node.isLeaf()) {
            return Iterables.transform(node.getChildren(), new Function<ImmutableNode, ImmutablePoint>(){

                @Override
                public ImmutablePoint apply(ImmutableNode tNode) {
                    return new ImmutablePoint(tNode);
                }
            });
        }
        return Iterables.concat(Iterables.transform(node.getChildren(), new Function<ImmutableNode, Iterable<ImmutablePoint>>(){

            @Override
            public Iterable<ImmutablePoint> apply(ImmutableNode child) {
                return RTreeUtils.depthFirstSearch(child);
            }
        }));
    }

    public static void print(RTree tree) {
        System.out.printf("numDims : %d%n", tree.getNumDims());
        try {
            RTreeUtils.printRTreeNode(tree.getRoot(), 0);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static void print(ImmutableRTree tree) {
        System.out.printf("numDims : %d%n", tree.getNumDims());
        try {
            RTreeUtils.printNode(tree.getRoot(), 0);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static void printRTreeNode(Node node, int level) throws Exception {
        System.out.printf("%sminCoords: %s, maxCoords: %s, numChildren: %d, isLeaf:%s%n", RTreeUtils.makeDashes(level), jsonMapper.writeValueAsString(node.getMinCoordinates()), jsonMapper.writeValueAsString(node.getMaxCoordinates()), node.getChildren().size(), node.isLeaf());
        if (node.isLeaf()) {
            for (Node child : node.getChildren()) {
                Point point = (Point)child;
                System.out.printf("%scoords: %s, conciseSet: %s%n", RTreeUtils.makeDashes(level), jsonMapper.writeValueAsString(point.getCoords()), point.getBitmap());
            }
        } else {
            ++level;
            for (Node child : node.getChildren()) {
                RTreeUtils.printRTreeNode(child, level);
            }
        }
    }

    public static boolean verifyEnclose(Node node) {
        for (Node child : node.getChildren()) {
            for (int i = 0; i < node.getNumDims(); ++i) {
                if (!(child.getMinCoordinates()[i] < node.getMinCoordinates()[i]) && !(child.getMaxCoordinates()[i] > node.getMaxCoordinates()[i])) continue;
                return false;
            }
        }
        if (!node.isLeaf()) {
            for (Node child : node.getChildren()) {
                if (RTreeUtils.verifyEnclose(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean verifyEnclose(ImmutableNode node) {
        for (ImmutableNode child : node.getChildren()) {
            for (int i = 0; i < node.getNumDims(); ++i) {
                if (!(child.getMinCoordinates()[i] < node.getMinCoordinates()[i]) && !(child.getMaxCoordinates()[i] > node.getMaxCoordinates()[i])) continue;
                return false;
            }
        }
        if (!node.isLeaf()) {
            for (ImmutableNode child : node.getChildren()) {
                if (RTreeUtils.verifyEnclose(child)) continue;
                return false;
            }
        }
        return true;
    }

    private static void printNode(ImmutableNode node, int level) throws Exception {
        System.out.printf("%sminCoords: %s, maxCoords: %s, numChildren: %d, isLeaf: %s%n", RTreeUtils.makeDashes(level), jsonMapper.writeValueAsString(node.getMinCoordinates()), jsonMapper.writeValueAsString(node.getMaxCoordinates()), node.getNumChildren(), node.isLeaf());
        if (node.isLeaf()) {
            for (ImmutableNode immutableNode : node.getChildren()) {
                ImmutablePoint point = new ImmutablePoint(immutableNode);
                System.out.printf("%scoords: %s, conciseSet: %s%n", RTreeUtils.makeDashes(level), jsonMapper.writeValueAsString(point.getCoords()), point.getImmutableBitmap());
            }
        } else {
            ++level;
            for (ImmutableNode immutableNode : node.getChildren()) {
                RTreeUtils.printNode(immutableNode, level);
            }
        }
    }

    private static String makeDashes(int level) {
        String retVal = "";
        for (int i = 0; i < level; ++i) {
            retVal = retVal + "-";
        }
        return retVal;
    }
}

