/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public final class LocalDateTimeSerializer
extends JodaDateSerializerBase<LocalDateTime> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(DEFAULT_LOCAL_DATETIME_FORMAT);

    public LocalDateTimeSerializer() {
        this(DEFAULT_FORMAT);
    }

    public LocalDateTimeSerializer(JacksonJodaFormat format) {
        super(LocalDateTime.class, format);
    }

    public LocalDateTimeSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new LocalDateTimeSerializer(formatter);
    }

    @Override
    public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value.year().get());
            jgen.writeNumber(value.monthOfYear().get());
            jgen.writeNumber(value.dayOfMonth().get());
            jgen.writeNumber(value.hourOfDay().get());
            jgen.writeNumber(value.minuteOfHour().get());
            jgen.writeNumber(value.secondOfMinute().get());
            jgen.writeNumber(value.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print((ReadablePartial)value));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "array" : "string", true);
    }
}

