/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Random;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.UnsignedInt128;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDecimal128 {
    private Decimal128 zero;
    private Decimal128 one;
    private Decimal128 two;

    @Before
    public void setUp() throws Exception {
        this.zero = new Decimal128(0L);
        this.one = new Decimal128(1L);
        this.two = new Decimal128(2L);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCalculateTenThirtySeven() {
        Decimal128 ten = new Decimal128(10L, 0);
        Decimal128 val = new Decimal128(1L, 0);
        for (int i = 0; i < 37; ++i) {
            val.multiplyDestructive(ten, (short)0);
        }
        String s = val.toFormalString();
        Assert.assertEquals((Object)"10000000000000000000000000000000000000", (Object)s);
        boolean overflow = false;
    }

    @Test
    public void testHashCode() {
        Assert.assertTrue((this.one.hashCode() != this.two.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.hashCode() != this.one.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.hashCode() != this.two.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)this.zero.hashCode(), (long)new Decimal128(0L).hashCode());
        Assert.assertEquals((long)this.one.hashCode(), (long)new Decimal128(1L).hashCode());
        Assert.assertEquals((long)this.two.hashCode(), (long)new Decimal128(2L).hashCode());
        Decimal128 oneScaled = new Decimal128(1L, 3);
        oneScaled.changeScaleDestructive((short)0);
        Assert.assertEquals((long)this.one.hashCode(), (long)oneScaled.hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((!this.one.equals((Object)this.two) ? 1 : 0) != 0);
        Assert.assertTrue((!this.zero.equals((Object)this.one) ? 1 : 0) != 0);
        Assert.assertTrue((!this.zero.equals((Object)this.two) ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.zero, (Object)new Decimal128(0L));
        Assert.assertEquals((Object)this.one, (Object)new Decimal128(1L));
        Assert.assertEquals((Object)this.two, (Object)new Decimal128(2L));
        Decimal128 oneScaled = new Decimal128(1L, 3);
        oneScaled.changeScaleDestructive((short)0);
        Assert.assertEquals((Object)this.one, (Object)oneScaled);
    }

    @Test
    public void testCompareTo() {
        Assert.assertTrue((this.one.compareTo(this.two) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.two.compareTo(this.one) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.zero) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareTo(this.two) < 0 ? 1 : 0) != 0);
        Decimal128 oneScaled = new Decimal128(1L, 3);
        Assert.assertTrue((this.one.compareTo(oneScaled) == 0 ? 1 : 0) != 0);
        Decimal128 d1 = new Decimal128(2.0, 6);
        Decimal128 d2 = new Decimal128(2.0, 3);
        Assert.assertTrue((d1.compareTo(d2) == 0 ? 1 : 0) != 0);
        Decimal128 d3 = new Decimal128(0.6666666666666666, 5);
        Decimal128 d4 = new Decimal128(0.6666666666666666, 8);
        Assert.assertTrue((d3.compareTo(d4) != 0 ? 1 : 0) != 0);
        Decimal128 d5 = new Decimal128(12L, 5);
        Decimal128 d6 = new Decimal128(15L, 7);
        Assert.assertTrue((d5.compareTo(d6) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((d6.compareTo(d5) > 0 ? 1 : 0) != 0);
        Decimal128 d7 = new Decimal128(15L, 5);
        Decimal128 d8 = new Decimal128(12L, 7);
        Assert.assertTrue((d7.compareTo(d8) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d8.compareTo(d7) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testText() {
        Assert.assertEquals((Object)"1", (Object)this.one.toFormalString());
        Assert.assertEquals((long)0L, (long)new Decimal128("1", 0).compareTo(this.one));
        Assert.assertEquals((Object)"2", (Object)this.two.toFormalString());
        Assert.assertEquals((long)0L, (long)new Decimal128("2", 0).compareTo(this.two));
        Assert.assertEquals((Object)"0", (Object)this.zero.toFormalString());
        Assert.assertEquals((long)0L, (long)new Decimal128("0", 0).compareTo(this.zero));
        Assert.assertEquals((Object)"1.000", (Object)new Decimal128(1L, 3).toFormalString());
        Assert.assertEquals((long)0L, (long)new Decimal128("1", 3).compareTo(this.one));
        Assert.assertEquals((Object)"2.000000", (Object)new Decimal128(2.0, 6).toFormalString());
        Assert.assertEquals((Object)"2.000", (Object)new Decimal128(2.0, 3).toFormalString());
        Assert.assertEquals((long)0L, (long)new Decimal128("2.0", 6).compareTo(this.two));
        Assert.assertEquals((long)0L, (long)new Decimal128("2.0", 3).compareTo(this.two));
        Assert.assertEquals((Object)"1.3330", (Object)new Decimal128("1.333", 4).toFormalString());
        Assert.assertEquals((Object)"1.333000", (Object)new Decimal128("1.333", 6).toFormalString());
        Assert.assertEquals((Object)"1.333", (Object)new Decimal128("1.333", 3).toFormalString());
        Assert.assertEquals((Object)"1.33", (Object)new Decimal128("1.333", 2).toFormalString());
        Assert.assertEquals((Object)"1.33", (Object)new Decimal128("1.333", 2).toFormalString());
        Assert.assertEquals((Object)"0.13330", (Object)new Decimal128("1333E-4", 5).toFormalString());
        Assert.assertEquals((Object)"0.01333", (Object)new Decimal128("1333E-5", 5).toFormalString());
        Assert.assertEquals((Object)"13330000.00", (Object)new Decimal128("1333E4", 2).toFormalString());
        Assert.assertEquals((Object)"123456789012345678901234.56789", (Object)new Decimal128("123456789012345678901234567.8901234E-3", 5).toFormalString());
    }

    @Test
    public void testAdd() {
        Decimal128 result = new Decimal128();
        Decimal128.add((Decimal128)this.one, (Decimal128)this.two, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(3L, 0).compareTo(result));
        Decimal128.add((Decimal128)this.two, (Decimal128)this.two, (Decimal128)result, (short)1);
        Assert.assertEquals((long)0L, (long)new Decimal128(4L, 0).compareTo(result));
        long l1 = 123456789012345L;
        long l2 = 987654321097L;
        long sum = l1 + l2;
        Decimal128 left = new Decimal128(l1, 3);
        Decimal128 right = new Decimal128(l2, 5);
        Decimal128.add((Decimal128)left, (Decimal128)right, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(sum, 0).compareTo(result));
        Decimal128.add((Decimal128)right, (Decimal128)left, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(sum, 0).compareTo(result));
    }

    @Test
    public void testSubtract() {
        Decimal128 result = new Decimal128();
        Decimal128.subtract((Decimal128)this.one, (Decimal128)this.two, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(-1L, 0).compareTo(result));
        Decimal128.subtract((Decimal128)this.two, (Decimal128)this.one, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(1L, 0).compareTo(result));
        Decimal128.subtract((Decimal128)this.two, (Decimal128)this.two, (Decimal128)result, (short)1);
        Assert.assertEquals((long)0L, (long)this.zero.compareTo(result));
        Assert.assertEquals((long)0L, (long)result.getSignum());
        long l1 = 123456789012345L;
        long l2 = 987654321097L;
        long sub = l1 - l2;
        Decimal128 left = new Decimal128(l1, 3);
        Decimal128 right = new Decimal128(l2, 5);
        Decimal128.subtract((Decimal128)left, (Decimal128)right, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(sub, 0).compareTo(result));
        Decimal128.subtract((Decimal128)right, (Decimal128)left, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(-sub, 0).compareTo(result));
        Decimal128 val = new Decimal128("1.123", 3);
        val.addDestructive(new Decimal128("4.321", 3), (short)3);
        Assert.assertEquals((Object)"5.444", (Object)val.toFormalString());
    }

    @Test
    public void testMultiply() {
        Decimal128 result = new Decimal128();
        Decimal128.multiply((Decimal128)this.one, (Decimal128)this.two, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)this.two.compareTo(result));
        Decimal128.multiply((Decimal128)this.two, (Decimal128)this.two, (Decimal128)result, (short)2);
        Assert.assertEquals((long)0L, (long)new Decimal128(4L, 0).compareTo(result));
        long l1 = 123456789012345L;
        long l2 = 987654321097L;
        Decimal128 left = new Decimal128(l1, 0);
        Decimal128 right = new Decimal128(l2, 0);
        UnsignedInt128 unscaled = new UnsignedInt128(l1).multiplyConstructive(new UnsignedInt128(l2));
        Decimal128 ans = new Decimal128(unscaled, 0, false);
        Decimal128.multiply((Decimal128)left, (Decimal128)right, (Decimal128)result, (short)0);
        Assert.assertEquals((long)0L, (long)ans.compareTo(result));
        Decimal128.multiply((Decimal128)right, (Decimal128)left, (Decimal128)result, (short)0);
        Assert.assertEquals((long)0L, (long)ans.compareTo(result));
        Decimal128.multiply((Decimal128)new Decimal128(1.123, 10), (Decimal128)new Decimal128(4.321, 10), (Decimal128)result, (short)10);
        Assert.assertEquals((double)4.852482999999999, (double)result.doubleValue(), (double)1.0E-5);
        this.assertNotEquals(4.852482999999999, result.doubleValue(), 1.0E-17);
        Decimal128.multiply((Decimal128)new Decimal128(1.123, 2), (Decimal128)new Decimal128(4.321, 2), (Decimal128)result, (short)2);
        Assert.assertEquals((double)4.852482999999999, (double)result.doubleValue(), (double)1.0);
        this.assertNotEquals(4.852482999999999, result.doubleValue(), 1.0E-6);
        Decimal128 val = new Decimal128("1.123", 3);
        val.multiplyDestructive(new Decimal128("4.321", 3), (short)6);
        Assert.assertEquals((Object)"4.852483", (Object)val.toFormalString());
        Decimal128 val1 = new Decimal128("1.0001", 4);
        val1.multiplyDestructive(new Decimal128("1.0001", 4), (short)8);
        Assert.assertEquals((Object)"1.00020001", (Object)val1.toFormalString());
    }

    private void assertNotEquals(double a, double b, double epsilon) {
        Assert.assertTrue((Math.abs(a - b) > epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testDivide() {
        Decimal128 quotient = new Decimal128();
        Decimal128.divide((Decimal128)this.two, (Decimal128)this.one, (Decimal128)quotient, (short)2);
        Assert.assertEquals((long)0L, (long)quotient.compareTo(this.two));
        Decimal128.divide((Decimal128)this.two, (Decimal128)this.two, (Decimal128)quotient, (short)2);
        Assert.assertEquals((long)0L, (long)quotient.compareTo(this.one));
        Decimal128 three = new Decimal128(3L);
        Decimal128 four = new Decimal128(4L);
        Decimal128.divide((Decimal128)three, (Decimal128)four, (Decimal128)quotient, (short)2);
        Assert.assertEquals((Object)"0.75", (Object)quotient.toFormalString());
        Decimal128.divide((Decimal128)three, (Decimal128)four, (Decimal128)quotient, (short)1);
        Assert.assertEquals((Object)"0.8", (Object)quotient.toFormalString());
        Decimal128.divide((Decimal128)three, (Decimal128)four, (Decimal128)quotient, (short)0);
        Assert.assertEquals((Object)"1", (Object)quotient.toFormalString());
        Decimal128 two = new Decimal128(2L);
        Decimal128.divide((Decimal128)two, (Decimal128)three, (Decimal128)quotient, (short)4);
        Assert.assertEquals((Object)"0.6667", (Object)quotient.toFormalString());
    }

    @Test
    public void testRandomMultiplyDivideInverse() {
        int N = 100000;
        long MASK56 = 0xFFFFFFFFFFFFL;
        int seed = 897089790;
        Random rand = new Random(seed);
        for (int i = 1; i <= 100000; ++i) {
            long l1 = rand.nextLong() & 0xFFFFFFFFFFFFL;
            long l2 = rand.nextLong() & 0xFFFFFFFFFFFFL;
            this.verifyMultiplyDivideInverse(l1, l2);
        }
    }

    private void verifyMultiplyDivideInverse(long a, long b) {
        boolean scale = false;
        if (b == 0L) {
            return;
        }
        Decimal128 decA = new Decimal128(a, 0);
        Decimal128 decB = new Decimal128(b, 0);
        decA.multiplyDestructive(decB, (short)0);
        decA.checkPrecisionOverflow(38);
        decA.divideDestructive(decB, (short)0);
        Assert.assertEquals((String)("Error for a = " + Long.toString(a) + ", b = " + Long.toString(b)), (Object)new Decimal128(a, 0), (Object)decA);
    }

    @Test
    public void testRandomAddSubtractInverse() {
        int N = 1000000;
        int seed = 1427480960;
        Random rand = new Random(seed);
        for (int i = 1; i <= 1000000; ++i) {
            long l1 = rand.nextLong();
            long l2 = rand.nextLong();
            this.verifyAddSubtractInverse(l1, l2);
        }
    }

    private void verifyAddSubtractInverse(long a, long b) {
        boolean scale = false;
        Decimal128 decA = new Decimal128(a, 0);
        Decimal128 decB = new Decimal128(b, 0);
        decA.addDestructive(decB, (short)0);
        decA.subtractDestructive(decB, (short)0);
        Assert.assertEquals((String)("Error for a = " + Long.toString(a) + ", b = " + Long.toString(b)), (Object)new Decimal128(a, 0), (Object)decA);
    }

    @Test
    public void testKnownPriorErrors() {
        long a = 213474114411690L;
        long b = 5062120663L;
        this.verifyMultiplyDivideInverse(a, b);
        String a2 = "-605044214913338382";
        String b2 = "55269579109718297360";
        this.verifyHighPrecisionMultiplySingle(a2, b2);
    }

    @Test
    public void testHighPrecisionDecimal128Add() {
        int N = 10000;
        for (int i = 0; i < 10000; ++i) {
            this.verifyHighPrecisionAddSingle();
        }
    }

    private void verifyHighPrecisionAddSingle() {
        Decimal128 a = new Decimal128();
        String sA = this.makeNumericString(37);
        a.update(sA, (short)0);
        Decimal128 b = new Decimal128();
        String sB = this.makeNumericString(37);
        b.update(sB, (short)0);
        Decimal128 r = new Decimal128();
        r.addDestructive(a, (short)0);
        r.addDestructive(b, (short)0);
        String res1 = r.toFormalString();
        BigDecimal bdA = new BigDecimal(sA);
        BigDecimal bdB = new BigDecimal(sB);
        BigDecimal bdR = bdA.add(bdB);
        String res2 = bdR.toPlainString();
        String message = "For operation " + a.toFormalString() + " + " + b.toFormalString();
        Assert.assertEquals((String)message, (Object)res2, (Object)res1);
    }

    @Test
    public void testHighPrecisionDecimal128Subtract() {
        int N = 10000;
        for (int i = 0; i < 10000; ++i) {
            this.verifyHighPrecisionSubtractSingle();
        }
    }

    private void verifyHighPrecisionSubtractSingle() {
        Decimal128 a = new Decimal128();
        String sA = this.makeNumericString(37);
        a.update(sA, (short)0);
        Decimal128 b = new Decimal128();
        String sB = this.makeNumericString(37);
        b.update(sB, (short)0);
        Decimal128 r = new Decimal128();
        r.addDestructive(a, (short)0);
        r.subtractDestructive(b, (short)0);
        String res1 = r.toFormalString();
        BigDecimal bdA = new BigDecimal(sA);
        BigDecimal bdB = new BigDecimal(sB);
        BigDecimal bdR = bdA.subtract(bdB);
        String res2 = bdR.toPlainString();
        String message = "For operation " + a.toFormalString() + " - " + b.toFormalString();
        Assert.assertEquals((String)message, (Object)res2, (Object)res1);
    }

    @Test
    public void testHighPrecisionDecimal128Multiply() {
        int N = 10000;
        for (int i = 0; i < 10000; ++i) {
            this.verifyHighPrecisionMultiplySingle();
        }
    }

    private void verifyHighPrecisionMultiplySingle() {
        int bDigits;
        Random rand = new Random();
        int aDigits = rand.nextInt(37) + 1;
        Assert.assertTrue((aDigits + (bDigits = 38 - aDigits) == 38 && aDigits > 0 && bDigits > 0 ? 1 : 0) != 0);
        Decimal128 a = new Decimal128();
        String sA = this.makeNumericString(aDigits);
        a.update(sA, (short)0);
        Decimal128 b = new Decimal128();
        String sB = this.makeNumericString(bDigits);
        b.update(sB, (short)0);
        Decimal128 r = new Decimal128();
        r.addDestructive(a, (short)0);
        r.multiplyDestructive(b, (short)0);
        String res1 = r.toFormalString();
        BigDecimal bdA = new BigDecimal(sA);
        BigDecimal bdB = new BigDecimal(sB);
        BigDecimal bdR = bdA.multiply(bdB);
        String res2 = bdR.toPlainString();
        String message = "For operation " + a.toFormalString() + " * " + b.toFormalString();
        Assert.assertEquals((String)message, (Object)res2, (Object)res1);
    }

    private void verifyHighPrecisionMultiplySingle(String argA, String argB) {
        int aDigits = argA.length();
        int bDigits = argB.length();
        Assert.assertTrue(((aDigits -= argA.charAt(0) == '-' ? 1 : 0) + (bDigits -= argB.charAt(0) == '-' ? 1 : 0) <= 38 && aDigits > 0 && bDigits > 0 ? 1 : 0) != 0);
        Decimal128 a = new Decimal128();
        String sA = argA;
        a.update(sA, (short)0);
        Decimal128 b = new Decimal128();
        String sB = argB;
        b.update(sB, (short)0);
        Decimal128 r = new Decimal128();
        r.addDestructive(a, (short)0);
        r.multiplyDestructive(b, (short)0);
        String res1 = r.toFormalString();
        BigDecimal bdA = new BigDecimal(sA);
        BigDecimal bdB = new BigDecimal(sB);
        BigDecimal bdR = bdA.multiply(bdB);
        String res2 = bdR.toPlainString();
        String message = "For operation " + a.toFormalString() + " * " + b.toFormalString();
        Assert.assertEquals((String)message, (Object)res2, (Object)res1);
    }

    @Test
    public void testHighPrecisionDecimal128Divide() {
        int N = 10000;
        for (int i = 0; i < 10000; ++i) {
            this.verifyHighPrecisionDivideSingle();
        }
    }

    private void verifyHighPrecisionDivideSingle() {
        Random rand = new Random();
        int aDigits = rand.nextInt(37) + 1;
        int bDigits = 38 - aDigits;
        if (bDigits > aDigits) {
            int temp = aDigits;
            aDigits = bDigits;
            bDigits = temp;
        }
        if (bDigits == aDigits) {
            return;
        }
        Assert.assertTrue((aDigits + bDigits == 38 && aDigits > 0 && bDigits > 0 ? 1 : 0) != 0);
        Decimal128 a = new Decimal128();
        String sA = this.makeNumericString(aDigits);
        a.update(sA, (short)0);
        Decimal128 b = new Decimal128();
        String sB = this.makeNumericString(bDigits);
        b.update(sB, (short)0);
        if (b.isZero()) {
            return;
        }
        Decimal128 r = new Decimal128();
        r.addDestructive(a, (short)0);
        r.divideDestructive(b, (short)0);
        String res1 = r.toFormalString();
        BigDecimal bdA = new BigDecimal(sA);
        BigDecimal bdB = new BigDecimal(sB);
        BigDecimal bdR = bdA.divide(bdB, 0, RoundingMode.HALF_UP);
        String res2 = bdR.toPlainString();
        String message = "For operation " + a.toFormalString() + " / " + b.toFormalString();
        Assert.assertEquals((String)message, (Object)res2, (Object)res1);
    }

    private String makeNumericString(int length) {
        Random r = new Random();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            b.append(r.nextInt(10));
        }
        String sign = r.nextInt(2) == 0 ? "-" : "";
        return sign + b.toString();
    }

    @Test
    public void testPiNewton() {
        int LOOPS = 100;
        int SCALE = 33;
        Decimal128 current = new Decimal128(1L, 33);
        Decimal128 multiplier = new Decimal128();
        Decimal128 dividor = new Decimal128();
        Decimal128 one = new Decimal128(1L);
        for (int i = 100; i > 0; --i) {
            multiplier.update((long)i, (short)33);
            current.multiplyDestructive(multiplier, (short)33);
            dividor.update((long)(1 + 2 * i), (short)33);
            current.divideDestructive(dividor, (short)33);
            current.addDestructive(one, (short)33);
        }
        current.multiplyDestructive(new Decimal128(2L), (short)33);
        Assert.assertTrue((boolean)current.toFormalString().startsWith("3.141592653589793238"));
    }

    @Test
    public void testPiArcsine() {
        int LOOPS = 50;
        int SCALE = 30;
        Decimal128 total = new Decimal128(0L);
        Decimal128 multiplier = new Decimal128();
        Decimal128 dividor = new Decimal128();
        Decimal128 current = new Decimal128();
        for (int i = 0; i < 50; ++i) {
            current.update(3L, (short)30);
            dividor.update((long)(2 * i + 1), (short)30);
            current.divideDestructive(dividor, (short)30);
            for (int j = 1; j <= i; ++j) {
                multiplier.update((long)(i + j), (short)30);
                dividor.update((long)(16 * j), (short)30);
                current.multiplyDestructive(multiplier, (short)30);
                current.divideDestructive(dividor, (short)30);
            }
            total.addDestructive(current, (short)30);
        }
        Assert.assertTrue((boolean)total.toFormalString().startsWith("3.141592653589793238462"));
    }

    @Test
    public void testDoubleValue() {
        Decimal128 quotient = new Decimal128();
        Decimal128 three = new Decimal128(3L);
        Decimal128 four = new Decimal128(9L);
        Decimal128.divide((Decimal128)three, (Decimal128)four, (Decimal128)quotient, (short)38);
        Assert.assertEquals((double)0.3333333333333333, (double)quotient.doubleValue(), (double)1.0E-25);
        Decimal128 minusThree = new Decimal128(-3L);
        Decimal128.divide((Decimal128)minusThree, (Decimal128)four, (Decimal128)quotient, (short)38);
        Assert.assertEquals((double)-0.3333333333333333, (double)quotient.doubleValue(), (double)1.0E-25);
    }

    @Test
    public void testFloatValue() {
        Decimal128 quotient = new Decimal128();
        Decimal128 three = new Decimal128(3L);
        Decimal128 four = new Decimal128(9L);
        Decimal128.divide((Decimal128)three, (Decimal128)four, (Decimal128)quotient, (short)38);
        Assert.assertEquals((float)0.33333334f, (float)quotient.floatValue(), (float)1.0E-11f);
        Decimal128 minusThree = new Decimal128(-3L);
        Decimal128.divide((Decimal128)minusThree, (Decimal128)four, (Decimal128)quotient, (short)38);
        Assert.assertEquals((float)-0.33333334f, (float)quotient.floatValue(), (float)1.0E-11f);
    }

    @Test
    public void testSqrtAsDouble() {
        Decimal128 val1 = new Decimal128("1.00435134913958923485982394892384", 36);
        Decimal128 val2 = new Decimal128("1.00345982739817298323423423", 36);
        Assert.assertEquals((double)1.00217331292526, (double)val1.sqrtAsDouble(), (double)1.0E-15);
        Assert.assertEquals((double)1.00172841998127, (double)val2.sqrtAsDouble(), (double)1.0E-15);
    }

    @Test
    public void testPowAsDouble() {
        Decimal128 val1 = new Decimal128("1.00435134913958923485982394892384", 36);
        Assert.assertEquals((double)1.004366436877081, (double)val1.powAsDouble(1.003459827398173), (double)1.0E-15);
        Decimal128 val2 = new Decimal128("1.001", 36);
        Assert.assertEquals((double)1.0100451202102512, (double)val2.powAsDouble(10.0), (double)1.0E-15);
    }

    @Test
    public void testPrecisionOverflow() {
        new Decimal128("1.004", 3).checkPrecisionOverflow(4);
        try {
            new Decimal128("1.004", 3).checkPrecisionOverflow(3);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        try {
            new Decimal128("1.004", 3).checkPrecisionOverflow(2);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        new Decimal128("1.004", 3).checkPrecisionOverflow(38);
        new Decimal128("-3322", 0).checkPrecisionOverflow(4);
        try {
            new Decimal128("-3322", 0).checkPrecisionOverflow(3);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        new Decimal128("-3322", 1).checkPrecisionOverflow(5);
        try {
            new Decimal128("-3322", 1).checkPrecisionOverflow(4);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        new Decimal128("0.99999999999999999999999999999999999999", 38).checkPrecisionOverflow(38);
        try {
            new Decimal128("0.99999999999999999999999999999999999999", 38).checkPrecisionOverflow(37);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        new Decimal128("99999999999999999999999999999999999999", 0).checkPrecisionOverflow(38);
        try {
            new Decimal128("99999999999999999999999999999999999999", 0).checkPrecisionOverflow(37);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testToLong() {
        Decimal128 d = new Decimal128("1.25", 2);
        Assert.assertEquals((long)1L, (long)d.longValue());
        d.update("4294967295", (short)0);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)d.longValue());
        d.update("4294967296", (short)0);
        Assert.assertEquals((long)0x100000000L, (long)d.longValue());
        d.update("-4294967295", (short)0);
        Assert.assertEquals((long)-4294967295L, (long)d.longValue());
        d.update("-4294967296", (short)0);
        Assert.assertEquals((long)-4294967296L, (long)d.longValue());
        d.update("4294967295.01", (short)2);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)d.longValue());
        d.update("4294967296.01", (short)2);
        Assert.assertEquals((long)0x100000000L, (long)d.longValue());
        d.update(37.678, (short)5);
        HiveDecimal hd = HiveDecimal.create((BigDecimal)BigDecimal.valueOf(37.678));
        Assert.assertEquals((long)hd.longValue(), (long)d.longValue());
    }

    @Test
    public void testToHiveDecimalString() {
        Decimal128 d1 = new Decimal128("4134.923076923077", 15);
        Assert.assertEquals((Object)"4134.923076923077", (Object)d1.getHiveDecimalString());
        Decimal128 d2 = new Decimal128("0.00923076923", 15);
        Assert.assertEquals((Object)"0.00923076923", (Object)d2.getHiveDecimalString());
        Decimal128 d3 = new Decimal128("0.00923076000", 15);
        Assert.assertEquals((Object)"0.00923076", (Object)d3.getHiveDecimalString());
        Decimal128 d4 = new Decimal128("4294967296.01", 15);
        Assert.assertEquals((Object)"4294967296.01", (Object)d4.getHiveDecimalString());
        Decimal128 d5 = new Decimal128("4294967296.01", 2);
        Assert.assertEquals((Object)"4294967296.01", (Object)d5.getHiveDecimalString());
        Decimal128 d6 = new Decimal128();
        HiveDecimal hd1 = HiveDecimal.create((BigInteger)new BigInteger("42949672"));
        d6.update(hd1.bigDecimalValue());
        Assert.assertEquals((Object)hd1.toString(), (Object)d6.getHiveDecimalString());
        Decimal128 d7 = new Decimal128();
        HiveDecimal hd2 = HiveDecimal.create((BigDecimal)new BigDecimal("0.0"));
        d7.update(hd2.bigDecimalValue());
        Assert.assertEquals((Object)hd2.toString(), (Object)d7.getHiveDecimalString());
        Decimal128 d8 = new Decimal128();
        HiveDecimal hd3 = HiveDecimal.create((BigDecimal)new BigDecimal("0.00023000"));
        d8.update(hd3.bigDecimalValue());
        Assert.assertEquals((Object)hd3.toString(), (Object)d8.getHiveDecimalString());
        Decimal128 d9 = new Decimal128();
        HiveDecimal hd4 = HiveDecimal.create((BigDecimal)new BigDecimal("0.1"));
        d9.update(hd4.bigDecimalValue());
        Assert.assertEquals((Object)hd4.toString(), (Object)d9.getHiveDecimalString());
        Decimal128 d10 = new Decimal128();
        HiveDecimal hd5 = HiveDecimal.create((BigDecimal)new BigDecimal("-00.100"));
        d10.update(hd5.bigDecimalValue());
        Assert.assertEquals((Object)hd5.toString(), (Object)d10.getHiveDecimalString());
        Decimal128 d11 = new Decimal128();
        HiveDecimal hd6 = HiveDecimal.create((BigDecimal)new BigDecimal("00.1"));
        d11.update(hd6.bigDecimalValue());
        Assert.assertEquals((Object)hd6.toString(), (Object)d11.getHiveDecimalString());
        Decimal128 d12 = new Decimal128(27.0, 3);
        HiveDecimal hd7 = HiveDecimal.create((BigDecimal)new BigDecimal("27.000"));
        Assert.assertEquals((Object)hd7.toString(), (Object)d12.getHiveDecimalString());
        Assert.assertEquals((Object)"27", (Object)d12.getHiveDecimalString());
        Decimal128 d13 = new Decimal128(1234123000L, 3);
        HiveDecimal hd8 = HiveDecimal.create((BigDecimal)new BigDecimal("1234123000"));
        Assert.assertEquals((Object)hd8.toString(), (Object)d13.getHiveDecimalString());
        Assert.assertEquals((Object)"1234123000", (Object)d13.getHiveDecimalString());
    }

    @Test
    public void testUpdateWithScale() {
        Decimal128 d1 = new Decimal128(1234.123, 4);
        Decimal128 d2 = new Decimal128(0L, 3);
        d2.update(d1, (short)3);
        Assert.assertEquals((long)0L, (long)d1.compareTo(d2));
    }
}

