/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.hive.common.jsonexplain.Connection;
import org.apache.hadoop.hive.common.jsonexplain.DagJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.Op;
import org.apache.hadoop.hive.common.jsonexplain.Vertex;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOp {
    private ObjectMapper objectMapper = new ObjectMapper();
    private TezJsonParser tezJsonParser;

    @Before
    public void setUp() throws Exception {
        this.tezJsonParser = new TezJsonParser();
    }

    @Test
    public void testInlineJoinOpJsonHandling() throws Exception {
        String jsonString = "{\"input vertices:\":{\"a\":\"AVERTEX\"},\"condition map:\": [{\"c1\": \"{\\\"type\\\": \\\"type\\\", \\\"left\\\": \\\"left\\\", \\\"right\\\": \\\"right\\\"}\"}],\"keys:\":{\"left\":\"AKEY\", \"right\":\"BKEY\"}}";
        JSONObject mapJoin = new JSONObject(jsonString);
        Vertex vertexB = new Vertex("vertex-b", null, null, (DagJsonParser)this.tezJsonParser);
        Op dummyOp = new Op("Dummy Op", "dummy-id", "output-vertex-name", null, Collections.EMPTY_LIST, null, mapJoin, null, (DagJsonParser)this.tezJsonParser);
        vertexB.outputOps.add(dummyOp);
        Vertex vertexC = new Vertex("vertex-c", null, null, (DagJsonParser)this.tezJsonParser);
        vertexC.outputOps.add(dummyOp);
        Vertex vertexA = new Vertex("vertex-a", null, null, (DagJsonParser)this.tezJsonParser);
        vertexA.tagToInput = new HashMap();
        vertexA.tagToInput.put("left", "vertex-b");
        vertexA.tagToInput.put("right", "vertex-c");
        vertexA.parentConnections.add(new Connection("left", vertexB));
        vertexA.parentConnections.add(new Connection("right", vertexC));
        HashMap attrs = new HashMap();
        Op uut = new Op("Map Join Operator", "op-id", "output-vertex-name", null, Collections.EMPTY_LIST, attrs, mapJoin, vertexA, (DagJsonParser)this.tezJsonParser);
        uut.inlineJoinOp();
        Assert.assertEquals((long)1L, (long)attrs.size());
        String result = (String)attrs.get("Conds:");
        String expected = "dummy-id.AKEY=dummy-id.BKEY(type)";
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

