/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import org.apache.hadoop.hive.common.jsonexplain.Stage;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTezJsonParser {
    private TezJsonParser uut;

    @Before
    public void setUp() throws Exception {
        this.uut = new TezJsonParser();
    }

    @Test
    public void testExtractStagesAndPlans() throws Exception {
        String jsonString = "{\"STAGE DEPENDENCIES\":{\"s1\":{\"ROOT STAGE\":\"\"},\"s2\":{\"DEPENDENT STAGES\":\"s1\"}},\"STAGE PLANS\":{}}";
        JSONObject input = new JSONObject(jsonString);
        this.uut.extractStagesAndPlans(input);
        Assert.assertEquals((long)2L, (long)this.uut.stages.size());
        Assert.assertEquals((long)1L, (long)((Stage)this.uut.stages.get((Object)"s1")).childStages.size());
        Assert.assertEquals((Object)"s2", (Object)((Stage)((Stage)this.uut.stages.get((Object)"s1")).childStages.get((int)0)).internalName);
        Assert.assertEquals((long)0L, (long)((Stage)this.uut.stages.get((Object)"s2")).childStages.size());
        Assert.assertEquals((long)0L, (long)((Stage)this.uut.stages.get((Object)"s1")).parentStages.size());
        Assert.assertEquals((long)1L, (long)((Stage)this.uut.stages.get((Object)"s2")).parentStages.size());
        Assert.assertEquals((Object)"s1", (Object)((Stage)((Stage)this.uut.stages.get((Object)"s2")).parentStages.get((int)0)).internalName);
    }
}

