/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class Retry
implements TestRule {
    private final int retryCount;

    public Retry() {
        this(2);
    }

    public Retry(int retryCount) {
        this.retryCount = retryCount;
    }

    public Statement apply(Statement base, Description description) {
        return new RetryingStatement(base, description);
    }

    private class RetryingStatement
    extends Statement {
        private final Statement wrappedStatement;
        private final Description description;

        private RetryingStatement(Statement wrappedStatement, Description description) {
            this.wrappedStatement = wrappedStatement;
            this.description = description;
        }

        public void evaluate() throws Throwable {
            boolean retry;
            int failedAttempts = 0;
            do {
                try {
                    this.wrappedStatement.evaluate();
                    retry = false;
                }
                catch (Throwable throwable) {
                    if (Retry.this.retryCount > failedAttempts) {
                        retry = true;
                        System.out.println(this.description + " Caught: " + throwable.getMessage() + ". Retrying test " + ++failedAttempts + "/" + Retry.this.retryCount);
                        continue;
                    }
                    throw throwable;
                }
            } while (retry);
        }
    }
}

