/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import com.google.code.tempusfugit.concurrency.annotations.Concurrent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimalTestBase;
import org.apache.hadoop.hive.common.type.HiveDecimalV1;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.orc.impl.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveDecimalOrcSerializationUtils
extends HiveDecimalTestBase {
    @Test
    @Concurrent(count=4)
    public void testSerializationUtilsWriteRead() {
        this.testSerializationUtilsWriteRead("0.00");
        this.testSerializationUtilsWriteRead("1");
        this.testSerializationUtilsWriteRead("234.79");
        this.testSerializationUtilsWriteRead("-12.25");
        this.testSerializationUtilsWriteRead("99999999999999999999999999999999");
        this.testSerializationUtilsWriteRead("-99999999999999999999999999999999");
        this.testSerializationUtilsWriteRead("99999999999999999999999999999999999999");
        this.testSerializationUtilsWriteRead("-99999999999999999999999999999999999999");
        this.testSerializationUtilsWriteRead("999999999999.99999999999999999999");
        this.testSerializationUtilsWriteRead("-999999.99999999999999999999999999");
        this.testSerializationUtilsWriteRead("9999999999999999999999.9999999999999999");
        this.testSerializationUtilsWriteRead("-9999999999999999999999999999999.9999999");
        this.testSerializationUtilsWriteRead("4611686018427387903");
        this.testSerializationUtilsWriteRead("-4611686018427387903");
        this.testSerializationUtilsWriteRead("4611686018427387904");
        this.testSerializationUtilsWriteRead("-4611686018427387904");
        this.testSerializationUtilsWriteRead("42535295865117307932921825928971026431");
        this.testSerializationUtilsWriteRead("-42535295865117307932921825928971026431");
        this.testSerializationUtilsWriteRead("42535295865117307932921825928971026432");
        this.testSerializationUtilsWriteRead("-42535295865117307932921825928971026432");
        this.testSerializationUtilsWriteRead("54216721532321902598.70");
        this.testSerializationUtilsWriteRead("-906.62545207002374150309544832320");
    }

    private void testSerializationUtilsWriteRead(String string) {
        HiveDecimal dec = HiveDecimal.create((String)string);
        Assert.assertTrue((dec != null ? 1 : 0) != 0);
        BigInteger bigInteger = dec.unscaledValue();
        int scale = dec.scale();
        HiveDecimalV1 oldDec = HiveDecimalV1.create((String)string);
        Assert.assertTrue((oldDec != null ? 1 : 0) != 0);
        BigInteger oldBigInteger = oldDec.unscaledValue();
        int oldScale = oldDec.scale();
        long[] scratchLongs = new long[6];
        int which = 0;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            if (!dec.serializationUtilsWrite((OutputStream)outputStream, scratchLongs)) {
                Assert.fail();
            }
            byte[] bytes = outputStream.toByteArray();
            ByteArrayOutputStream outputStreamExpected = new ByteArrayOutputStream();
            SerializationUtils.writeBigInteger((OutputStream)outputStreamExpected, (BigInteger)bigInteger);
            byte[] bytesExpected = outputStreamExpected.toByteArray();
            if (!StringExpr.equal((byte[])bytes, (int)0, (int)bytes.length, (byte[])bytesExpected, (int)0, (int)bytesExpected.length)) {
                // empty if block
            }
            which = 1;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            BigInteger deserializedBigInteger = SerializationUtils.readBigInteger((InputStream)byteArrayInputStream);
            which = 2;
            ByteArrayInputStream byteArrayInputStreamExpected = new ByteArrayInputStream(bytesExpected);
            BigInteger deserializedBigIntegerExpected = SerializationUtils.readBigInteger((InputStream)byteArrayInputStreamExpected);
            if (!deserializedBigInteger.equals(deserializedBigIntegerExpected)) {
                Assert.fail();
            }
            which = 3;
            ByteArrayInputStream byteArrayInputStreamRead = new ByteArrayInputStream(bytes);
            byte[] scratchBytes = new byte[24];
            HiveDecimal readHiveDecimal = HiveDecimal.serializationUtilsRead((InputStream)byteArrayInputStreamRead, (int)scale, (byte[])scratchBytes);
            Assert.assertTrue((readHiveDecimal != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)readHiveDecimal.toString(), (Object)dec.toString());
            Assert.assertEquals((Object)readHiveDecimal, (Object)dec);
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void testRandomSerializationUtilsRead() throws IOException {
        this.doTestRandomSerializationUtilsRead(standardAlphabet);
    }

    @Test
    public void testRandomSerializationUtilsReadSparse() throws IOException {
        for (String digitAlphabet : sparseAlphabets) {
            this.doTestRandomSerializationUtilsRead(digitAlphabet);
        }
    }

    private void doTestRandomSerializationUtilsRead(String digitAlphabet) throws IOException {
        Random r = new Random(2389L);
        for (int i = 0; i < POUND_FACTOR; ++i) {
            BigInteger bigInteger = this.randHiveBigInteger(r, digitAlphabet);
            this.doTestSerializationUtilsRead(r, bigInteger);
        }
    }

    @Test
    public void testSerializationUtilsReadSpecial() throws IOException {
        Random r = new Random(9923L);
        for (BigDecimal bigDecimal : specialBigDecimals) {
            this.doTestSerializationUtilsRead(r, bigDecimal.unscaledValue());
        }
    }

    private void doTestSerializationUtilsRead(Random r, BigInteger bigInteger) throws IOException {
        HiveDecimalV1 oldDec = HiveDecimalV1.create((BigInteger)bigInteger);
        if (oldDec != null && this.isTenPowerBug(oldDec.toString())) {
            return;
        }
        HiveDecimal dec = HiveDecimal.create((BigInteger)bigInteger);
        if (oldDec == null) {
            Assert.assertTrue((dec == null ? 1 : 0) != 0);
            return;
        }
        Assert.assertTrue((dec != null ? 1 : 0) != 0);
        dec.validate();
        Assert.assertEquals((Object)bigInteger, (Object)oldDec.unscaledValue());
        Assert.assertEquals((Object)bigInteger, (Object)dec.unscaledValue());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerializationUtils.writeBigInteger((OutputStream)outputStream, (BigInteger)bigInteger);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        BigInteger deserializedBigInteger = SerializationUtils.readBigInteger((InputStream)byteArrayInputStream);
        Assert.assertEquals((Object)bigInteger, (Object)deserializedBigInteger);
        byte[] scratchBytes = new byte[24];
        byteArrayInputStream = new ByteArrayInputStream(bytes);
        HiveDecimal resultDec = HiveDecimal.serializationUtilsRead((InputStream)byteArrayInputStream, (int)dec.scale(), (byte[])scratchBytes);
        Assert.assertTrue((resultDec != null ? 1 : 0) != 0);
        resultDec.validate();
        Assert.assertEquals((Object)dec.toString(), (Object)resultDec.toString());
        int scale = 0 + r.nextInt(39);
        BigDecimal bigDecimal = new BigDecimal(bigInteger, scale);
        oldDec = HiveDecimalV1.create((BigDecimal)bigDecimal);
        dec = HiveDecimal.create((BigDecimal)bigDecimal);
        if (oldDec == null) {
            Assert.assertTrue((dec == null ? 1 : 0) != 0);
            return;
        }
        Assert.assertTrue((dec != null ? 1 : 0) != 0);
        dec.validate();
        outputStream = new ByteArrayOutputStream();
        SerializationUtils.writeBigInteger((OutputStream)outputStream, (BigInteger)dec.unscaledValue());
        bytes = outputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(bytes);
        resultDec = HiveDecimal.serializationUtilsRead((InputStream)byteArrayInputStream, (int)dec.scale(), (byte[])scratchBytes);
        Assert.assertTrue((resultDec != null ? 1 : 0) != 0);
        resultDec.validate();
        Assert.assertEquals((Object)dec.toString(), (Object)resultDec.toString());
    }

    @Test
    public void testRandomSerializationUtilsWrite() throws IOException {
        this.doTestRandomSerializationUtilsWrite(standardAlphabet, false);
    }

    @Test
    public void testRandomSerializationUtilsWriteFractionsOnly() throws IOException {
        this.doTestRandomSerializationUtilsWrite(standardAlphabet, true);
    }

    @Test
    public void testRandomSerializationUtilsWriteSparse() throws IOException {
        for (String digitAlphabet : sparseAlphabets) {
            this.doTestRandomSerializationUtilsWrite(digitAlphabet, false);
        }
    }

    private void doTestRandomSerializationUtilsWrite(String digitAlphabet, boolean fractionsOnly) throws IOException {
        Random r = new Random(823L);
        for (int i = 0; i < POUND_FACTOR; ++i) {
            BigInteger bigInteger = this.randHiveBigInteger(r, digitAlphabet);
            this.doTestSerializationUtilsWrite(r, bigInteger);
        }
    }

    @Test
    public void testSerializationUtilsWriteSpecial() throws IOException {
        Random r = new Random(998737L);
        for (BigDecimal bigDecimal : specialBigDecimals) {
            this.doTestSerializationUtilsWrite(r, bigDecimal.unscaledValue());
        }
    }

    private void doTestSerializationUtilsWrite(Random r, BigInteger bigInteger) throws IOException {
        HiveDecimalV1 oldDec = HiveDecimalV1.create((BigInteger)bigInteger);
        if (oldDec != null && this.isTenPowerBug(oldDec.toString())) {
            return;
        }
        HiveDecimal dec = HiveDecimal.create((BigInteger)bigInteger);
        if (oldDec == null) {
            Assert.assertTrue((dec == null ? 1 : 0) != 0);
            return;
        }
        Assert.assertTrue((dec != null ? 1 : 0) != 0);
        dec.validate();
        Assert.assertEquals((Object)bigInteger, (Object)oldDec.unscaledValue());
        Assert.assertEquals((Object)bigInteger, (Object)dec.unscaledValue());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerializationUtils.writeBigInteger((OutputStream)outputStream, (BigInteger)bigInteger);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        BigInteger deserializedBigInteger = SerializationUtils.readBigInteger((InputStream)byteArrayInputStream);
        Assert.assertEquals((Object)bigInteger, (Object)deserializedBigInteger);
        ByteArrayOutputStream decOutputStream = new ByteArrayOutputStream();
        long[] scratchLongs = new long[6];
        boolean successful = dec.serializationUtilsWrite((OutputStream)decOutputStream, scratchLongs);
        Assert.assertTrue((boolean)successful);
        byte[] decBytes = decOutputStream.toByteArray();
        if (!StringExpr.equal((byte[])bytes, (int)0, (int)bytes.length, (byte[])decBytes, (int)0, (int)decBytes.length)) {
            // empty if block
        }
        ByteArrayInputStream decByteArrayInputStream = new ByteArrayInputStream(decBytes);
        BigInteger decDeserializedBigInteger = SerializationUtils.readBigInteger((InputStream)decByteArrayInputStream);
        Assert.assertEquals((Object)bigInteger, (Object)decDeserializedBigInteger);
    }
}

