/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.FipsUtil;
import org.apache.hive.beeline.BeeLineCommandCompleter;
import org.apache.hive.beeline.BeeLineCompleter;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.BeeLineSignalHandler;
import org.apache.hive.beeline.BooleanCompleter;
import org.apache.hive.beeline.BufferedRows;
import org.apache.hive.beeline.ColorBuffer;
import org.apache.hive.beeline.CommandHandler;
import org.apache.hive.beeline.Commands;
import org.apache.hive.beeline.DatabaseConnection;
import org.apache.hive.beeline.DatabaseConnections;
import org.apache.hive.beeline.DeprecatedSeparatedValuesOutputFormat;
import org.apache.hive.beeline.IncrementalRows;
import org.apache.hive.beeline.IncrementalRowsWithNormalization;
import org.apache.hive.beeline.OutputFile;
import org.apache.hive.beeline.OutputFormat;
import org.apache.hive.beeline.ReflectiveCommandHandler;
import org.apache.hive.beeline.Reflector;
import org.apache.hive.beeline.Rows;
import org.apache.hive.beeline.SeparatedValuesOutputFormat;
import org.apache.hive.beeline.SunSignalHandler;
import org.apache.hive.beeline.TableNameCompletor;
import org.apache.hive.beeline.TableOutputFormat;
import org.apache.hive.beeline.VerticalOutputFormat;
import org.apache.hive.beeline.XMLAttributeOutputFormat;
import org.apache.hive.beeline.XMLElementOutputFormat;
import org.apache.hive.beeline.cli.CliOptionsProcessor;
import org.apache.hive.beeline.hs2connection.BeelineConfFileParseException;
import org.apache.hive.beeline.hs2connection.BeelineSiteParseException;
import org.apache.hive.beeline.hs2connection.BeelineSiteParser;
import org.apache.hive.beeline.hs2connection.HS2ConnectionFileParser;
import org.apache.hive.beeline.hs2connection.HS2ConnectionFileUtils;
import org.apache.hive.beeline.hs2connection.HiveSiteHS2ConnectionFileParser;
import org.apache.hive.beeline.hs2connection.UserHS2ConnectionFileParser;
import org.apache.hive.common.util.MapRKeystoreReader;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.jdbc.JdbcUriParseException;
import org.apache.hive.jdbc.Utils;
import org.apache.thrift.transport.TTransportException;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class BeeLine
implements Closeable {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(BeeLine.class.getSimpleName());
    private final BeeLineSignalHandler signalHandler;
    private final Runnable shutdownHook;
    private static final String separator = System.getProperty("line.separator");
    private boolean exit = false;
    private final DatabaseConnections connections = new DatabaseConnections();
    public static final String COMMAND_PREFIX = "!";
    private Collection<Driver> drivers = null;
    private final BeeLineOpts opts = new BeeLineOpts(this, System.getProperties());
    private String lastProgress = null;
    private final Map<SQLWarning, Date> seenWarnings = new HashMap<SQLWarning, Date>();
    private final Commands commands = new Commands(this);
    private OutputFile scriptOutputFile = null;
    private OutputFile recordOutputFile = null;
    private PrintStream outputStream = new PrintStream(System.out, true);
    private PrintStream errorStream = new PrintStream(System.err, true);
    private InputStream inputStream = System.in;
    private ConsoleReader consoleReader;
    private List<String> batch = null;
    private final Reflector reflector = new Reflector(this);
    private String dbName = null;
    private String currentDatabase = null;
    private FileHistory history;
    private boolean isBeeLine = true;
    private boolean isTestMode = false;
    private static final Options options = new Options();
    public static final String BEELINE_DEFAULT_JDBC_DRIVER = "org.apache.hive.jdbc.HiveDriver";
    public static final String DEFAULT_DATABASE_NAME = "default";
    private static final String SCRIPT_OUTPUT_PREFIX = ">>>";
    private static final int SCRIPT_OUTPUT_PAD_SIZE = 5;
    private static final int ERRNO_OK = 0;
    private static final int ERRNO_ARGS = 1;
    private static final int ERRNO_OTHER = 2;
    private static final String HIVE_VAR_PREFIX = "--hivevar";
    private static final String HIVE_CONF_PREFIX = "--hiveconf";
    private static final String PROP_FILE_PREFIX = "--property-file";
    static final String PASSWD_MASK = "[passwd stripped]";
    public static final String TRUSTSTORE_PASS_SYSTEM_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String TRUSTSTORE_TYPE_SYSTEM_PROPERTY = "javax.net.ssl.trustStoreType";
    public static final String BCFKS_KEYSTORE_TYPE = "BCFKS";
    private final Map<Object, Object> formats = BeeLine.map(new Object[]{"vertical", new VerticalOutputFormat(this), "table", new TableOutputFormat(this), "csv2", new SeparatedValuesOutputFormat(this, ','), "tsv2", new SeparatedValuesOutputFormat(this, '\t'), "dsv", new SeparatedValuesOutputFormat(this, '|'), "csv", new DeprecatedSeparatedValuesOutputFormat(this, ','), "tsv", new DeprecatedSeparatedValuesOutputFormat(this, '\t'), "xmlattr", new XMLAttributeOutputFormat(this), "xmlelements", new XMLElementOutputFormat(this)});
    private List<String> supportedLocalDriver = new ArrayList<String>(Arrays.asList("com.mysql.jdbc.Driver", "org.postgresql.Driver"));
    final CommandHandler[] commandHandlers = new CommandHandler[]{new ReflectiveCommandHandler(this, new String[]{"quit", "done", "exit"}, null), new ReflectiveCommandHandler(this, new String[]{"connect", "open"}, new Completer[]{new StringsCompleter(this.getConnectionURLExamples())}), new ReflectiveCommandHandler(this, new String[]{"describe"}, new Completer[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"indexes"}, new Completer[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"primarykeys"}, new Completer[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"exportedkeys"}, new Completer[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"manual"}, null), new ReflectiveCommandHandler(this, new String[]{"importedkeys"}, new Completer[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"procedures"}, null), new ReflectiveCommandHandler(this, new String[]{"tables"}, null), new ReflectiveCommandHandler(this, new String[]{"typeinfo"}, null), new ReflectiveCommandHandler(this, new String[]{"columns"}, new Completer[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"reconnect"}, null), new ReflectiveCommandHandler(this, new String[]{"dropall"}, new Completer[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"history"}, null), new ReflectiveCommandHandler(this, new String[]{"metadata"}, new Completer[]{new StringsCompleter(this.getMetadataMethodNames())}), new ReflectiveCommandHandler(this, new String[]{"nativesql"}, null), new ReflectiveCommandHandler(this, new String[]{"dbinfo"}, null), new ReflectiveCommandHandler(this, new String[]{"rehash"}, null), new ReflectiveCommandHandler(this, new String[]{"verbose"}, null), new ReflectiveCommandHandler(this, new String[]{"run"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(this, new String[]{"batch"}, null), new ReflectiveCommandHandler(this, new String[]{"list"}, null), new ReflectiveCommandHandler(this, new String[]{"all"}, null), new ReflectiveCommandHandler(this, new String[]{"go", "#"}, null), new ReflectiveCommandHandler(this, new String[]{"script"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(this, new String[]{"record"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(this, new String[]{"brief"}, null), new ReflectiveCommandHandler(this, new String[]{"close"}, null), new ReflectiveCommandHandler(this, new String[]{"closeall"}, null), new ReflectiveCommandHandler(this, new String[]{"isolation"}, new Completer[]{new StringsCompleter(this.getIsolationLevels())}), new ReflectiveCommandHandler(this, new String[]{"outputformat"}, new Completer[]{new StringsCompleter(this.formats.keySet().toArray(new String[0]))}), new ReflectiveCommandHandler(this, new String[]{"autocommit"}, null), new ReflectiveCommandHandler(this, new String[]{"commit"}, null), new ReflectiveCommandHandler(this, new String[]{"properties"}, new Completer[]{new FileNameCompleter()}), new ReflectiveCommandHandler(this, new String[]{"rollback"}, null), new ReflectiveCommandHandler(this, new String[]{"help", "?"}, null), new ReflectiveCommandHandler(this, new String[]{"set"}, this.getOpts().optionCompleters()), new ReflectiveCommandHandler(this, new String[]{"save"}, null), new ReflectiveCommandHandler(this, new String[]{"scan"}, null), new ReflectiveCommandHandler(this, new String[]{"sql"}, null), new ReflectiveCommandHandler(this, new String[]{"sh"}, null), new ReflectiveCommandHandler(this, new String[]{"call"}, null), new ReflectiveCommandHandler(this, new String[]{"nullemptystring"}, new Completer[]{new BooleanCompleter()}), new ReflectiveCommandHandler(this, new String[]{"addlocaldriverjar"}, null), new ReflectiveCommandHandler(this, new String[]{"addlocaldrivername"}, null), new ReflectiveCommandHandler(this, new String[]{"delimiter"}, null)};
    private final Completer beeLineCommandCompleter = new BeeLineCommandCompleter(Arrays.asList(this.commandHandlers));
    static final SortedSet<String> KNOWN_DRIVERS = new TreeSet<String>(Arrays.asList("org.apache.hive.jdbc.HiveDriver", "org.apache.hadoop.hive.jdbc.HiveDriver"));

    static Manifest getManifest() throws IOException {
        URL base = BeeLine.class.getResource("/META-INF/MANIFEST.MF");
        URLConnection c = base.openConnection();
        if (c instanceof JarURLConnection) {
            return ((JarURLConnection)c).getManifest();
        }
        return null;
    }

    String getManifestAttribute(String name) {
        try {
            Manifest m = BeeLine.getManifest();
            if (m == null) {
                return "??";
            }
            Attributes attrs = m.getAttributes("beeline");
            if (attrs == null) {
                return "???";
            }
            String val = attrs.getValue(name);
            if (val == null || "".equals(val)) {
                return "????";
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace(this.errorStream);
            return "?????";
        }
    }

    String getApplicationTitle() {
        Package pack = BeeLine.class.getPackage();
        return this.loc("app-introduction", new Object[]{"Beeline", pack.getImplementationVersion() == null ? "???" : pack.getImplementationVersion(), "Apache Hive"});
    }

    String getApplicationContactInformation() {
        return this.getManifestAttribute("Implementation-Vendor");
    }

    String loc(String res) {
        return this.loc(res, new Object[0]);
    }

    String loc(String res, int param) {
        try {
            return MessageFormat.format(new ChoiceFormat(resourceBundle.getString(res)).format(param), new Integer(param));
        }
        catch (Exception e) {
            return res + ": " + param;
        }
    }

    String loc(String res, Object param1) {
        return this.loc(res, new Object[]{param1});
    }

    String loc(String res, Object param1, Object param2) {
        return this.loc(res, new Object[]{param1, param2});
    }

    String loc(String res, Object[] params) {
        try {
            return MessageFormat.format(resourceBundle.getString(res), params);
        }
        catch (Exception e) {
            e.printStackTrace(this.getErrorStream());
            try {
                return res + ": " + Arrays.asList(params);
            }
            catch (Exception e2) {
                return res;
            }
        }
    }

    protected String locElapsedTime(long milliseconds) {
        if (this.getOpts().getShowElapsedTime()) {
            return this.loc("time-ms", new Object[]{new Double((double)milliseconds / 1000.0)});
        }
        return "";
    }

    public static void main(String[] args) throws IOException {
        BeeLine.mainWithInputRedirection(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        if (FipsUtil.isFips()) {
            Security.addProvider((Provider)new BouncyCastleFipsProvider());
            Security.addProvider((Provider)new BouncyCastleJsseProvider());
            String clientTruststorePassword = MapRKeystoreReader.getClientTruststorePassword();
            System.setProperty(TRUSTSTORE_TYPE_SYSTEM_PROPERTY, BCFKS_KEYSTORE_TYPE);
            System.setProperty(TRUSTSTORE_PASS_SYSTEM_PROPERTY, clientTruststorePassword);
        }
        try (BeeLine beeLine = new BeeLine();){
            int status = beeLine.begin(args, inputStream);
            if (!Boolean.getBoolean("beeline.system.exit")) {
                System.exit(status);
            }
        }
    }

    public BeeLine() {
        this(true);
    }

    public BeeLine(boolean isBeeLine) {
        this.isBeeLine = isBeeLine;
        this.signalHandler = new SunSignalHandler(this);
        this.shutdownHook = new Runnable(){

            @Override
            public void run() {
                try {
                    if (BeeLine.this.history != null) {
                        BeeLine.this.history.setMaxSize(BeeLine.this.getOpts().getMaxHistoryRows());
                        BeeLine.this.history.flush();
                    }
                }
                catch (IOException e) {
                    BeeLine.this.error(e);
                }
                finally {
                    BeeLine.this.close();
                }
            }
        };
    }

    DatabaseConnection getDatabaseConnection() {
        return this.getDatabaseConnections().current();
    }

    Connection getConnection() throws SQLException {
        if (this.getDatabaseConnections().current() == null || this.getDatabaseConnections().current().getConnection() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection"));
        }
        return this.getDatabaseConnections().current().getConnection();
    }

    DatabaseMetaData getDatabaseMetaData() {
        if (this.getDatabaseConnections().current() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection"));
        }
        if (this.getDatabaseConnections().current().getDatabaseMetaData() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection"));
        }
        return this.getDatabaseConnections().current().getDatabaseMetaData();
    }

    public String[] getIsolationLevels() {
        return new String[]{"TRANSACTION_NONE", "TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE"};
    }

    public String[] getMetadataMethodNames() {
        try {
            TreeSet<String> mnames = new TreeSet<String>();
            Method[] m = DatabaseMetaData.class.getDeclaredMethods();
            for (int i = 0; m != null && i < m.length; ++i) {
                mnames.add(m[i].getName());
            }
            return mnames.toArray(new String[0]);
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    public String[] getConnectionURLExamples() {
        return new String[]{"jdbc:JSQLConnect://<hostname>/database=<database>", "jdbc:cloudscape:<database>;create=true", "jdbc:twtds:sqlserver://<hostname>/<database>", "jdbc:daffodilDB_embedded:<database>;create=true", "jdbc:datadirect:db2://<hostname>:50000;databaseName=<database>", "jdbc:inetdae:<hostname>:1433", "jdbc:datadirect:oracle://<hostname>:1521;SID=<database>;MaxPooledStatements=0", "jdbc:datadirect:sqlserver://<hostname>:1433;SelectMethod=cursor;DatabaseName=<database>", "jdbc:datadirect:sybase://<hostname>:5000", "jdbc:db2://<hostname>/<database>", "jdbc:hive2://<hostname>", "jdbc:hsqldb:<database>", "jdbc:idb:<database>.properties", "jdbc:informix-sqli://<hostname>:1526/<database>:INFORMIXSERVER=<database>", "jdbc:interbase://<hostname>//<database>.gdb", "jdbc:microsoft:sqlserver://<hostname>:1433;DatabaseName=<database>;SelectMethod=cursor", "jdbc:mysql://<hostname>/<database>?autoReconnect=true", "jdbc:oracle:thin:@<hostname>:1521:<database>", "jdbc:pointbase:<database>,database.home=<database>,create=true", "jdbc:postgresql://<hostname>:5432/<database>", "jdbc:postgresql:net//<hostname>/<database>", "jdbc:sybase:Tds:<hostname>:4100/<database>?ServiceName=<database>", "jdbc:weblogic:mssqlserver4:<database>@<hostname>:1433", "jdbc:odbc:<database>", "jdbc:sequelink://<hostname>:4003/[Oracle]", "jdbc:sequelink://<hostname>:4004/[Informix];Database=<database>", "jdbc:sequelink://<hostname>:4005/[Sybase];Database=<database>", "jdbc:sequelink://<hostname>:4006/[SQLServer];Database=<database>", "jdbc:sequelink://<hostname>:4011/[ODBC MS Access];Database=<database>", "jdbc:openlink://<hostname>/DSN=SQLServerDB/UID=sa/PWD=", "jdbc:solid://<hostname>:<port>/<UID>/<PWD>", "jdbc:dbaw://<hostname>:8889/<database>"};
    }

    ColorBuffer getColorBuffer() {
        return new ColorBuffer(this.getOpts().getColor());
    }

    ColorBuffer getColorBuffer(String msg) {
        return new ColorBuffer(msg, this.getOpts().getColor());
    }

    /*
     * WARNING - void declaration
     */
    int initArgsFromCliVars(String[] args) {
        void var8_13;
        List<Object> commands = Collections.emptyList();
        CliOptionsProcessor optionsProcessor = new CliOptionsProcessor();
        if (!optionsProcessor.process(args)) {
            return 1;
        }
        CommandLine commandLine = optionsProcessor.getCommandLine();
        Properties confProps = commandLine.getOptionProperties("hiveconf");
        for (String string : confProps.stringPropertyNames()) {
            this.setHiveConfVar(string, confProps.getProperty(string));
        }
        Properties hiveVars = commandLine.getOptionProperties("define");
        for (String string : hiveVars.stringPropertyNames()) {
            this.getOpts().getHiveConfVariables().put(string, hiveVars.getProperty(string));
        }
        Properties properties = commandLine.getOptionProperties("hivevar");
        for (String propKey : properties.stringPropertyNames()) {
            this.getOpts().getHiveConfVariables().put(propKey, properties.getProperty(propKey));
        }
        this.getOpts().setScriptFile(commandLine.getOptionValue("f"));
        if (commandLine.getOptionValues("i") != null) {
            this.getOpts().setInitFiles(commandLine.getOptionValues("i"));
        }
        this.dbName = commandLine.getOptionValue("database");
        this.getOpts().setVerbose(Boolean.parseBoolean(commandLine.getOptionValue("verbose")));
        this.getOpts().setSilent(Boolean.parseBoolean(commandLine.getOptionValue("silent")));
        boolean bl = false;
        if (commandLine.getOptionValues("e") != null) {
            commands = Arrays.asList(commandLine.getOptionValues("e"));
        }
        if (!commands.isEmpty() && this.getOpts().getScriptFile() != null) {
            System.err.println("The '-e' and '-f' options cannot be specified simultaneously");
            optionsProcessor.printCliUsage();
            return 1;
        }
        if (!commands.isEmpty()) {
            this.embeddedConnect();
            this.connectDBInEmbededMode();
            Iterator<Object> i = commands.iterator();
            while (i.hasNext()) {
                String command = ((String)i.next()).toString();
                this.debug(this.loc("executing-command", command));
                if (this.dispatch(command)) continue;
                ++var8_13;
            }
            this.exit = true;
        }
        return (int)var8_13;
    }

    int initArgs(String[] args) {
        CommandLine cl;
        BeelineParser beelineParser;
        List<Object> commands = Collections.emptyList();
        try {
            beelineParser = new BeelineParser();
            cl = beelineParser.parse(options, args);
        }
        catch (ParseException e1) {
            this.output(e1.getMessage());
            this.usage();
            return -1;
        }
        boolean connSuccessful = this.connectUsingArgs(beelineParser, cl);
        if (!connSuccessful && !this.exit) {
            connSuccessful = this.defaultBeelineConnect(cl);
        }
        int code = 0;
        if (cl.getOptionValues('e') != null) {
            commands = Arrays.asList(cl.getOptionValues('e'));
            this.opts.setAllowMultiLineCommand(false);
        }
        if (!commands.isEmpty() && this.getOpts().getScriptFile() != null) {
            this.error("The '-e' and '-f' options cannot be specified simultaneously");
            return 1;
        }
        if (!commands.isEmpty() && !connSuccessful) {
            this.error("Cannot run commands specified using -e. No current connection");
            return 1;
        }
        if (!commands.isEmpty()) {
            Iterator<Object> i = commands.iterator();
            while (i.hasNext()) {
                String command = ((String)i.next()).toString();
                this.debug(this.loc("executing-command", command));
                if (this.dispatch(command)) continue;
                ++code;
            }
            this.exit = true;
        }
        return code;
    }

    /*
     * WARNING - void declaration
     */
    private boolean connectUsingArgs(BeelineParser beelineParser, CommandLine cl) {
        String driver = null;
        String user = null;
        String pass = "";
        String url = null;
        String auth = null;
        if (cl.hasOption("help")) {
            this.usage();
            this.getOpts().setHelpAsked(true);
            return true;
        }
        Properties hiveVars = cl.getOptionProperties("hivevar");
        for (String string : hiveVars.stringPropertyNames()) {
            this.getOpts().getHiveVariables().put(string, hiveVars.getProperty(string));
        }
        Properties hiveConfs = cl.getOptionProperties("hiveconf");
        for (String key : hiveConfs.stringPropertyNames()) {
            this.setHiveConfVar(key, hiveConfs.getProperty(key));
        }
        driver = cl.getOptionValue("d");
        auth = cl.getOptionValue("a");
        user = cl.getOptionValue("n");
        this.getOpts().setAuthType(auth);
        if (cl.hasOption("w")) {
            pass = this.obtainPasswordFromFile(cl.getOptionValue("w"));
        } else if (beelineParser.isPasswordOptionSet) {
            pass = cl.getOptionValue("p");
        }
        url = cl.getOptionValue("u");
        if (url == null && cl.hasOption("reconnect")) {
            url = this.getOpts().getLastConnectedUrl();
        }
        this.getOpts().setInitFiles(cl.getOptionValues("i"));
        this.getOpts().setScriptFile(cl.getOptionValue("f"));
        if (url != null) {
            void var10_14;
            String comForDebug;
            if (user == null) {
                user = Utils.parsePropertyFromUrl((String)url, (String)"user");
            }
            if (pass == null) {
                pass = Utils.parsePropertyFromUrl((String)url, (String)"password");
            }
            if (driver == null) {
                driver = Utils.parsePropertyFromUrl((String)url, (String)"driver");
            }
            if (pass != null) {
                String string = this.constructCmd(url, user, pass, driver, false);
                comForDebug = this.constructCmd(url, user, pass, driver, true);
            } else {
                String string = this.constructCmdUrl(url, user, driver, false);
                comForDebug = this.constructCmdUrl(url, user, driver, true);
            }
            this.debug(comForDebug);
            if (!this.dispatch((String)var10_14)) {
                this.exit = true;
                return false;
            }
            return true;
        }
        String string = cl.getOptionValue("property-file");
        if (string != null) {
            try {
                this.consoleReader = new ConsoleReader((InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)this.findPrintStream());
            }
            catch (IOException e) {
                this.handleException(e);
            }
            if (!this.dispatch("!properties " + string)) {
                this.exit = true;
                return false;
            }
        }
        return false;
    }

    private void setHiveConfVar(String key, String val) {
        this.getOpts().getHiveConfVariables().put(key, val);
        if (HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname.equals(key) && "mr".equals(val)) {
            this.info(HiveConf.generateMrDeprecationWarning());
        }
    }

    private String constructCmd(String url, String user, String pass, String driver, boolean stripPasswd) {
        return "!connect " + url + " " + (user == null || user.length() == 0 ? "''" : user) + " " + (stripPasswd ? PASSWD_MASK : (pass.length() == 0 ? "''" : pass)) + " " + (driver == null ? "" : driver);
    }

    private String constructCmdUrl(String url, String user, String driver, boolean stripPasswd) {
        int startIndex;
        StringBuilder command = new StringBuilder("!connect ");
        command.append(url);
        if (this.isTrailingSlashNeeded(url)) {
            command.append('/');
        }
        command.append(';');
        if (Utils.parsePropertyFromUrl((String)url, (String)"user") == null) {
            command.append("user");
            command.append('=');
            command.append(user == null || user.length() == 0 ? "''" : user);
        }
        if (stripPasswd && (startIndex = command.indexOf("password=") + "password".length() + 2) != -1) {
            int endIndex = command.toString().indexOf(";", startIndex);
            command.replace(startIndex, endIndex == -1 ? command.length() : endIndex, PASSWD_MASK);
        }
        if (Utils.parsePropertyFromUrl((String)url, (String)"driver") == null && driver != null) {
            command.append(';');
            command.append("driver");
            command.append("=");
            command.append(driver);
        }
        return command.toString();
    }

    private boolean isTrailingSlashNeeded(String url) {
        if (url.toLowerCase().startsWith("jdbc:hive2://")) {
            return url.indexOf(47, "jdbc:hive2://".length()) < 0;
        }
        return false;
    }

    private String obtainPasswordFromFile(String passwordFilePath) {
        try {
            Path path = Paths.get(passwordFilePath, new String[0]);
            byte[] passwordFileContents = Files.readAllBytes(path);
            return new String(passwordFileContents, "UTF-8").trim();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read user password from the password file: " + passwordFilePath, e);
        }
    }

    public void updateOptsForCli() {
        this.getOpts().updateBeeLineOptsFromConf();
        this.getOpts().setShowHeader(false);
        this.getOpts().setEscapeCRLF(false);
        this.getOpts().setOutputFormat("dsv");
        this.getOpts().setDelimiterForDSV(' ');
        this.getOpts().setNullEmptyString(true);
    }

    public int begin(String[] args, InputStream inputStream) throws IOException {
        return this.begin(args, inputStream, true);
    }

    public int begin(String[] args, InputStream inputStream, boolean keepHistory) throws IOException {
        try {
            this.getOpts().load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (keepHistory) {
            this.setupHistory();
        }
        this.addBeelineShutdownHook();
        ConsoleReader reader = this.initializeConsoleReader(inputStream);
        if (this.isBeeLine) {
            int code = this.initArgs(args);
            if (code != 0) {
                return code;
            }
        } else {
            int code = this.initArgsFromCliVars(args);
            if (code != 0 || this.exit) {
                return code;
            }
            this.defaultConnect(false);
        }
        if (this.getOpts().isHelpAsked()) {
            return 0;
        }
        if (this.getOpts().getScriptFile() != null) {
            return this.executeFile(this.getOpts().getScriptFile());
        }
        try {
            this.info(this.getApplicationTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.execute(reader, false);
    }

    private boolean defaultBeelineConnect(CommandLine cl) {
        String url;
        try {
            url = this.getDefaultConnectionUrl(cl);
            if (url == null) {
                this.debug("Default hs2 connection config file not found");
                return false;
            }
        }
        catch (BeelineConfFileParseException e) {
            this.error(e);
            return false;
        }
        return this.dispatch("!connect " + url);
    }

    private String getDefaultConnectionUrl(CommandLine cl) throws BeelineConfFileParseException {
        Properties mergedConnectionProperties = new Properties();
        Utils.JdbcConnectionParams jdbcConnectionParams = null;
        BeelineSiteParser beelineSiteParser = this.getUserBeelineSiteParser();
        UserHS2ConnectionFileParser userHS2ConnFileParser = this.getUserHS2ConnFileParser();
        Properties userConnectionProperties = new Properties();
        if (!userHS2ConnFileParser.configExists() && !beelineSiteParser.configExists()) {
            return null;
        }
        if (beelineSiteParser.configExists()) {
            String urlName;
            String jdbcURL;
            String urlFromCommandLineOption = cl.getOptionValue("u");
            if (urlFromCommandLineOption != null) {
                throw new BeelineSiteParseException("Not using beeline-site.xml since the user provided the url: " + urlFromCommandLineOption);
            }
            Properties userNamedConnectionURLs = beelineSiteParser.getConnectionProperties();
            if (!userNamedConnectionURLs.isEmpty() && (jdbcURL = HS2ConnectionFileUtils.getNamedUrl(userNamedConnectionURLs, urlName = cl.getOptionValue("c"))) != null) {
                try {
                    jdbcConnectionParams = Utils.extractURLComponents((String)jdbcURL, (Properties)new Properties());
                }
                catch (JdbcUriParseException e) {
                    throw new BeelineSiteParseException("Error in parsing jdbc url: " + jdbcURL + " from beeline-site.xml", (Exception)((Object)e));
                }
            }
        }
        if (userHS2ConnFileParser.configExists()) {
            userConnectionProperties = userHS2ConnFileParser.getConnectionProperties();
        }
        if (jdbcConnectionParams != null) {
            String password;
            String userName = cl.getOptionValue("n");
            if (userName != null) {
                jdbcConnectionParams.getSessionVars().put("user", userName);
            }
            if ((password = cl.getOptionValue("p")) != null) {
                jdbcConnectionParams.getSessionVars().put("password", password);
            }
            mergedConnectionProperties = HS2ConnectionFileUtils.mergeUserConnectionPropertiesAndBeelineSite(userConnectionProperties, jdbcConnectionParams);
        } else {
            mergedConnectionProperties = userConnectionProperties;
        }
        HS2ConnectionFileParser hiveSiteParser = this.getHiveSiteHS2ConnectionFileParser();
        Properties hiveSiteConnectionProperties = hiveSiteParser.getConnectionProperties();
        for (String key : mergedConnectionProperties.stringPropertyNames()) {
            if (hiveSiteConnectionProperties.containsKey(key)) {
                this.debug("Overriding connection url property " + key + " from user connection configuration file");
            }
            hiveSiteConnectionProperties.setProperty(key, mergedConnectionProperties.getProperty(key));
        }
        return HS2ConnectionFileUtils.getUrl(hiveSiteConnectionProperties);
    }

    @VisibleForTesting
    public BeelineSiteParser getUserBeelineSiteParser() {
        return new BeelineSiteParser();
    }

    @VisibleForTesting
    public UserHS2ConnectionFileParser getUserHS2ConnFileParser() {
        return new UserHS2ConnectionFileParser();
    }

    @VisibleForTesting
    public HS2ConnectionFileParser getHiveSiteHS2ConnectionFileParser() {
        return new HiveSiteHS2ConnectionFileParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int runInit() {
        boolean exitOnError;
        String[] initFiles = this.getOpts().getInitFiles();
        int executionResult = 0;
        boolean bl = exitOnError = !this.getOpts().getForce();
        if (initFiles != null && initFiles.length != 0) {
            for (String initFile : initFiles) {
                this.info("Running init script " + initFile);
                try {
                    int currentResult = this.executeFile(initFile);
                    if (currentResult == 0) continue;
                    executionResult = currentResult;
                    if (!exitOnError) continue;
                    int n = executionResult;
                    return n;
                }
                finally {
                    this.exit = false;
                }
            }
        }
        return executionResult;
    }

    private int embeddedConnect() {
        if (!this.execCommandWithPrefix("!connect jdbc:hive2:// '' ''")) {
            return 2;
        }
        return 0;
    }

    private int connectDBInEmbededMode() {
        if (this.dbName != null && !this.dbName.isEmpty() && !this.dispatch("use " + this.dbName + ";")) {
            return 2;
        }
        return 0;
    }

    public int defaultConnect(boolean exitOnError) {
        if (this.embeddedConnect() != 0 && exitOnError) {
            return 2;
        }
        if (this.connectDBInEmbededMode() != 0 && exitOnError) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeFile(String fileName) {
        int path2;
        FileInputStream fileStream = null;
        try {
            if (!this.isBeeLine) {
                LocalFileSystem fs;
                org.apache.hadoop.fs.Path path2 = new org.apache.hadoop.fs.Path(fileName);
                HiveConf conf = this.getCommands().getHiveConf(true);
                if (!path2.toUri().isAbsolute()) {
                    fs = FileSystem.getLocal((Configuration)conf);
                    path2 = fs.makeQualified(path2);
                } else {
                    fs = FileSystem.get((URI)path2.toUri(), (Configuration)conf);
                }
                fileStream = fs.open(path2);
            } else {
                fileStream = new FileInputStream(fileName);
            }
            path2 = this.execute(this.initializeConsoleReader(fileStream), !this.getOpts().getForce());
        }
        catch (Throwable t) {
            int n;
            try {
                this.handleException(t);
                n = 2;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(fileStream);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)fileStream);
            return n;
        }
        IOUtils.closeStream((Closeable)fileStream);
        return path2;
    }

    private int execute(ConsoleReader reader, boolean exitOnError) {
        Character mask;
        int lastExecutionResult = 0;
        Character c = mask = System.getProperty("jline.terminal", "").equals("jline.UnsupportedTerminal") ? null : Character.valueOf('\u0000');
        while (!this.exit) {
            try {
                String line;
                String string = line = this.getOpts().isSilent() && this.getOpts().getScriptFile() != null ? reader.readLine(null, mask) : reader.readLine(this.getPrompt());
                if (line != null) {
                    line = line.trim();
                }
                if (!this.dispatch(line)) {
                    lastExecutionResult = 2;
                    if (!exitOnError) continue;
                    break;
                }
                if (line == null) continue;
                lastExecutionResult = 0;
            }
            catch (Throwable t) {
                this.handleException(t);
                return 2;
            }
        }
        return lastExecutionResult;
    }

    @Override
    public void close() {
        this.commands.closeall(null);
    }

    private void setupHistory() throws IOException {
        if (this.history != null) {
            return;
        }
        this.history = new FileHistory(new File(this.getOpts().getHistoryFile()));
    }

    private void addBeelineShutdownHook() throws IOException {
        ShutdownHookManager.addShutdownHook((Runnable)this.getShutdownHook());
    }

    public ConsoleReader initializeConsoleReader(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            SequenceInputStream inputStreamAppendedNewline = new SequenceInputStream(inputStream, new ByteArrayInputStream(new String("\n").getBytes()));
            this.consoleReader = new ConsoleReader((InputStream)inputStreamAppendedNewline, (OutputStream)this.findPrintStream());
            this.consoleReader.setCopyPasteDetection(true);
        } else {
            this.consoleReader = new ConsoleReader(this.getInputStream(), (OutputStream)this.findPrintStream());
        }
        this.consoleReader.setExpandEvents(false);
        try {
            if (this.history != null) {
                this.consoleReader.setHistory((History)this.history);
            } else {
                this.consoleReader.setHistoryEnabled(false);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (inputStream instanceof FileInputStream || inputStream instanceof FSDataInputStream) {
            return this.consoleReader;
        }
        this.consoleReader.addCompleter((Completer)new BeeLineCompleter(this));
        return this.consoleReader;
    }

    private PrintStream findPrintStream() {
        return this.getOpts().isSilent() && this.getOpts().getScriptFile() != null ? new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        }) : this.getErrorStream();
    }

    void usage() {
        this.output(this.loc("cmd-usage"));
    }

    public boolean execCommandWithPrefix(String line) {
        TreeMap<String, CommandHandler> cmdMap = new TreeMap<String, CommandHandler>();
        line = line.substring(1);
        for (int i = 0; i < this.commandHandlers.length; ++i) {
            String match = this.commandHandlers[i].matches(line);
            if (match == null) continue;
            cmdMap.put(match, this.commandHandlers[i]);
        }
        if (cmdMap.size() == 0) {
            return this.error(this.loc("unknown-command", line));
        }
        if (cmdMap.size() > 1) {
            CommandHandler handler = (CommandHandler)cmdMap.get(line);
            if (handler == null) {
                return this.error(this.loc("multiple-matches", cmdMap.keySet().toString()));
            }
            return handler.execute(line);
        }
        return ((CommandHandler)cmdMap.values().iterator().next()).execute(line);
    }

    boolean dispatch(String line) {
        if (line == null) {
            this.exit = true;
            return true;
        }
        if (line.trim().length() == 0) {
            return true;
        }
        if (this.isComment(line)) {
            return true;
        }
        line = line.trim();
        if (this.scriptOutputFile != null) {
            this.scriptOutputFile.addLine(line);
        }
        if (this.isHelpRequest(line)) {
            line = "!help";
        }
        if (this.isBeeLine) {
            if (line.startsWith(COMMAND_PREFIX)) {
                return this.execCommandWithPrefix(line);
            }
            return this.commands.sql(line, this.getOpts().getEntireLineAsCommand());
        }
        return this.commands.sql(line, this.getOpts().getEntireLineAsCommand());
    }

    boolean needsContinuation(String line) {
        if (this.isHelpRequest(line)) {
            return false;
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            return false;
        }
        if (this.isComment(line)) {
            return false;
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0) {
            return false;
        }
        if (!this.getOpts().isAllowMultiLineCommand()) {
            return false;
        }
        return !trimmed.endsWith(this.getOpts().getDelimiter());
    }

    boolean isHelpRequest(String line) {
        return line.equals("?") || line.equalsIgnoreCase("help");
    }

    boolean isComment(String line) {
        String lineTrimmed = line.trim();
        return lineTrimmed.startsWith("#") || lineTrimmed.startsWith("--");
    }

    String[] getCommands(File file) throws IOException {
        LinkedList<String> cmds = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            String scriptLine;
            StringBuilder cmd = null;
            while ((scriptLine = reader.readLine()) != null) {
                String trimmedLine = scriptLine.trim();
                if (this.getOpts().getTrimScripts()) {
                    scriptLine = trimmedLine;
                }
                if (cmd != null) {
                    cmd.append("\n");
                    cmd.append(scriptLine);
                    if (!trimmedLine.endsWith(this.getOpts().getDelimiter())) continue;
                    cmds.add(cmd.toString());
                    cmd = null;
                    continue;
                }
                if (this.needsContinuation(scriptLine)) {
                    cmd = new StringBuilder(scriptLine);
                    continue;
                }
                cmds.add(scriptLine);
            }
            if (cmd != null) {
                cmd.append(this.getOpts().getDelimiter());
                cmds.add(cmd.toString());
            }
        }
        return cmds.toArray(new String[0]);
    }

    void output(String msg) {
        this.output(msg, true);
    }

    void info(String msg) {
        if (!this.getOpts().isSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    void info(ColorBuffer msg) {
        if (!this.getOpts().isSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    boolean error(String msg) {
        this.output(this.getColorBuffer().red(msg), true, this.getErrorStream());
        return false;
    }

    boolean error(Throwable t) {
        this.handleException(t);
        return false;
    }

    void debug(String msg) {
        if (this.getOpts().getVerbose()) {
            this.output(this.getColorBuffer().blue(msg), true, this.getErrorStream());
        }
    }

    void output(ColorBuffer msg) {
        this.output(msg, true);
    }

    void output(String msg, boolean newline, PrintStream out) {
        this.output(this.getColorBuffer(msg), newline, out);
    }

    void output(ColorBuffer msg, boolean newline) {
        this.output(msg, newline, this.getOutputStream());
    }

    void output(ColorBuffer msg, boolean newline, PrintStream out) {
        if (newline) {
            out.println(msg.getColor());
        } else {
            out.print(msg.getColor());
        }
        if (this.recordOutputFile == null) {
            return;
        }
        if (newline) {
            this.recordOutputFile.addLine(msg.getMono());
        } else {
            this.recordOutputFile.print(msg.getMono());
        }
    }

    void output(String msg, boolean newline) {
        this.output(this.getColorBuffer(msg), newline);
    }

    void autocommitStatus(Connection c) throws SQLException {
        this.info(this.loc("autocommit-status", "" + c.getAutoCommit()));
    }

    boolean assertAutoCommit() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (this.getDatabaseConnection().getConnection().getAutoCommit()) {
                return this.error(this.loc("autocommit-needs-off"));
            }
        }
        catch (Exception e) {
            return this.error(e);
        }
        return true;
    }

    boolean assertConnection() {
        try {
            if (this.getDatabaseConnection() == null || this.getDatabaseConnection().getConnection() == null) {
                return this.error(this.loc("no-current-connection"));
            }
            if (this.getDatabaseConnection().getConnection().isClosed()) {
                return this.error(this.loc("connection-is-closed"));
            }
        }
        catch (SQLException sqle) {
            return this.error(this.loc("no-current-connection"));
        }
        return true;
    }

    void showWarnings() {
        try {
            if (this.getDatabaseConnection().getConnection() == null || !this.getOpts().getVerbose()) {
                return;
            }
            this.showWarnings(this.getDatabaseConnection().getConnection().getWarnings());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void showWarnings(SQLWarning warn) {
        SQLWarning next;
        if (warn == null) {
            return;
        }
        if (this.seenWarnings.get(warn) == null) {
            this.seenWarnings.put(warn, new Date());
            this.handleSQLException(warn);
        }
        if ((next = warn.getNextWarning()) != warn) {
            this.showWarnings(next);
        }
    }

    String getPrompt() {
        if (this.isBeeLine) {
            return this.getPromptForBeeline();
        }
        return this.getPromptForCli();
    }

    String getPromptForCli() {
        HiveConf conf = this.getCommands().getHiveConf(true);
        String prompt = conf.getVar(HiveConf.ConfVars.CLIPROMPT);
        prompt = this.getCommands().substituteVariables(conf, prompt);
        return prompt + this.getFormattedDb() + "> ";
    }

    String getFormattedDb() {
        if (!this.getOpts().getShowDbInPrompt()) {
            return "";
        }
        String currDb = this.getCurrentDatabase();
        if (currDb == null) {
            return "";
        }
        return " (" + currDb + ")";
    }

    String getPromptForBeeline() {
        if (this.getDatabaseConnection() == null || this.getDatabaseConnection().getUrl() == null) {
            return "beeline> ";
        }
        String printClosed = this.getDatabaseConnection().isClosed() ? " (closed)" : "";
        return BeeLine.getPromptForBeeline(this.getDatabaseConnections().getIndex() + ": " + this.getDatabaseConnection().getUrl()) + printClosed + this.getFormattedDb() + "> ";
    }

    static String getPromptForBeeline(String url) {
        if (url == null || url.length() == 0) {
            url = "beeline";
        }
        if (url.indexOf(";") > -1) {
            url = url.substring(0, url.indexOf(";"));
        }
        if (url.indexOf("?") > -1) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (url.length() > 45) {
            url = url.substring(0, 45);
        }
        return url;
    }

    int getSize(ResultSet rs) {
        try {
            if (rs.getType() == 1003) {
                return -1;
            }
            rs.last();
            int total = rs.getRow();
            rs.beforeFirst();
            return total;
        }
        catch (SQLException sqle) {
            return -1;
        }
        catch (AbstractMethodError ame) {
            return -1;
        }
    }

    ResultSet getColumns(String table) throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().getDatabaseMetaData().getColumns(this.getDatabaseConnection().getDatabaseMetaData().getConnection().getCatalog(), null, table, "%");
    }

    ResultSet getTables() throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().getDatabaseMetaData().getTables(this.getDatabaseConnection().getDatabaseMetaData().getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getColumnNames(DatabaseMetaData meta) throws SQLException {
        HashSet<Object> names = new HashSet<Object>();
        this.info(this.loc("building-tables"));
        try {
            try (ResultSet columns = this.getColumns("%");){
                int total = this.getSize(columns);
                int index = 0;
                while (columns.next()) {
                    this.progress(index++, total);
                    String name = columns.getString("TABLE_NAME");
                    names.add(name);
                    names.add(columns.getString("COLUMN_NAME"));
                    names.add(columns.getString("TABLE_NAME") + "." + columns.getString("COLUMN_NAME"));
                }
                this.progress(index, index);
            }
            this.info(this.loc("done"));
            return names.toArray(new String[0]);
        }
        catch (Throwable t) {
            this.handleException(t);
            return new String[0];
        }
    }

    String[] split(String line) {
        return this.split(line, " ");
    }

    String dequote(String str) {
        if (str == null) {
            return null;
        }
        while (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    String[] split(String line, String delim) {
        StringTokenizer tok = new StringTokenizer(line, delim);
        String[] ret = new String[tok.countTokens()];
        int index = 0;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            t = this.dequote(t);
            ret[index++] = t;
        }
        return ret;
    }

    static Map<Object, Object> map(Object[] obs) {
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < obs.length - 1; i += 2) {
            m.put(obs[i], obs[i + 1]);
        }
        return Collections.unmodifiableMap(m);
    }

    static boolean getMoreResults(Statement stmnt) {
        try {
            return stmnt.getMoreResults();
        }
        catch (Throwable t) {
            return false;
        }
    }

    static String xmlattrencode(String str) {
        str = BeeLine.replace(str, "\"", "&quot;");
        str = BeeLine.replace(str, "<", "&lt;");
        return str;
    }

    static String replace(String source, String from, String to) {
        if (source == null) {
            return null;
        }
        if (from.equals(to)) {
            return source;
        }
        StringBuilder replaced = new StringBuilder();
        int index = -1;
        while ((index = source.indexOf(from)) != -1) {
            replaced.append(source.substring(0, index));
            replaced.append(to);
            source = source.substring(index + from.length());
        }
        replaced.append(source);
        return replaced.toString();
    }

    String[] split(String line, int assertLen, String usage) {
        String[] ret = this.split(line);
        if (ret.length != assertLen) {
            this.error(usage);
            return null;
        }
        return ret;
    }

    String wrap(String toWrap, int len, int start) {
        StringBuilder buff = new StringBuilder();
        StringBuilder line = new StringBuilder();
        char[] head = new char[start];
        Arrays.fill(head, ' ');
        StringTokenizer tok = new StringTokenizer(toWrap, " ");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            if (line.length() + next.length() > len) {
                buff.append((CharSequence)line).append(separator).append(head);
                line.setLength(0);
            }
            line.append(line.length() == 0 ? "" : " ").append(next);
        }
        buff.append((CharSequence)line);
        return buff.toString();
    }

    void progress(int cur, int max) {
        StringBuilder out = new StringBuilder();
        if (this.lastProgress != null) {
            char[] back = new char[this.lastProgress.length()];
            Arrays.fill(back, '\b');
            out.append(back);
        }
        String progress = cur + "/" + (String)(max == -1 ? "?" : "" + max) + " " + (String)(max == -1 ? "(??%)" : "(" + cur * 100 / (max == 0 ? 1 : max) + "%)");
        if (cur >= max && max != -1) {
            progress = progress + " " + this.loc("done") + separator;
            this.lastProgress = null;
        } else {
            this.lastProgress = progress;
        }
        out.append(progress);
        this.outputStream.print(out.toString());
        this.outputStream.flush();
    }

    void handleException(Throwable e) {
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof SQLException) {
            this.handleSQLException((SQLException)e);
        } else if (e instanceof EOFException) {
            this.setExit(true);
        } else if (!this.getOpts().getVerbose()) {
            if (e.getMessage() == null) {
                this.error(e.getClass().getName());
            } else {
                this.error(e.getMessage());
            }
        } else {
            e.printStackTrace(this.getErrorStream());
        }
    }

    void handleSQLException(SQLException e) {
        if (e instanceof SQLWarning && !this.getOpts().getShowWarnings()) {
            return;
        }
        if (e.getCause() instanceof TTransportException) {
            switch (((TTransportException)e.getCause()).getType()) {
                case 2: {
                    this.error(this.loc("hs2-connection-already-open"));
                    break;
                }
                case 4: {
                    this.error(this.loc("hs2-unexpected-end-of-file"));
                    break;
                }
                case 1: {
                    this.error(this.loc("hs2-could-not-open-connection"));
                    break;
                }
                case 3: {
                    this.error(this.loc("hs2-connection-timed-out"));
                    break;
                }
                case 0: {
                    this.error(this.loc("hs2-unknown-connection-problem"));
                    break;
                }
                default: {
                    this.error(this.loc("hs2-unexpected-error"));
                }
            }
        }
        this.error(this.loc(e instanceof SQLWarning ? "Warning" : "Error", new Object[]{e.getMessage() == null ? "" : e.getMessage().trim(), e.getSQLState() == null ? "" : e.getSQLState().trim(), new Integer(e.getErrorCode())}));
        if (this.getOpts().getVerbose()) {
            e.printStackTrace(this.getErrorStream());
        }
        if (!this.getOpts().getShowNestedErrs()) {
            return;
        }
        for (SQLException nested = e.getNextException(); nested != null && nested != e; nested = nested.getNextException()) {
            this.handleSQLException(nested);
        }
    }

    boolean scanForDriver(String url) {
        try {
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(true);
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(false);
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            return this.findLocalDriver(url) != null;
        }
        catch (Exception e) {
            this.debug(e.toString());
            return false;
        }
    }

    private Driver findRegisteredDriver(String url) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers != null && drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                if (!driver.acceptsURL(url)) continue;
                return driver;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Driver findLocalDriver(String url) throws Exception {
        if (this.drivers == null) {
            return null;
        }
        for (Driver d : this.drivers) {
            try {
                String clazzName = d.getClass().getName();
                Driver driver = (Driver)Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                if (!driver.acceptsURL(url) || !this.isSupportedLocalDriver(driver)) continue;
                return driver;
            }
            catch (SQLException e) {
                this.error(e);
                throw new Exception(e);
            }
        }
        return null;
    }

    public boolean isSupportedLocalDriver(Driver driver) {
        String driverName = driver.getClass().getName();
        for (String name : this.supportedLocalDriver) {
            if (!name.equals(driverName)) continue;
            return true;
        }
        return false;
    }

    public void addLocalDriverClazz(String driverClazz) {
        this.supportedLocalDriver.add(driverClazz);
    }

    Driver[] scanDrivers(String line) throws IOException {
        return this.scanDrivers(false);
    }

    Driver[] scanDrivers(boolean knownOnly) throws IOException {
        long start = System.currentTimeMillis();
        ServiceLoader<Driver> sqlDrivers = ServiceLoader.load(Driver.class);
        HashSet<Driver> driverClasses = new HashSet<Driver>();
        for (Driver driver : sqlDrivers) {
            driverClasses.add(driver);
        }
        this.info("scan complete in " + (System.currentTimeMillis() - start) + "ms");
        return driverClasses.toArray(new Driver[0]);
    }

    int print(ResultSet rs) throws SQLException {
        String format = this.getOpts().getOutputFormat();
        OutputFormat f = (OutputFormat)this.formats.get(format);
        if (f == null) {
            this.error(this.loc("unknown-format", new Object[]{format, this.formats.keySet()}));
            f = new TableOutputFormat(this);
        }
        Rows rows = f instanceof TableOutputFormat ? (this.getOpts().getIncremental() ? new IncrementalRowsWithNormalization(this, rs) : new BufferedRows(this, rs)) : new IncrementalRows(this, rs);
        return f.print(rows);
    }

    Statement createStatement() throws SQLException {
        Statement stmnt = this.getDatabaseConnection().getConnection().createStatement();
        if (this.getOpts().timeout > -1) {
            stmnt.setQueryTimeout(this.getOpts().timeout);
        }
        if (this.signalHandler != null) {
            this.signalHandler.setStatement(stmnt);
        }
        return stmnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBatch(List<String> statements) {
        try {
            Statement stmnt = this.createStatement();
            try {
                Iterator<String> i = statements.iterator();
                while (i.hasNext()) {
                    stmnt.addBatch(i.next().toString());
                }
                int[] counts = stmnt.executeBatch();
                this.output(this.getColorBuffer().pad(this.getColorBuffer().bold("COUNT"), 8).append(this.getColorBuffer().bold("STATEMENT")));
                for (int i2 = 0; counts != null && i2 < counts.length; ++i2) {
                    this.output(this.getColorBuffer().pad("" + counts[i2], 8).append(statements.get(i2).toString()));
                }
            }
            finally {
                try {
                    stmnt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int runCommands(String[] cmds) {
        return this.runCommands(Arrays.asList(cmds));
    }

    public int runCommands(List<String> cmds) {
        int successCount = 0;
        try {
            for (String cmd : cmds) {
                this.info(this.getColorBuffer().pad(SCRIPT_OUTPUT_PREFIX, 5).append(cmd));
                if (this.dispatch(cmd) || this.getOpts().getForce()) {
                    ++successCount;
                    continue;
                }
                this.error(this.loc("abort-on-error", cmd));
                return successCount;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return successCount;
    }

    void setCompletions() throws SQLException, IOException {
        if (this.getDatabaseConnection() != null) {
            this.getDatabaseConnection().setCompletions(this.getOpts().getFastConnect());
        }
    }

    public BeeLineOpts getOpts() {
        return this.opts;
    }

    DatabaseConnections getDatabaseConnections() {
        return this.connections;
    }

    Runnable getShutdownHook() {
        return this.shutdownHook;
    }

    Completer getCommandCompletor() {
        return this.beeLineCommandCompleter;
    }

    public boolean isExit() {
        return this.exit;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    Collection<Driver> getDrivers() {
        return this.drivers;
    }

    void setDrivers(Collection<Driver> drivers) {
        this.drivers = drivers;
    }

    public static String getSeparator() {
        return separator;
    }

    Commands getCommands() {
        return this.commands;
    }

    OutputFile getScriptOutputFile() {
        return this.scriptOutputFile;
    }

    void setScriptOutputFile(OutputFile script) {
        this.scriptOutputFile = script;
    }

    OutputFile getRecordOutputFile() {
        return this.recordOutputFile;
    }

    void setRecordOutputFile(OutputFile record) {
        this.recordOutputFile = record;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = new PrintStream(outputStream, true);
    }

    PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = new PrintStream(errorStream, true);
    }

    PrintStream getErrorStream() {
        return this.errorStream;
    }

    InputStream getInputStream() {
        return this.inputStream;
    }

    ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    void setConsoleReader(ConsoleReader reader) {
        this.consoleReader = reader;
    }

    List<String> getBatch() {
        return this.batch;
    }

    void setBatch(List<String> batch) {
        this.batch = batch;
    }

    protected Reflector getReflector() {
        return this.reflector;
    }

    public boolean isBeeLine() {
        return this.isBeeLine;
    }

    public void setBeeLine(boolean isBeeLine) {
        this.isBeeLine = isBeeLine;
    }

    public String getCurrentDatabase() {
        if (this.currentDatabase == null) {
            this.currentDatabase = DEFAULT_DATABASE_NAME;
        }
        return this.currentDatabase;
    }

    public void setCurrentDatabase(String currentDatabase) {
        this.currentDatabase = currentDatabase;
    }

    void setIsTestMode(boolean isTestMode) {
        this.isTestMode = isTestMode;
    }

    boolean isTestMode() {
        return this.isTestMode;
    }

    static {
        try {
            Class.forName("jline.console.ConsoleReader");
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("jline-missing");
        }
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"driver class");
        OptionBuilder.withDescription((String)"The driver class to use");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"database url");
        OptionBuilder.withDescription((String)"The JDBC URL to connect to");
        options.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"named JDBC URL in beeline-site.xml");
        OptionBuilder.withDescription((String)"The named JDBC URL to connect to, which should be present in beeline-site.xml as the value of beeline.hs2.jdbc.url.<namedUrl>");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"reconnect");
        OptionBuilder.withDescription((String)"Reconnect to last saved connect url (in conjunction with !save)");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.withDescription((String)"The username to connect as");
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.withDescription((String)"The password to connect as");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password-file");
        OptionBuilder.withDescription((String)"The password file to read password from");
        OptionBuilder.withLongOpt((String)"password-file");
        options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"authType");
        OptionBuilder.withDescription((String)"The authentication type");
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"init");
        OptionBuilder.withDescription((String)"The script file for initialization");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"query");
        OptionBuilder.withDescription((String)"The query that should be executed");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"The script file that should be executed");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Display this message");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"hivevar");
        OptionBuilder.withDescription((String)"Hive variable name and value");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"property-file");
        OptionBuilder.withDescription((String)"The file to read configuration properties from");
        options.addOption(OptionBuilder.create());
    }

    public class BeelineParser
    extends GnuParser {
        private boolean isPasswordOptionSet = false;

        protected void processOption(String arg, ListIterator iter) throws ParseException {
            if (this.isBeeLineOpt(arg)) {
                this.processBeeLineOpt(arg);
            } else {
                if ("-p".equals(arg)) {
                    this.isPasswordOptionSet = true;
                    if (iter.hasNext()) {
                        String next = (String)iter.next();
                        if (this.isBeeLineOpt(next)) {
                            this.processBeeLineOpt(next);
                            return;
                        }
                        iter.previous();
                    }
                }
                super.processOption(arg, iter);
            }
        }

        private void processBeeLineOpt(String arg) {
            String stripped = arg.substring(2, arg.length());
            String[] parts = BeeLine.this.split(stripped, "=");
            BeeLine.this.debug(BeeLine.this.loc("setting-prop", Arrays.asList(parts)));
            if (parts.length >= 2) {
                BeeLine.this.getOpts().set(parts[0], parts[1], true);
            } else {
                BeeLine.this.getOpts().set(parts[0], "true", true);
            }
        }

        private boolean isBeeLineOpt(String arg) {
            return arg.startsWith("--") && !BeeLine.HIVE_VAR_PREFIX.equals(arg) && !BeeLine.HIVE_CONF_PREFIX.equals(arg) && !"--help".equals(arg) && !BeeLine.PROP_FILE_PREFIX.equals(arg);
        }
    }
}

