/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.BufferedRows;
import org.apache.hive.beeline.Rows;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestBufferedRows {
    private String[][] mockRowData = new String[][]{{"key1", "aaa"}, {"key2", "bbbbb"}, {"key3", "cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc"}, {"key4", "ddddddddddddddd"}};
    private BeeLineOpts mockBeeLineOpts;
    private BeeLine mockBeeline;
    private ResultSet mockResultSet;
    private MockRow mockRow;

    @Test
    public void testNormalizeWidths() throws SQLException {
        this.setupMockData();
        BufferedRows bfRows = new BufferedRows(this.mockBeeline, this.mockResultSet);
        bfRows.normalizeWidths();
        while (bfRows.hasNext()) {
            Rows.Row row = (Rows.Row)bfRows.next();
            for (int colSize : row.sizes) {
                Assert.assertTrue((colSize <= this.mockBeeLineOpts.getMaxColumnWidth() ? 1 : 0) != 0);
            }
        }
    }

    private void setupMockData() throws SQLException {
        this.mockBeeline = (BeeLine)Mockito.mock(BeeLine.class);
        this.mockBeeLineOpts = (BeeLineOpts)Mockito.mock(BeeLineOpts.class);
        Mockito.when((Object)this.mockBeeLineOpts.getMaxColumnWidth()).thenReturn((Object)50);
        Mockito.when((Object)this.mockBeeLineOpts.getNumberFormat()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockBeeLineOpts.getNullString()).thenReturn((Object)"NULL");
        Mockito.when((Object)this.mockBeeline.getOpts()).thenReturn((Object)this.mockBeeLineOpts);
        this.mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData mockResultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)mockResultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(1)).thenReturn((Object)"Key");
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(2)).thenReturn((Object)"Value");
        Mockito.when((Object)this.mockResultSet.getMetaData()).thenReturn((Object)mockResultSetMetaData);
        this.mockRow = new MockRow();
        Mockito.when((Object)this.mockResultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){
            private int mockRowDataIndex = 0;

            public Boolean answer(InvocationOnMock invocation) {
                if (this.mockRowDataIndex < TestBufferedRows.this.mockRowData.length) {
                    TestBufferedRows.this.mockRow.setCurrentRowData(TestBufferedRows.this.mockRowData[this.mockRowDataIndex]);
                    ++this.mockRowDataIndex;
                    return true;
                }
                return false;
            }
        });
        Mockito.when((Object)this.mockResultSet.getString(ArgumentMatchers.anyInt())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                int index = (Integer)args[0];
                return TestBufferedRows.this.mockRow.getColumn(index);
            }
        });
    }

    static class MockRow {
        String[] rowData;

        MockRow() {
        }

        public void setCurrentRowData(String[] rowData) {
            this.rowData = rowData;
        }

        public String getColumn(int idx) {
            return this.rowData[idx - 1];
        }
    }
}

