/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.beeline.HiveSchemaTool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHiveSchemaTool {
    private String scriptFile = TestHiveSchemaTool.getFileFromClasspath("someScript.sql");
    private static HiveConf hiveConf = new HiveConf();
    private HiveSchemaTool.CommandBuilder builder;
    private String pasword = "reallySimplePassword";

    @Before
    public void setup() {
        this.builder = new HiveSchemaTool.CommandBuilder(hiveConf, null, null, "testUser", this.pasword, this.scriptFile);
    }

    @Test
    public void shouldReturnStrippedPassword() throws IOException {
        Assert.assertFalse((boolean)this.builder.buildToLog().contains(this.pasword));
    }

    @Test
    public void shouldReturnActualPassword() throws IOException {
        String[] strings = this.builder.buildToRun();
        Assert.assertTrue((boolean)Arrays.asList(strings).contains(this.pasword));
    }

    private static String getFileFromClasspath(String name) {
        URL url = ClassLoader.getSystemResource(name);
        if (url == null) {
            throw new IllegalArgumentException("Could not find " + name);
        }
        return url.getPath();
    }

    static {
        hiveConf.set("fs.default.name", "file:///");
    }
}

