/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.common.util.HiveStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCommands {
    @Test
    public void testLinesEndingWithComments() {
        int[] escape = new int[]{-1};
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables;", (int[])escape));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; --comments", (int[])escape));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; -------comments;one;two;three;;;;", (int[])escape));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"show-- tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"show --tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"s", (Object)HiveStringUtils.removeComments((String)"s--how --tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"", (Object)HiveStringUtils.removeComments((String)"-- show tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"\"show tables\"", (Object)HiveStringUtils.removeComments((String)"\"show tables\" --comments", (int[])escape));
        Assert.assertEquals((Object)"\"show --comments tables\"", (Object)HiveStringUtils.removeComments((String)"\"show --comments tables\" --comments", (int[])escape));
        Assert.assertEquals((Object)"\"'show --comments' tables\"", (Object)HiveStringUtils.removeComments((String)"\"'show --comments' tables\" --comments", (int[])escape));
        Assert.assertEquals((Object)"'show --comments tables'", (Object)HiveStringUtils.removeComments((String)"'show --comments tables' --comments", (int[])escape));
        Assert.assertEquals((Object)"'\"show --comments tables\"'", (Object)HiveStringUtils.removeComments((String)"'\"show --comments tables\"' --comments", (int[])escape));
    }

    @Test
    public void testBeelineCommands() throws IOException {
        System.setProperty("beeline.system.exit", "true");
        BeeLine.mainWithInputRedirection((String[])new String[]{"-u", "jdbc:hive2://", "-e", "select 3"}, null);
        BeeLine.mainWithInputRedirection((String[])new String[]{"-u", "jdbc:hive2://", "-e", "create table t1(x int); show tables"}, null);
    }
}

