/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.IncrementalRows;
import org.apache.hive.beeline.IncrementalRowsWithNormalization;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestIncrementalRows {
    private BeeLineOpts mockBeeLineOpts;
    private BeeLine mockBeeline;
    private Integer incrementalBufferRows = 5;
    private ResultSet mockResultSet;

    @Before
    public void init() throws SQLException {
        this.mockBeeLineOpts = (BeeLineOpts)Mockito.mock(BeeLineOpts.class);
        Mockito.when((Object)this.mockBeeLineOpts.getIncrementalBufferRows()).thenReturn((Object)this.incrementalBufferRows);
        Mockito.when((Object)this.mockBeeLineOpts.getMaxColumnWidth()).thenReturn((Object)50);
        Mockito.when((Object)this.mockBeeLineOpts.getNumberFormat()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockBeeLineOpts.getNullString()).thenReturn((Object)"NULL");
        this.mockBeeline = (BeeLine)Mockito.mock(BeeLine.class);
        Mockito.when((Object)this.mockBeeline.getOpts()).thenReturn((Object)this.mockBeeLineOpts);
        this.mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData mockResultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)mockResultSetMetaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(1)).thenReturn((Object)"Mock Table");
        Mockito.when((Object)this.mockResultSet.getMetaData()).thenReturn((Object)mockResultSetMetaData);
    }

    @Test
    public void testIncrementalRowsBinaryArrayConvert() throws SQLException {
        Mockito.when((Object)this.mockBeeLineOpts.getConvertBinaryArrayToString()).thenReturn((Object)true);
        this.initNrOfResultSetCalls(1);
        Mockito.when((Object)this.mockResultSet.getObject(1)).thenReturn((Object)new byte[]{77, 77, 77});
        IncrementalRows convertedIr = new IncrementalRows(this.mockBeeline, this.mockResultSet);
        convertedIr.next();
        String row = convertedIr.next().toString();
        Assert.assertEquals((Object)"[MMM]", (Object)row);
    }

    @Test
    public void testIncrementalRowsBinaryArraySkipConvert() throws SQLException {
        Mockito.when((Object)this.mockBeeLineOpts.getConvertBinaryArrayToString()).thenReturn((Object)false);
        this.initNrOfResultSetCalls(1);
        Mockito.when((Object)this.mockResultSet.getObject(1)).thenReturn((Object)new byte[]{77, 77, 77});
        IncrementalRows convertedIr = new IncrementalRows(this.mockBeeline, this.mockResultSet);
        convertedIr.next();
        String row = convertedIr.next().toString();
        Assert.assertEquals((Object)"[[77, 77, 77]]", (Object)row);
    }

    public void initNrOfResultSetCalls(final int iter) throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){
            private int iterations;
            {
                this.iterations = iter;
            }

            public Boolean answer(InvocationOnMock invocation) {
                return this.iterations-- > 0;
            }
        });
    }

    @Test
    public void testIncrementalRowsWithNormalization() throws SQLException {
        this.initNrOfResultSetCalls(10);
        Mockito.when((Object)this.mockResultSet.getObject(1)).thenReturn((Object)"Hello World");
        IncrementalRowsWithNormalization incrementalRowsWithNormalization = new IncrementalRowsWithNormalization(this.mockBeeline, this.mockResultSet);
        ((ResultSet)Mockito.verify((Object)this.mockResultSet, (VerificationMode)Mockito.times((int)5))).next();
        for (int i = 0; i < this.incrementalBufferRows + 1; ++i) {
            incrementalRowsWithNormalization.next();
        }
        ((ResultSet)Mockito.verify((Object)this.mockResultSet, (VerificationMode)Mockito.times((int)5))).next();
        incrementalRowsWithNormalization.next();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet, (VerificationMode)Mockito.times((int)10))).next();
    }
}

