/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.hive.beeline.ClassNameCompleter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestClassNameCompleter {
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingAndEmptyJarFile() throws IOException {
        String fileName = "empty.file.jar";
        File p = tmpFolder.newFile(fileName);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader newClassLoader = new URLClassLoader(new URL[]{p.toURL()}, classLoader);
            Thread.currentThread().setContextClassLoader(newClassLoader);
            ClassNameCompleter.getClassNames();
            Assert.fail((String)"an exception was expected!");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"Exception message should contain the filename!", (e.getMessage().indexOf(fileName) >= 0 ? 1 : 0) != 0);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingEmptyFile() throws IOException {
        String fileName = "empty.file";
        File p = tmpFolder.newFile(fileName);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader newClassLoader = new URLClassLoader(new URL[]{p.toURL()}, classLoader);
            Thread.currentThread().setContextClassLoader(newClassLoader);
            ClassNameCompleter.getClassNames();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

