/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.IncrementalRowsWithNormalization;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestIncrementalRowsWithNormalization {
    @Test
    public void testIncrementalRows() throws SQLException {
        Integer incrementalBufferRows = 5;
        BeeLineOpts mockBeeLineOpts = (BeeLineOpts)Mockito.mock(BeeLineOpts.class);
        Mockito.when((Object)mockBeeLineOpts.getIncrementalBufferRows()).thenReturn((Object)incrementalBufferRows);
        Mockito.when((Object)mockBeeLineOpts.getMaxColumnWidth()).thenReturn((Object)50);
        Mockito.when((Object)mockBeeLineOpts.getNumberFormat()).thenReturn((Object)"default");
        Mockito.when((Object)mockBeeLineOpts.getNullString()).thenReturn((Object)"NULL");
        BeeLine mockBeeline = (BeeLine)Mockito.mock(BeeLine.class);
        Mockito.when((Object)mockBeeline.getOpts()).thenReturn((Object)mockBeeLineOpts);
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData mockResultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)mockResultSetMetaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(1)).thenReturn((Object)"Mock Table");
        Mockito.when((Object)mockResultSet.getMetaData()).thenReturn((Object)mockResultSetMetaData);
        Mockito.when((Object)mockResultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){
            private int iterations = 10;

            public Boolean answer(InvocationOnMock invocation) {
                return this.iterations-- > 0;
            }
        });
        Mockito.when((Object)mockResultSet.getString(1)).thenReturn((Object)"Hello World");
        IncrementalRowsWithNormalization incrementalRowsWithNormalization = new IncrementalRowsWithNormalization(mockBeeline, mockResultSet);
        ((ResultSet)Mockito.verify((Object)mockResultSet, (VerificationMode)Mockito.times((int)5))).next();
        for (int i = 0; i < incrementalBufferRows + 1; ++i) {
            incrementalRowsWithNormalization.next();
        }
        ((ResultSet)Mockito.verify((Object)mockResultSet, (VerificationMode)Mockito.times((int)5))).next();
        incrementalRowsWithNormalization.next();
        ((ResultSet)Mockito.verify((Object)mockResultSet, (VerificationMode)Mockito.times((int)10))).next();
    }
}

