/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.mr.AccumuloIndexedOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public class HiveAccumuloTableOutputFormat
extends AccumuloIndexedOutputFormat {
    protected final HiveAccumuloHelper helper = new HiveAccumuloHelper();

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.configureAccumuloOutputFormat(job);
        super.checkOutputSpecs(ignored, job);
    }

    @Override
    public RecordWriter<Text, Mutation> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        this.configureAccumuloOutputFormat(job);
        return super.getRecordWriter(ignored, job, name, progress);
    }

    protected void configureAccumuloOutputFormat(JobConf job) throws IOException {
        AccumuloConnectionParameters cnxnParams = this.getConnectionParams(job);
        String tableName = job.get("accumulo.table.name");
        Preconditions.checkNotNull((Object)tableName, (Object)"Expected Accumulo table name to be provided in job configuration");
        try {
            if (cnxnParams.useMockInstance()) {
                this.getHelper().setOutputFormatMockInstance(job, cnxnParams.getAccumuloInstanceName());
            } else {
                this.getHelper().setOutputFormatZooKeeperInstance(job, cnxnParams.getAccumuloInstanceName(), cnxnParams.getZooKeepers(), cnxnParams.useSasl());
            }
            if (cnxnParams.useSasl()) {
                this.getHelper().updateOutputFormatConfWithAccumuloToken(job, this.getCurrentUser(), cnxnParams);
            } else {
                this.getHelper().setOutputFormatConnectorInfo(job, cnxnParams.getAccumuloUserName(), (AuthenticationToken)new PasswordToken((CharSequence)cnxnParams.getAccumuloPassword()));
            }
            this.setDefaultAccumuloTableName(job, tableName);
            String indexTableName = job.get("accumulo.indextable.name");
            String indexedColumns = job.get("accumulo.indexed.columns");
            String columnTypes = job.get("columns.types");
            boolean binaryEncoding = ColumnEncoding.BINARY.getName().equalsIgnoreCase(job.get("accumulo.default.storage"));
            this.setAccumuloIndexTableName(job, indexTableName);
            this.setAccumuloIndexColumns(job, indexedColumns);
            this.setAccumuloStringEncoding(job, !binaryEncoding);
        }
        catch (AccumuloSecurityException e) {
            log.error((Object)"Could not connect to Accumulo with provided credentials", (Throwable)e);
            throw new IOException(e);
        }
    }

    protected void setDefaultAccumuloTableName(JobConf conf, String tableName) {
        AccumuloIndexedOutputFormat.setDefaultTableName((JobConf)conf, (String)tableName);
    }

    protected void setAccumuloIndexTableName(JobConf conf, String indexTableName) {
        AccumuloIndexedOutputFormat.setIndexTableName(conf, indexTableName);
    }

    protected void setAccumuloIndexColumns(JobConf conf, String indexColumns) {
        AccumuloIndexedOutputFormat.setIndexColumns(conf, indexColumns);
    }

    protected void setAccumuloStringEncoding(JobConf conf, Boolean isStringEncoded) {
        AccumuloIndexedOutputFormat.setStringEncoding(conf, isStringEncoded);
    }

    HiveAccumuloHelper getHelper() {
        return this.helper;
    }

    AccumuloConnectionParameters getConnectionParams(JobConf conf) {
        return new AccumuloConnectionParameters((Configuration)conf);
    }

    UserGroupInformation getCurrentUser() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }
}

