/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.util.Properties;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.junit.Assert;
import org.junit.Test;

public class TestAccumuloSerDeParameters {
    @Test
    public void testParseColumnVisibility() throws SerDeException {
        Properties properties = new Properties();
        Configuration conf = new Configuration();
        properties.setProperty("accumulo.columns.mapping", ":rowid,cf:f2,cf:f3");
        properties.setProperty("columns", "field1,field2,field3");
        properties.setProperty("array", "string,string,string");
        properties.setProperty("accumulo.visibility.label", "foo&bar");
        AccumuloSerDeParameters params = new AccumuloSerDeParameters(conf, properties, AccumuloSerDe.class.getName());
        ColumnVisibility cv = params.getTableVisibilityLabel();
        Assert.assertEquals((Object)new ColumnVisibility("foo&bar"), (Object)cv);
    }

    @Test
    public void testParseAuthorizationsFromConf() throws SerDeException {
        Configuration conf = new Configuration(false);
        conf.set("accumulo.authorizations", "foo,bar");
        Authorizations auths = AccumuloSerDeParameters.getAuthorizationsFromConf((Configuration)conf);
        Assert.assertEquals((Object)new Authorizations(new String[]{"foo,bar"}), (Object)auths);
    }

    @Test
    public void testParseAuthorizationsFromnProperties() throws SerDeException {
        Configuration conf = new Configuration();
        Properties properties = new Properties();
        properties.setProperty("accumulo.columns.mapping", ":rowid,cf:f2,cf:f3");
        properties.setProperty("columns", "field1,field2,field3");
        properties.setProperty("columns.types", "string,string,string");
        properties.setProperty("accumulo.authorizations", "foo,bar");
        AccumuloSerDeParameters params = new AccumuloSerDeParameters(conf, properties, AccumuloSerDe.class.getName());
        Authorizations auths = params.getAuthorizations();
        Assert.assertEquals((Object)new Authorizations(new String[]{"foo,bar"}), (Object)auths);
    }

    @Test
    public void testNullAuthsFromProperties() throws SerDeException {
        Configuration conf = new Configuration();
        Properties properties = new Properties();
        properties.setProperty("accumulo.columns.mapping", ":rowid,cf:f2,cf:f3");
        properties.setProperty("columns", "field1,field2,field3");
        properties.setProperty("columns.types", "string,string,string");
        AccumuloSerDeParameters params = new AccumuloSerDeParameters(conf, properties, AccumuloSerDe.class.getName());
        Authorizations auths = params.getAuthorizations();
        Assert.assertNull((Object)auths);
    }

    @Test
    public void testNullAuthsFromConf() throws SerDeException {
        Configuration conf = new Configuration(false);
        Authorizations auths = AccumuloSerDeParameters.getAuthorizationsFromConf((Configuration)conf);
        Assert.assertNull((Object)auths);
    }
}

