/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestAccumuloHiveRow {
    @Test
    public void testHasFamilyAndQualifier() {
        int i;
        AccumuloHiveRow row = new AccumuloHiveRow("row1");
        for (i = 1; i <= 5; ++i) {
            row.add("cf1", "cq" + i, Integer.toString(i).getBytes());
        }
        Assert.assertFalse((boolean)row.hasFamAndQual(new Text(""), new Text("")));
        Assert.assertFalse((boolean)row.hasFamAndQual(new Text("cf0"), new Text("cq1")));
        Assert.assertFalse((boolean)row.hasFamAndQual(new Text("cf1"), new Text("cq0")));
        for (i = 1; i <= 5; ++i) {
            Assert.assertTrue((boolean)row.hasFamAndQual(new Text("cf1"), new Text("cq" + i)));
        }
    }

    @Test
    public void testGetValueFromColumn() {
        int i;
        AccumuloHiveRow row = new AccumuloHiveRow("row1");
        Assert.assertNull((Object)row.getValue(new Text(""), new Text("")));
        for (i = 1; i <= 5; ++i) {
            row.add("cf", "cq" + i, Integer.toString(i).getBytes());
        }
        Assert.assertNull((Object)row.getValue(new Text("cf"), new Text("cq0")));
        for (i = 1; i <= 5; ++i) {
            Assert.assertArrayEquals((byte[])Integer.toString(i).getBytes(), (byte[])row.getValue(new Text("cf"), new Text("cq" + i)));
        }
    }

    @Test
    public void testWritableEmptyRow() throws IOException {
        AccumuloHiveRow emptyRow = new AccumuloHiveRow();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        emptyRow.write((DataOutput)out);
        out.close();
        AccumuloHiveRow emptyCopy = new AccumuloHiveRow();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream in = new DataInputStream(bais);
        emptyCopy.readFields((DataInput)in);
        Assert.assertEquals((Object)emptyRow, (Object)emptyCopy);
    }

    @Test
    public void testWritableWithColumns() throws IOException {
        AccumuloHiveRow rowWithColumns = new AccumuloHiveRow("row");
        rowWithColumns.add("cf", "cq1", "1".getBytes());
        rowWithColumns.add("cf", "cq2", "2".getBytes());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        rowWithColumns.write((DataOutput)out);
        out.close();
        AccumuloHiveRow copy = new AccumuloHiveRow();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream in = new DataInputStream(bais);
        copy.readFields((DataInput)in);
        Assert.assertEquals((Object)rowWithColumns, (Object)copy);
    }
}

