/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.lexicoder.BigIntegerLexicoder;
import org.apache.accumulo.core.client.lexicoder.DoubleLexicoder;
import org.apache.accumulo.core.client.lexicoder.IntegerLexicoder;
import org.apache.accumulo.core.client.lexicoder.LongLexicoder;

public final class AccumuloIndexLexicoder {
    private static final IntegerLexicoder INTEGER_LEXICODER = new IntegerLexicoder();
    private static final DoubleLexicoder DOUBLE_LEXICODER = new DoubleLexicoder();
    private static final LongLexicoder LONG_LEXICODER = new LongLexicoder();
    private static final BigIntegerLexicoder BIG_INTEGER_LEXICODER = new BigIntegerLexicoder();
    private static final String DIM_PAT = "[(]+.*";

    private AccumuloIndexLexicoder() {
    }

    public static String getRawType(String hiveType) {
        if (hiveType != null) {
            return hiveType.toLowerCase().replaceFirst(DIM_PAT, "").trim();
        }
        return hiveType;
    }

    public static byte[] encodeValue(byte[] value, String hiveType, boolean stringEncoded) {
        if (stringEncoded) {
            return AccumuloIndexLexicoder.encodeStringValue(value, hiveType);
        }
        return AccumuloIndexLexicoder.encodeBinaryValue(value, hiveType);
    }

    public static byte[] encodeStringValue(byte[] value, String hiveType) {
        String rawType;
        switch (rawType = AccumuloIndexLexicoder.getRawType(hiveType)) {
            case "boolean": {
                return Boolean.valueOf(new String(value)).toString().getBytes(StandardCharsets.UTF_8);
            }
            case "smallint": 
            case "tinyint": 
            case "int": {
                return INTEGER_LEXICODER.encode(Integer.valueOf(new String(value)));
            }
            case "float": 
            case "double": {
                return DOUBLE_LEXICODER.encode(Double.valueOf(new String(value)));
            }
            case "bigint": {
                return BIG_INTEGER_LEXICODER.encode(new BigInteger(new String(value), 10));
            }
            case "decimal": {
                return new String(value).getBytes(StandardCharsets.UTF_8);
            }
        }
        return value;
    }

    public static byte[] encodeBinaryValue(byte[] value, String hiveType) {
        String rawType;
        switch (rawType = AccumuloIndexLexicoder.getRawType(hiveType)) {
            case "boolean": {
                return String.valueOf(value[0] == 1).getBytes();
            }
            case "int": {
                return INTEGER_LEXICODER.encode(Integer.valueOf(ByteBuffer.wrap(value).asIntBuffer().get()));
            }
            case "smallint": {
                return INTEGER_LEXICODER.encode(Integer.valueOf(ByteBuffer.wrap(value).asShortBuffer().get()));
            }
            case "tinyint": {
                return INTEGER_LEXICODER.encode(Integer.valueOf(value[0]));
            }
            case "float": {
                return DOUBLE_LEXICODER.encode(Double.valueOf(ByteBuffer.wrap(value).asFloatBuffer().get()));
            }
            case "double": {
                return DOUBLE_LEXICODER.encode(Double.valueOf(ByteBuffer.wrap(value).asDoubleBuffer().get()));
            }
            case "bigint": {
                return BIG_INTEGER_LEXICODER.encode(new BigInteger(value));
            }
            case "decimal": {
                return new String(value).getBytes(StandardCharsets.UTF_8);
            }
        }
        return value;
    }
}

