/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnEncoding {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCodeThrowsException() {
        ColumnEncoding.fromCode((String)"foo");
    }

    @Test
    public void testStringEncoding() {
        Assert.assertEquals((Object)ColumnEncoding.STRING, (Object)ColumnEncoding.fromCode((String)"s"));
    }

    @Test
    public void testBinaryEncoding() {
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)ColumnEncoding.fromCode((String)"b"));
    }

    @Test
    public void testMissingColumnEncoding() {
        Assert.assertFalse((boolean)ColumnEncoding.hasColumnEncoding((String)"foo:bar"));
    }

    @Test
    public void testColumnEncodingSpecified() {
        Assert.assertTrue((boolean)ColumnEncoding.hasColumnEncoding((String)"foo:bar#s"));
    }

    @Test
    public void testEscapedPoundIsNoEncodingSpecified() {
        Assert.assertFalse((boolean)ColumnEncoding.hasColumnEncoding((String)"foo:b\\#ar"));
    }

    @Test
    public void testEscapedPoundWithRealPound() {
        Assert.assertTrue((boolean)ColumnEncoding.hasColumnEncoding((String)"foo:b\\#ar#b"));
    }

    @Test
    public void testParse() {
        Assert.assertEquals((Object)ColumnEncoding.STRING, (Object)ColumnEncoding.getFromMapping((String)"foo:bar#s"));
    }

    @Test
    public void testParseWithEscapedPound() {
        Assert.assertEquals((Object)ColumnEncoding.BINARY, (Object)ColumnEncoding.getFromMapping((String)"fo\\#o:bar#b"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingEncodingOnParse() {
        ColumnEncoding.getFromMapping((String)"foo:bar");
    }

    @Test
    public void testStripCode() {
        String mapping = "foo:bar";
        Assert.assertEquals((Object)mapping, (Object)ColumnEncoding.stripCode((String)(mapping + "#" + ColumnEncoding.BINARY.getCode())));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStripNonExistentCodeFails() {
        ColumnEncoding.stripCode((String)"foo:bar");
    }

    @Test
    public void testStripCodeWithEscapedPound() {
        String mapping = "foo:ba\\#r";
        Assert.assertEquals((Object)mapping, (Object)ColumnEncoding.stripCode((String)(mapping + "#" + ColumnEncoding.BINARY.getCode())));
    }

    @Test
    public void testMapEncoding() {
        Assert.assertFalse((boolean)ColumnEncoding.isMapEncoding((String)"s"));
        Assert.assertFalse((boolean)ColumnEncoding.isMapEncoding((String)"string"));
        Assert.assertFalse((boolean)ColumnEncoding.isMapEncoding((String)"binary"));
        Assert.assertTrue((boolean)ColumnEncoding.isMapEncoding((String)"s:s"));
        Assert.assertTrue((boolean)ColumnEncoding.isMapEncoding((String)"s:string"));
        Assert.assertTrue((boolean)ColumnEncoding.isMapEncoding((String)"string:s"));
        Assert.assertTrue((boolean)ColumnEncoding.isMapEncoding((String)"string:string"));
    }

    @Test
    public void testMapEncodingParsing() {
        Map.Entry stringString = Maps.immutableEntry((Object)ColumnEncoding.STRING, (Object)ColumnEncoding.STRING);
        Map.Entry stringBinary = Maps.immutableEntry((Object)ColumnEncoding.STRING, (Object)ColumnEncoding.BINARY);
        Map.Entry binaryBinary = Maps.immutableEntry((Object)ColumnEncoding.BINARY, (Object)ColumnEncoding.BINARY);
        Map.Entry binaryString = Maps.immutableEntry((Object)ColumnEncoding.BINARY, (Object)ColumnEncoding.STRING);
        Assert.assertEquals((Object)stringString, (Object)ColumnEncoding.getMapEncoding((String)"s:s"));
        Assert.assertEquals((Object)stringString, (Object)ColumnEncoding.getMapEncoding((String)"s:string"));
        Assert.assertEquals((Object)stringString, (Object)ColumnEncoding.getMapEncoding((String)"string:s"));
        Assert.assertEquals((Object)stringString, (Object)ColumnEncoding.getMapEncoding((String)"string:string"));
        Assert.assertEquals((Object)stringBinary, (Object)ColumnEncoding.getMapEncoding((String)"s:b"));
        Assert.assertEquals((Object)stringBinary, (Object)ColumnEncoding.getMapEncoding((String)"string:b"));
        Assert.assertEquals((Object)stringBinary, (Object)ColumnEncoding.getMapEncoding((String)"s:binary"));
        Assert.assertEquals((Object)stringBinary, (Object)ColumnEncoding.getMapEncoding((String)"string:binary"));
        Assert.assertEquals((Object)binaryString, (Object)ColumnEncoding.getMapEncoding((String)"b:s"));
        Assert.assertEquals((Object)binaryString, (Object)ColumnEncoding.getMapEncoding((String)"b:string"));
        Assert.assertEquals((Object)binaryString, (Object)ColumnEncoding.getMapEncoding((String)"binary:s"));
        Assert.assertEquals((Object)binaryString, (Object)ColumnEncoding.getMapEncoding((String)"binary:string"));
        Assert.assertEquals((Object)binaryBinary, (Object)ColumnEncoding.getMapEncoding((String)"b:b"));
        Assert.assertEquals((Object)binaryBinary, (Object)ColumnEncoding.getMapEncoding((String)"binary:b"));
        Assert.assertEquals((Object)binaryBinary, (Object)ColumnEncoding.getMapEncoding((String)"b:binary"));
        Assert.assertEquals((Object)binaryBinary, (Object)ColumnEncoding.getMapEncoding((String)"binary:binary"));
    }
}

