/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowSerializer;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAccumuloRowSerializer {
    @Test
    public void testBufferResetBeforeUse() throws IOException {
        ByteStream.Output output = new ByteStream.Output();
        PrimitiveObjectInspector fieldObjectInspector = (PrimitiveObjectInspector)Mockito.mock(StringObjectInspector.class);
        ColumnMapping mapping = (ColumnMapping)Mockito.mock(ColumnMapping.class);
        output.write("foobar".getBytes());
        AccumuloRowSerializer serializer = (AccumuloRowSerializer)Mockito.mock(AccumuloRowSerializer.class);
        String object = "hello";
        Mockito.when((Object)serializer.getSerializedValue((ObjectInspector)Mockito.any(ObjectInspector.class), Mockito.any(), (ByteStream.Output)Mockito.any(ByteStream.Output.class), (ColumnMapping)Mockito.any(ColumnMapping.class))).thenCallRealMethod();
        Mockito.when((Object)fieldObjectInspector.getCategory()).thenReturn((Object)ObjectInspector.Category.PRIMITIVE);
        Mockito.when((Object)fieldObjectInspector.getPrimitiveCategory()).thenReturn((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
        Mockito.when((Object)fieldObjectInspector.getPrimitiveWritableObject(Mockito.any(Object.class))).thenReturn((Object)new Text(object));
        Mockito.when((Object)mapping.getEncoding()).thenReturn((Object)ColumnEncoding.STRING);
        serializer.getSerializedValue((ObjectInspector)fieldObjectInspector, (Object)object, output, mapping);
        Assert.assertEquals((long)0L, (long)output.size());
    }

    @Test
    public void testBinarySerialization() throws IOException, SerDeException {
        List<String> columns = Arrays.asList("row", "cq1", "cq2", "cq3");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.stringTypeInfo);
        ArrayList<String> typeNames = new ArrayList<String>(types.size());
        for (TypeInfo type : types) {
            typeNames.add(type.getTypeName());
        }
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowid,cf:cq1#b,cf:cq2#b,cf:cq3");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(columns));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(typeNames));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        LazySimpleStructObjectInspector oi = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(columns, types, (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), new ColumnVisibility(), accumuloSerDeParams.getRowIdFactory());
        LazyStruct obj = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)oi);
        ByteArrayRef byteRef = new ByteArrayRef();
        byteRef.setData(new byte[]{114, 111, 119, 49, 32, 49, 48, 32, 50, 48, 32, 118, 97, 108, 117, 101});
        obj.init(byteRef, 0, byteRef.getData().length);
        Mutation m = serializer.serialize((Object)obj, (ObjectInspector)oi);
        Assert.assertArrayEquals((byte[])"row1".getBytes(), (byte[])m.getRow());
        List updates = m.getUpdates();
        Assert.assertEquals((long)3L, (long)updates.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ColumnUpdate update = (ColumnUpdate)updates.get(0);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq1", (Object)new String(update.getColumnQualifier()));
        out.writeInt(10);
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])update.getValue());
        update = (ColumnUpdate)updates.get(1);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq2", (Object)new String(update.getColumnQualifier()));
        baos.reset();
        out.writeInt(20);
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])update.getValue());
        update = (ColumnUpdate)updates.get(2);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq3", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"value", (Object)new String(update.getValue()));
    }

    @Test
    public void testVisibilityLabel() throws IOException, SerDeException {
        List<String> columns = Arrays.asList("row", "cq1", "cq2", "cq3");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.stringTypeInfo);
        ArrayList<String> typeNames = new ArrayList<String>(types.size());
        for (TypeInfo type : types) {
            typeNames.add(type.getTypeName());
        }
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowid,cf:cq1#b,cf:cq2#b,cf:cq3");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(columns));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(typeNames));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        LazySimpleStructObjectInspector oi = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(columns, types, (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), new ColumnVisibility("foo"), accumuloSerDeParams.getRowIdFactory());
        LazyStruct obj = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)oi);
        ByteArrayRef byteRef = new ByteArrayRef();
        byteRef.setData(new byte[]{114, 111, 119, 49, 32, 49, 48, 32, 50, 48, 32, 118, 97, 108, 117, 101});
        obj.init(byteRef, 0, byteRef.getData().length);
        Mutation m = serializer.serialize((Object)obj, (ObjectInspector)oi);
        Assert.assertArrayEquals((byte[])"row1".getBytes(), (byte[])m.getRow());
        List updates = m.getUpdates();
        Assert.assertEquals((long)3L, (long)updates.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        ColumnUpdate update = (ColumnUpdate)updates.get(0);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq1", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"foo", (Object)new String(update.getColumnVisibility()));
        out.writeInt(10);
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])update.getValue());
        update = (ColumnUpdate)updates.get(1);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq2", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"foo", (Object)new String(update.getColumnVisibility()));
        baos.reset();
        out.writeInt(20);
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])update.getValue());
        update = (ColumnUpdate)updates.get(2);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq3", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"foo", (Object)new String(update.getColumnVisibility()));
        Assert.assertEquals((Object)"value", (Object)new String(update.getValue()));
    }

    @Test
    public void testMapSerialization() throws IOException, SerDeException {
        List<String> columns = Arrays.asList("row", "col");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo));
        ArrayList<String> typeNames = new ArrayList<String>(types.size());
        for (TypeInfo type : types) {
            typeNames.add(type.getTypeName());
        }
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowid,cf:*");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("collection.delim", ",");
        tableProperties.setProperty("mapkey.delim", ":");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(columns));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(typeNames));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazyStringObjectInspector stringOI = (LazyStringObjectInspector)LazyFactory.createLazyObjectInspector((TypeInfo)stringTypeInfo, (byte[])new byte[]{0}, (int)0, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyMapObjectInspector mapOI = LazyObjectInspectorFactory.getLazySimpleMapObjectInspector((ObjectInspector)stringOI, (ObjectInspector)stringOI, (byte)44, (byte)58, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazySimpleStructObjectInspector structOI = LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(columns, Arrays.asList(stringOI, mapOI), (byte)32, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), new ColumnVisibility(), accumuloSerDeParams.getRowIdFactory());
        LazyStruct obj = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef byteRef = new ByteArrayRef();
        byteRef.setData("row1 cq1:10,cq2:20,cq3:value".getBytes());
        obj.init(byteRef, 0, byteRef.getData().length);
        Mutation m = serializer.serialize((Object)obj, (ObjectInspector)structOI);
        Assert.assertArrayEquals((byte[])"row1".getBytes(), (byte[])m.getRow());
        List updates = m.getUpdates();
        Assert.assertEquals((long)3L, (long)updates.size());
        ColumnUpdate update = (ColumnUpdate)updates.get(0);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq1", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"10", (Object)new String(update.getValue()));
        update = (ColumnUpdate)updates.get(1);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq2", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"20", (Object)new String(update.getValue()));
        update = (ColumnUpdate)updates.get(2);
        Assert.assertEquals((Object)"cf", (Object)new String(update.getColumnFamily()));
        Assert.assertEquals((Object)"cq3", (Object)new String(update.getColumnQualifier()));
        Assert.assertEquals((Object)"value", (Object)new String(update.getValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRowIdOffset() throws SerDeException {
        ArrayList mappings = new ArrayList();
        new AccumuloRowSerializer(-1, null, mappings, new ColumnVisibility(), null);
    }
}

