/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate.compare;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.IntCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.Like;
import org.apache.hadoop.hive.accumulo.predicate.compare.NotEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIntCompare {
    private IntCompare intCompare;

    @Before
    public void setup() {
        byte[] ibytes = new byte[4];
        ByteBuffer.wrap(ibytes).putInt(10);
        this.intCompare = new IntCompare();
        this.intCompare.init(ibytes);
    }

    public byte[] getBytes(int val) {
        byte[] intBytes = new byte[4];
        ByteBuffer.wrap(intBytes).putInt(val);
        int serializedVal = this.intCompare.serialize(intBytes);
        Assert.assertEquals((long)serializedVal, (long)val);
        return intBytes;
    }

    @Test
    public void equal() {
        Equal equalObj = new Equal((PrimitiveComparison)this.intCompare);
        byte[] val = this.getBytes(10);
        Assert.assertTrue((boolean)equalObj.accept(val));
    }

    @Test
    public void notEqual() {
        NotEqual notEqualObj = new NotEqual((PrimitiveComparison)this.intCompare);
        byte[] val = this.getBytes(11);
        Assert.assertTrue((boolean)notEqualObj.accept(val));
        val = this.getBytes(10);
        Assert.assertFalse((boolean)notEqualObj.accept(val));
    }

    @Test
    public void greaterThan() {
        GreaterThan greaterThanObj = new GreaterThan((PrimitiveComparison)this.intCompare);
        byte[] val = this.getBytes(11);
        Assert.assertTrue((boolean)greaterThanObj.accept(val));
        val = this.getBytes(4);
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
        val = this.getBytes(10);
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
    }

    @Test
    public void greaterThanOrEqual() {
        GreaterThanOrEqual greaterThanOrEqualObj = new GreaterThanOrEqual((PrimitiveComparison)this.intCompare);
        byte[] val = this.getBytes(11);
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
        val = this.getBytes(4);
        Assert.assertFalse((boolean)greaterThanOrEqualObj.accept(val));
        val = this.getBytes(10);
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
    }

    @Test
    public void lessThan() {
        LessThan lessThanObj = new LessThan((PrimitiveComparison)this.intCompare);
        byte[] val = this.getBytes(11);
        Assert.assertFalse((boolean)lessThanObj.accept(val));
        val = this.getBytes(4);
        Assert.assertTrue((boolean)lessThanObj.accept(val));
        val = this.getBytes(10);
        Assert.assertFalse((boolean)lessThanObj.accept(val));
    }

    @Test
    public void lessThanOrEqual() {
        LessThanOrEqual lessThanOrEqualObj = new LessThanOrEqual((PrimitiveComparison)this.intCompare);
        byte[] val = this.getBytes(11);
        Assert.assertFalse((boolean)lessThanOrEqualObj.accept(val));
        val = this.getBytes(4);
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
        val = this.getBytes(10);
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
    }

    @Test
    public void like() {
        try {
            Like likeObj = new Like((PrimitiveComparison)this.intCompare);
            Assert.assertTrue((boolean)likeObj.accept(new byte[0]));
            Assert.fail((String)"should not accept");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Like not supported for " + this.intCompare.getClass().getName()));
        }
    }
}

