/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import java.util.Map;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.ColumnMappingFactory;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.InvalidColumnMappingException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnMappingFactory {
    @Test(expected=NullPointerException.class)
    public void testNullArgumentsFailFast() {
        ColumnMappingFactory.get(null, null, null, null);
    }

    @Test
    public void testRowIdCreatesRowIdMapping() {
        ColumnMapping mapping = ColumnMappingFactory.get((String)":rowID", (ColumnEncoding)ColumnEncoding.STRING, (String)"row", (TypeInfo)TypeInfoFactory.stringTypeInfo);
        Assert.assertEquals(HiveAccumuloRowIdColumnMapping.class, mapping.getClass());
        Assert.assertEquals((Object)"row", (Object)mapping.getColumnName());
        Assert.assertEquals((Object)TypeInfoFactory.stringTypeInfo.toString(), (Object)mapping.getColumnType());
    }

    @Test
    public void testColumnMappingCreatesAccumuloColumnMapping() {
        ColumnMapping mapping = ColumnMappingFactory.get((String)"cf:cq", (ColumnEncoding)ColumnEncoding.STRING, (String)"col", (TypeInfo)TypeInfoFactory.stringTypeInfo);
        Assert.assertEquals(HiveAccumuloColumnMapping.class, mapping.getClass());
        Assert.assertEquals((Object)"col", (Object)mapping.getColumnName());
        Assert.assertEquals((Object)TypeInfoFactory.stringTypeInfo.toString(), (Object)mapping.getColumnType());
    }

    @Test(expected=InvalidColumnMappingException.class)
    public void testColumnMappingRequiresCfAndCq() {
        ColumnMappingFactory.parseMapping((String)"cf");
    }

    @Test
    public void testColumnMappingWithMultipleColons() {
        String cf = "cf";
        String cq = "cq1:cq2";
        Map.Entry pair = ColumnMappingFactory.parseMapping((String)(cf + ":" + cq));
        Assert.assertEquals((Object)cf, pair.getKey());
        Assert.assertEquals((Object)cq, pair.getValue());
    }

    @Test
    public void testEscapedColumnFamily() {
        String cf = "c\\:f";
        String cq = "cq1:cq2";
        Map.Entry pair = ColumnMappingFactory.parseMapping((String)(cf + ":" + cq));
        Assert.assertEquals((Object)"c:f", pair.getKey());
        Assert.assertEquals((Object)cq, pair.getValue());
    }

    @Test
    public void testEscapedColumnFamilyAndQualifier() {
        String cf = "c\\:f";
        String cq = "cq1\\:cq2";
        Map.Entry pair = ColumnMappingFactory.parseMapping((String)(cf + ":" + cq));
        Assert.assertEquals((Object)"c:f", pair.getKey());
        Assert.assertEquals((Object)"cq1:cq2", pair.getValue());
    }

    @Test
    public void testGetMap() {
        String mappingStr = "cf:*";
        ColumnMapping mapping = ColumnMappingFactory.get((String)mappingStr, (ColumnEncoding)ColumnEncoding.getDefault(), (String)"col", (TypeInfo)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo));
        Assert.assertEquals(HiveAccumuloMapColumnMapping.class, mapping.getClass());
        HiveAccumuloMapColumnMapping mapMapping = (HiveAccumuloMapColumnMapping)mapping;
        Assert.assertEquals((Object)"cf", (Object)mapMapping.getColumnFamily());
        Assert.assertEquals((Object)"", (Object)mapMapping.getColumnQualifierPrefix());
        Assert.assertEquals((Object)ColumnEncoding.getDefault(), (Object)mapMapping.getKeyEncoding());
        Assert.assertEquals((Object)ColumnEncoding.getDefault(), (Object)mapMapping.getValueEncoding());
    }

    @Test
    public void testGetMapWithPrefix() {
        String mappingStr = "cf:foo*";
        ColumnMapping mapping = ColumnMappingFactory.get((String)mappingStr, (ColumnEncoding)ColumnEncoding.getDefault(), (String)"col", (TypeInfo)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo));
        Assert.assertEquals(HiveAccumuloMapColumnMapping.class, mapping.getClass());
        HiveAccumuloMapColumnMapping mapMapping = (HiveAccumuloMapColumnMapping)mapping;
        Assert.assertEquals((Object)"cf", (Object)mapMapping.getColumnFamily());
        Assert.assertEquals((Object)"foo", (Object)mapMapping.getColumnQualifierPrefix());
        Assert.assertEquals((Object)ColumnEncoding.getDefault(), (Object)mapMapping.getKeyEncoding());
        Assert.assertEquals((Object)ColumnEncoding.getDefault(), (Object)mapMapping.getValueEncoding());
    }

    @Test
    public void testEscapedAsterisk() {
        String mappingStr = "cf:\\*";
        ColumnMapping mapping = ColumnMappingFactory.get((String)mappingStr, (ColumnEncoding)ColumnEncoding.getDefault(), (String)"col", (TypeInfo)TypeInfoFactory.stringTypeInfo);
        Assert.assertEquals(HiveAccumuloColumnMapping.class, mapping.getClass());
        HiveAccumuloColumnMapping colMapping = (HiveAccumuloColumnMapping)mapping;
        Assert.assertEquals((Object)"cf", (Object)colMapping.getColumnFamily());
        Assert.assertEquals((Object)"*", (Object)colMapping.getColumnQualifier());
        Assert.assertEquals((Object)ColumnEncoding.getDefault(), (Object)colMapping.getEncoding());
    }

    @Test
    public void testPrefixWithEscape() {
        String mappingStr = "cf:foo\\*bar*";
        ColumnMapping mapping = ColumnMappingFactory.get((String)mappingStr, (ColumnEncoding)ColumnEncoding.getDefault(), (String)"col", (TypeInfo)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo));
        Assert.assertEquals(HiveAccumuloMapColumnMapping.class, mapping.getClass());
        HiveAccumuloMapColumnMapping mapMapping = (HiveAccumuloMapColumnMapping)mapping;
        Assert.assertEquals((Object)"cf", (Object)mapMapping.getColumnFamily());
        Assert.assertEquals((Object)"foo*bar", (Object)mapMapping.getColumnQualifierPrefix());
        Assert.assertEquals((Object)ColumnEncoding.getDefault(), (Object)mapMapping.getKeyEncoding());
        Assert.assertEquals((Object)ColumnEncoding.getDefault(), (Object)mapMapping.getValueEncoding());
    }

    @Test
    public void testInlineEncodingOverridesDefault() {
        String mappingStr = "cf:foo#s";
        ColumnMapping mapping = ColumnMappingFactory.get((String)mappingStr, (ColumnEncoding)ColumnEncoding.BINARY, (String)"col", (TypeInfo)TypeInfoFactory.stringTypeInfo);
        Assert.assertEquals(HiveAccumuloColumnMapping.class, mapping.getClass());
        HiveAccumuloColumnMapping colMapping = (HiveAccumuloColumnMapping)mapping;
        Assert.assertEquals((Object)"cf", (Object)colMapping.getColumnFamily());
        Assert.assertEquals((Object)"foo", (Object)colMapping.getColumnQualifier());
        Assert.assertEquals((Object)ColumnEncoding.STRING, (Object)colMapping.getEncoding());
    }

    @Test
    public void testCaseInsensitiveRowId() {
        String mappingStr = ":rowid";
        ColumnMapping mapping = ColumnMappingFactory.get((String)mappingStr, (ColumnEncoding)ColumnEncoding.getDefault(), (String)"col", (TypeInfo)TypeInfoFactory.stringTypeInfo);
        Assert.assertEquals(HiveAccumuloRowIdColumnMapping.class, mapping.getClass());
        mappingStr = ":rowid#b";
        mapping = ColumnMappingFactory.get((String)mappingStr, (ColumnEncoding)ColumnEncoding.getDefault(), (String)"col", (TypeInfo)TypeInfoFactory.stringTypeInfo);
        Assert.assertEquals(HiveAccumuloRowIdColumnMapping.class, mapping.getClass());
    }
}

