/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAccumuloConnectionParameters {
    @Test
    public void testInstantiatesWithNullConfiguration() {
        AccumuloConnectionParameters cnxnParams = new AccumuloConnectionParameters(null);
        try {
            cnxnParams.getAccumuloInstanceName();
            Assert.fail((String)"Should have gotten an NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingInstanceName() {
        Configuration conf = new Configuration(false);
        conf.set("accumulo.zookeepers", "localhost:2181");
        conf.set("accumulo.user.name", "user");
        conf.set("accumulo.user.pass", "password");
        AccumuloConnectionParameters cnxnParams = new AccumuloConnectionParameters(conf);
        cnxnParams.getInstance();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingZooKeepers() {
        Configuration conf = new Configuration(false);
        conf.set("accumulo.instance.name", "accumulo");
        conf.set("accumulo.user.name", "user");
        conf.set("accumulo.user.pass", "password");
        AccumuloConnectionParameters cnxnParams = new AccumuloConnectionParameters(conf);
        cnxnParams.getInstance();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingUserName() throws AccumuloException, AccumuloSecurityException {
        Configuration conf = new Configuration(false);
        conf.set("accumulo.instance.name", "accumulo");
        conf.set("accumulo.zookeepers", "localhost:2181");
        conf.set("accumulo.user.pass", "password");
        Instance instance = (Instance)Mockito.mock(Instance.class);
        AccumuloConnectionParameters cnxnParams = new AccumuloConnectionParameters(conf);
        cnxnParams.getConnector(instance);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingPassword() throws AccumuloException, AccumuloSecurityException {
        Configuration conf = new Configuration(false);
        conf.set("accumulo.instance.name", "accumulo");
        conf.set("accumulo.zookeepers", "localhost:2181");
        conf.set("accumulo.user.name", "user");
        Instance instance = (Instance)Mockito.mock(Instance.class);
        AccumuloConnectionParameters cnxnParams = new AccumuloConnectionParameters(conf);
        cnxnParams.getConnector(instance);
    }

    public void testSasl() {
        Configuration conf = new Configuration(false);
        AccumuloConnectionParameters cnxnParams = new AccumuloConnectionParameters(conf);
        Assert.assertFalse((boolean)cnxnParams.useSasl());
        conf.set("accumulo.sasl.enabled", "true");
        cnxnParams = new AccumuloConnectionParameters(conf);
        Assert.assertTrue((boolean)cnxnParams.useSasl());
        conf.set("accumulo.sasl.enabled", "false");
        Assert.assertFalse((boolean)cnxnParams.useSasl());
    }
}

