/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.encryptiontool;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EncryptionTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)EncryptionTool.class.getName());
    private static final String EMPTY = "";

    private EncryptionTool() {
    }

    @VisibleForTesting
    static void encryptPassword(String propertyName, String propertyValue, String pathToKeyStore, boolean isLocalFs) throws IOException {
        CredentialProvider provider = EncryptionTool.getCredentialProvider(pathToKeyStore, isLocalFs);
        LOG.debug("Creating alias " + propertyName + " under " + pathToKeyStore);
        provider.createCredentialEntry(propertyName, propertyValue.toCharArray());
        provider.flush();
    }

    @VisibleForTesting
    static void deleteIfExists(String propertyName, String pathToKeyStore, boolean isLocalFs) throws IOException {
        CredentialProvider provider = EncryptionTool.getCredentialProvider(pathToKeyStore, isLocalFs);
        if (provider.getCredentialEntry(propertyName) != null) {
            LOG.debug(String.format("Alias %s already exists at %s. Deleting it.", propertyName, pathToKeyStore));
            provider.deleteCredentialEntry(propertyName);
            provider.flush();
        }
    }

    @VisibleForTesting
    static boolean aliasExists(String propertyName, String pathToKeyStore, boolean isLocalFs) throws IOException {
        CredentialProvider provider = EncryptionTool.getCredentialProvider(pathToKeyStore, isLocalFs);
        return provider.getCredentialEntry(propertyName) != null;
    }

    @VisibleForTesting
    static String getProperty(String propertyName, String pathToKeyStore, boolean isLocalFs) throws IOException {
        CredentialProvider provider = EncryptionTool.getCredentialProvider(pathToKeyStore, isLocalFs);
        CredentialProvider.CredentialEntry credentialEntry = provider.getCredentialEntry(propertyName);
        if (credentialEntry != null) {
            LOG.debug(String.format("Retrieving property value with alias %s under %s", propertyName, pathToKeyStore));
            return new String(credentialEntry.getCredential());
        }
        LOG.debug(String.format("Property with alias %s does not exist under %s", propertyName, pathToKeyStore));
        return EMPTY;
    }

    private static CredentialProvider getCredentialProvider(String pathToKeyStore, boolean isLocalFs) throws IOException {
        return (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)EncryptionTool.createConfiguration(pathToKeyStore, isLocalFs)).get(0);
    }

    private static Configuration createConfiguration(String pathToKeyStore, boolean isLocalFs) {
        String keyStorePath;
        Configuration configuration = new Configuration();
        if (isLocalFs) {
            configuration.set("fs.default.name", "file:///");
            keyStorePath = "jceks://file/" + pathToKeyStore;
        } else {
            keyStorePath = "jceks://maprfs/" + pathToKeyStore;
        }
        configuration.set("hadoop.security.credential.clear-text-fallback", "true");
        configuration.set("hadoop.security.credential.provider.path", keyStorePath);
        return configuration;
    }
}

