/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.conftool;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hive.conftool.ConfTool;
import org.apache.hive.conftool.ConfToolParseException;
import org.apache.hive.conftool.ConfToolParseUtil;
import org.apache.hive.conftool.ConfToolUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class PropertyProcessor {
    private static final Options CMD_LINE_OPTIONS = new Options();
    private static final HelpFormatter HELP_FORMATTER = new HelpFormatter();
    private static final String HELP = "help";
    private static final String PATH = "path";
    private static final String TOOL_NAME = "conftool";
    private static final String EXIST_PROPERTY = "existProperty";
    private static final String ADD_PROPERTY = "addProperty";
    private static final String DEL_PROPERTY = "delProperty";

    private PropertyProcessor() {
    }

    public static void processArgs(String[] args) {
        GnuParser cmdParser = new GnuParser();
        if (PropertyProcessor.isValid((CommandLineParser)cmdParser, args)) {
            try {
                CommandLine line = cmdParser.parse(CMD_LINE_OPTIONS, args);
                if (PropertyProcessor.hasPath(line)) {
                    String pathToXmlFile = line.getOptionValue(PATH);
                    Document xmlFile = ConfToolParseUtil.readDocument(pathToXmlFile);
                    PropertyProcessor.processPropertyCmd(xmlFile, cmdParser.parse(CMD_LINE_OPTIONS, args));
                    ConfToolParseUtil.saveToFile(xmlFile, pathToXmlFile);
                } else {
                    PropertyProcessor.printHelp();
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | ParseException | SAXException e) {
                throw new ConfToolParseException("conftool: Parsing failed.  Reason: " + e.getLocalizedMessage());
            }
        }
    }

    public static boolean requiresArgProcessing(String[] args) {
        GnuParser cmdParser = new GnuParser();
        if (PropertyProcessor.isValid((CommandLineParser)cmdParser, args)) {
            try {
                CommandLine line = cmdParser.parse(CMD_LINE_OPTIONS, args);
                return PropertyProcessor.isExistVerification(line) || PropertyProcessor.isDelProperty(line) || PropertyProcessor.isAddProperty(line) || PropertyProcessor.isHelp(line);
            }
            catch (ParseException e) {
                throw new ConfToolParseException("conftool: Parsing failed.  Reason: " + e.getLocalizedMessage());
            }
        }
        return false;
    }

    private static boolean isValid(CommandLineParser cmdParser, String[] args) {
        CommandLine line;
        try {
            line = cmdParser.parse(CMD_LINE_OPTIONS, args);
        }
        catch (ParseException e) {
            PropertyProcessor.printHelp();
            throw new ConfToolParseException("conftool: Parsing failed.  Reason: " + e.getLocalizedMessage());
        }
        if (line == null) {
            throw new ConfToolParseException("conftool: parsing failed.  Reason: unknown");
        }
        if (PropertyProcessor.isHelp(line)) {
            PropertyProcessor.printHelp();
        }
        return true;
    }

    private static void processPropertyCmd(Document hiveSite, CommandLine line) {
        String[] optionValues;
        String property;
        if (PropertyProcessor.isExistVerification(line)) {
            if (PropertyProcessor.hasValidExistPropertyOptions(line)) {
                property = line.getOptionValue(EXIST_PROPERTY);
                ConfToolUtil.printBool(ConfTool.propertyExists(hiveSite, property));
            } else {
                PropertyProcessor.printHelp();
                throw new ConfToolParseException("Incorrect property verification options");
            }
        }
        if (PropertyProcessor.isDelProperty(line)) {
            property = line.getOptionValue(DEL_PROPERTY);
            ConfTool.delProperty(hiveSite, property);
        }
        if (PropertyProcessor.isAddProperty(line) && (optionValues = line.getOptionValues(ADD_PROPERTY)).length == 2) {
            String property2 = optionValues[0];
            String value = optionValues[1];
            ConfTool.addProperty(hiveSite, property2, value);
        }
    }

    private static boolean isExistVerification(CommandLine line) {
        return line.hasOption(EXIST_PROPERTY);
    }

    private static boolean hasPath(CommandLine line) {
        return line.hasOption(PATH);
    }

    private static boolean hasValidExistPropertyOptions(CommandLine line) {
        return line.hasOption(EXIST_PROPERTY) && line.getOptionValue(EXIST_PROPERTY) != null && !line.getOptionValue(EXIST_PROPERTY).isEmpty();
    }

    private static boolean isDelProperty(CommandLine line) {
        return line.hasOption(DEL_PROPERTY);
    }

    private static boolean isAddProperty(CommandLine line) {
        return line.hasOption(ADD_PROPERTY);
    }

    private static boolean isHelp(CommandLine line) {
        return line.hasOption(HELP);
    }

    private static void printHelp() {
        HELP_FORMATTER.printHelp(TOOL_NAME, CMD_LINE_OPTIONS);
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Print help information");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HELP));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path to xml file");
        OptionBuilder.withDescription((String)"Path to xml file to configure (hive-site.xml, webhcat-site.xml etc).");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)PATH));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property to check");
        OptionBuilder.withDescription((String)"Checks if property is set in xml file.");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)EXIST_PROPERTY));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withDescription((String)"Key, value of property that should be written to xml file. In case it already exists, it is replaced with new value. Property is added like: \n<property>\n  <name>property-name<\\name>\n  <value>property-value<\\value>\n<\\property>");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)ADD_PROPERTY));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property-name");
        OptionBuilder.withDescription((String)"Removes property from xml file");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)DEL_PROPERTY));
    }
}

