// Autogenerated Jamon implementation
// /root/builds-zelda-goose/label/10.10.1.77/maprFsVersion/3.0.2/maprHbaseVersion/1.0.3-mapr-3.0.2/privateHbaseVersion/0.94.13-mapr-1401-m7-3.0.2/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RSStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 26, 1
import java.util.*;
// 27, 1
import java.io.IOException;
// 28, 1
import org.apache.hadoop.io.Text;
// 29, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 30, 1
import org.apache.hadoop.hbase.regionserver.HRegion;
// 31, 1
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
// 32, 1
import org.apache.hadoop.hbase.util.Bytes;
// 33, 1
import org.apache.hadoop.hbase.util.Pair;
// 34, 1
import org.apache.hadoop.hbase.HConstants;
// 35, 1
import org.apache.hadoop.hbase.HServerInfo;
// 36, 1
import org.apache.hadoop.hbase.HServerLoad;
// 37, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 38, 1
import org.apache.hadoop.hbase.ServerName;
// 39, 1
import org.apache.hadoop.hbase.HBaseConfiguration;

public class RSStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.Intf

{
  private final HRegionServer regionServer;
  private final String format;
  private final String filter;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    return p_implData;
  }
  public RSStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    format = p_implData.getFormat();
    filter = p_implData.getFilter();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 41, 1
    if (format.equals("json") )
    {
      // 41, 30
      jamonWriter.write("\n  ");
      // 42, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_4.setFilter(filter);
        __jamon__var_4.setFormat("json" );
        __jamon__var_4.renderNoFlush(jamonWriter);
      }
      // 42, 68
      jamonWriter.write("\n  ");
      // 43, 3
      return; 
    }
    // 44, 7
    jamonWriter.write("\n");
    // 45, 1
    
  HServerInfo serverInfo = null;
  ServerName serverName = null;
  try {
    serverInfo = regionServer.getHServerInfo();
    serverName = regionServer.getServerName();
  } catch (IOException e) {
    e.printStackTrace();
  }
  List<Pair<String, String>> metricsList = regionServer.getMetrics().getList();
  List<HRegionInfo> onlineRegions = regionServer.getOnlineRegions();
  int interval = regionServer.getConfiguration().getInt("hbase.regionserver.msginterval", 3000)/1000;
  int masterInfoPort = regionServer.getConfiguration().getInt("hbase.master.info.port", 60010);

    // 59, 1
    jamonWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!-- Commenting out DOCTYPE so our blue outline shows on hadoop 0.20.205.0, etc.\n     See tail of HBASE-2110 for explaination.\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \n-->\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n<title>HBase Region Server: ");
    // 67, 29
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 67, 45
    jamonWriter.write(":");
    // 67, 46
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverInfo.getServerAddress().getPort()), jamonWriter);
    // 67, 91
    jamonWriter.write("</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hbase.css\" />\n</head>\n\n<body>\n<a id=\"logo\" href=\"http://wiki.apache.org/lucene-hadoop/Hbase\"><img src=\"/static/hbase_logo.png\" alt=\"HBase Logo\" title=\"HBase Logo\" /></a>\n<h1 id=\"page_title\">RegionServer: ");
    // 73, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 73, 51
    jamonWriter.write("</h1>\n<p id=\"links_menu\">\n  <a href=\"/logs/\">Local logs</a>,\n  <a href=\"/stacks\">Thread Dump</a>,\n  <a href=\"/logLevel\">Log Level</a>,\n  <a href=\"/dump\">Debug dump</a>,\n");
    // 79, 1
    if (HBaseConfiguration.isShowConfInServlet() )
    {
      // 79, 49
      jamonWriter.write("\n  <a href=\"/conf\">HBase Configuration</a>\n");
    }
    // 81, 7
    jamonWriter.write("\n</p>\n<hr id=\"head_rule\" />\n\n<h2>Attributes</h2>\n<table id=\"attributes_table\">\n<col style=\"width: 10%;\"/>\n<col />\n<col style=\"width: 20%;\"/>\n<tr><th>Attribute Name</th><th>Value</th><th>Description</th></tr>\n<tr><td>HBase Version</td><td>");
    // 91, 31
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 91, 90
    jamonWriter.write(", r");
    // 91, 93
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 91, 153
    jamonWriter.write("</td><td>HBase version and revision</td></tr>\n<tr><td>HBase Compiled</td><td>");
    // 92, 32
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 92, 88
    jamonWriter.write(", ");
    // 92, 90
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 92, 146
    jamonWriter.write("</td><td>When HBase version was compiled and by whom</td></tr>\n<tr><td>Metrics</td><td style=\"border:0px; padding:0px;\">\n<table id=\"metrics_table\" style=\"width:100%;border:0;border-collapse:collapse;\">\n");
    // 95, 1
    int metricIndex = 0;
    // 96, 1
    while (metricIndex < metricsList.size() )
    {
      // 96, 44
      jamonWriter.write("\n<tr>");
      // 97, 5
      for (int i = 0; i < 4 && metricIndex < metricsList.size(); i++, metricIndex++ )
      {
        // 97, 86
        jamonWriter.write("\n  <td>");
        // 98, 7
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(metricsList.get(metricIndex).getFirst()), jamonWriter);
        // 98, 52
        jamonWriter.write(" = ");
        // 98, 55
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(metricsList.get(metricIndex).getSecond()), jamonWriter);
        // 98, 101
        jamonWriter.write("</td>");
      }
      // 98, 113
      jamonWriter.write("\n</tr>\n");
    }
    // 100, 10
    jamonWriter.write("\n</table>\n</td><td>RegionServer Metrics; file and heap sizes are in megabytes</td></tr>\n<tr><td>Zookeeper Quorum</td><td>");
    // 103, 34
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(regionServer.getZooKeeper().getQuorum()), jamonWriter);
    // 103, 79
    jamonWriter.write("</td><td>Addresses of all registered ZK servers</td></tr>\n<tr>\n  <td>Coprocessors</td>\n  <td>\n    ");
    // 107, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(regionServer.getCoprocessors())), jamonWriter);
    // 107, 68
    jamonWriter.write("\n  </td>\n  <td>Coprocessors currently loaded by this regionserver</td></tr>\n<tr><td>RS Start Time</td><td>");
    // 110, 31
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(regionServer.getStartcode())), jamonWriter);
    // 110, 74
    jamonWriter.write("</td><td>Date stamp of when this region server was started</td></tr>\n</tr>\n<tr><td>HBase Master</td><td>\n");
    // 113, 1
    if ((masterInfoPort < 0) )
    {
      // 113, 29
      jamonWriter.write("\nNo hbase.master.info.port found\n");
    }
    // 115, 1
    else
    {
      // 115, 8
      jamonWriter.write("\n");
      // 116, 1
      
String host = regionServer.getMasterAddressManager().getMasterAddress().getHostname() + ":" + masterInfoPort;
String url = "//" + host + "/";

      // 120, 1
      jamonWriter.write("<a href=\"");
      // 120, 10
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 120, 19
      jamonWriter.write("\">");
      // 120, 21
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(host), jamonWriter);
      // 120, 31
      jamonWriter.write("</a>\n");
    }
    // 121, 7
    jamonWriter.write("\n</td><td>Address of HBase Master</td></tr>\n</table>\n\n");
    // 125, 1
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_5.setFilter(filter );
      __jamon__var_5.renderNoFlush(jamonWriter);
    }
    // 125, 49
    jamonWriter.write("\n\n<h2>Regions</h2>\n");
    // 128, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 128, 60
      jamonWriter.write("\n<table>\n<tr><th>Region Name</th><th>Start Key</th><th>End Key</th><th>Metrics</th></tr>\n");
      // 131, 1
         
  Collections.sort(onlineRegions);

      // 134, 1
      for (HRegionInfo r: onlineRegions )
      {
        // 134, 38
        jamonWriter.write("\n");
        // 135, 1
         
        HServerLoad.RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());

        // 138, 1
        jamonWriter.write("<tr><td>");
        // 138, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
        // 138, 40
        jamonWriter.write("</td>\n    <td>");
        // 139, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getStartKey())), jamonWriter);
        // 139, 52
        jamonWriter.write("</td><td>");
        // 139, 61
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getEndKey())), jamonWriter);
        // 139, 102
        jamonWriter.write("</td>\n    <td>");
        // 140, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load == null? "null": load.toString()), jamonWriter);
        // 140, 52
        jamonWriter.write("</td>\n    </tr>\n");
      }
      // 142, 8
      jamonWriter.write("\n</table>\n<p>Region names are made of the containing table's name, a comma,\nthe start key, a comma, and a randomly generated region id.  To illustrate,\nthe region named\n<em>domains,apache.org,5464829424211263407</em> is party to the table \n<em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\nin the region is <em>apache.org</em>.  The <em>-ROOT-</em>\nand <em>.META.</em> 'tables' are internal sytem tables (or 'catalog' tables in db-speak).\nThe -ROOT- keeps a list of all regions in the .META. table.  The .META. table\nkeeps a list of all regions in the system. The empty key is used to denote\ntable start and table end.  A region with an empty start key is the first region in a table.\nIf region has both an empty start and an empty end key, its the only region in the table.  See\n<a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 156, 1
    else
    {
      // 156, 8
      jamonWriter.write("\n<p>Not serving regions</p>\n");
    }
    // 158, 7
    jamonWriter.write("\n</body>\n</html>\n");
  }
  
  
}
