/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.thrift.ErrorThrowingGetObserver;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.ThriftServer;
import org.apache.hadoop.hbase.thrift2.ThriftUtilities;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TColumn;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TCompareOp;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TDeleteType;
import org.apache.hadoop.hbase.thrift2.generated.TDurability;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TMutation;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.thrift2.generated.TTimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestThriftHBaseServiceHandler {
    private static final Log LOG = LogFactory.getLog(TestThriftHBaseServiceHandler.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] tableAname = Bytes.toBytes((String)"tableA");
    private static byte[] familyAname = Bytes.toBytes((String)"familyA");
    private static byte[] familyBname = Bytes.toBytes((String)"familyB");
    private static byte[] qualifierAname = Bytes.toBytes((String)"qualifierA");
    private static byte[] qualifierBname = Bytes.toBytes((String)"qualifierB");
    private static byte[] valueAname = Bytes.toBytes((String)"valueA");
    private static byte[] valueBname = Bytes.toBytes((String)"valueB");
    private static HColumnDescriptor[] families = new HColumnDescriptor[]{new HColumnDescriptor(familyAname).setMaxVersions(3), new HColumnDescriptor(familyBname).setMaxVersions(2)};
    private static final MetricsAssertHelper metricsHelper = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    public void assertTColumnValuesEqual(List<TColumnValue> columnValuesA, List<TColumnValue> columnValuesB) {
        Assert.assertEquals((long)columnValuesA.size(), (long)columnValuesB.size());
        Comparator<TColumnValue> comparator = new Comparator<TColumnValue>(){

            @Override
            public int compare(TColumnValue o1, TColumnValue o2) {
                return Bytes.compareTo((byte[])Bytes.add((byte[])o1.getFamily(), (byte[])o1.getQualifier()), (byte[])Bytes.add((byte[])o2.getFamily(), (byte[])o2.getQualifier()));
            }
        };
        Collections.sort(columnValuesA, comparator);
        Collections.sort(columnValuesB, comparator);
        for (int i = 0; i < columnValuesA.size(); ++i) {
            TColumnValue a = columnValuesA.get(i);
            TColumnValue b = columnValuesB.get(i);
            this.assertTColumnValueEqual(a, b);
        }
    }

    public void assertTColumnValueEqual(TColumnValue a, TColumnValue b) {
        Assert.assertArrayEquals((byte[])a.getFamily(), (byte[])b.getFamily());
        Assert.assertArrayEquals((byte[])a.getQualifier(), (byte[])b.getQualifier());
        Assert.assertArrayEquals((byte[])a.getValue(), (byte[])b.getValue());
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().set("hbase.client.retries.number", "3");
        UTIL.startMiniCluster();
        HBaseAdmin admin = new HBaseAdmin(UTIL.getConfiguration());
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((byte[])tableAname));
        for (HColumnDescriptor family : families) {
            tableDescriptor.addFamily(family);
        }
        admin.createTable(tableDescriptor);
        admin.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
    }

    private ThriftHBaseServiceHandler createHandler() throws TException {
        try {
            Configuration conf = UTIL.getConfiguration();
            return new ThriftHBaseServiceHandler(conf, UserProvider.instantiate((Configuration)conf));
        }
        catch (IOException ie) {
            throw new TException((Throwable)ie);
        }
    }

    @Test
    public void testExists() throws TIOError, TException {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testExists".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.exists(table, get));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        Assert.assertTrue((boolean)handler.exists(table, get));
    }

    @Test
    public void testExistsAll() throws TIOError, TException {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName1 = "testExistsAll1".getBytes();
        byte[] rowName2 = "testExistsAll2".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TGet> gets = new ArrayList<TGet>();
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        List existsResult1 = handler.existsAll(table, gets);
        Assert.assertFalse((boolean)((Boolean)existsResult1.get(0)));
        Assert.assertFalse((boolean)((Boolean)existsResult1.get(1)));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>();
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        List existsResult2 = handler.existsAll(table, gets);
        Assert.assertTrue((boolean)((Boolean)existsResult2.get(0)));
        Assert.assertTrue((boolean)((Boolean)existsResult2.get(1)));
    }

    @Test
    public void testPutGet() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testPutGet".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        this.assertTColumnValuesEqual(columnValues, returnedColumnValues);
    }

    @Test
    public void testPutGetMultiple() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = "testPutGetMultiple1".getBytes();
        byte[] rowName2 = "testPutGetMultiple2".getBytes();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>();
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        ArrayList<TGet> gets = new ArrayList<TGet>();
        gets.add(new TGet(ByteBuffer.wrap(rowName1)));
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        List results = handler.getMultiple(table, gets);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((byte[])rowName1, (byte[])((TResult)results.get(0)).getRow());
        this.assertTColumnValuesEqual(columnValues, ((TResult)results.get(0)).getColumnValues());
        Assert.assertArrayEquals((byte[])rowName2, (byte[])((TResult)results.get(1)).getRow());
        this.assertTColumnValuesEqual(columnValues, ((TResult)results.get(1)).getColumnValues());
    }

    @Test
    public void testDeleteMultiple() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = "testDeleteMultiple1".getBytes();
        byte[] rowName2 = "testDeleteMultiple2".getBytes();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>();
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        ArrayList<TDelete> deletes = new ArrayList<TDelete>();
        deletes.add(new TDelete(ByteBuffer.wrap(rowName1)));
        deletes.add(new TDelete(ByteBuffer.wrap(rowName2)));
        List deleteResults = handler.deleteMultiple(table, deletes);
        Assert.assertEquals((long)0L, (long)deleteResults.size());
        Assert.assertFalse((boolean)handler.exists(table, new TGet(ByteBuffer.wrap(rowName1))));
        Assert.assertFalse((boolean)handler.exists(table, new TGet(ByteBuffer.wrap(rowName2))));
    }

    @Test
    public void testDelete() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testDelete".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValues.add(columnValueA);
        columnValues.add(columnValueB);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        handler.deleteSingle(table, delete);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<TColumnValue> expectedColumnValues = new ArrayList<TColumnValue>();
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testDeleteAllTimestamps() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testDeleteAllTimestamps".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(System.currentTimeMillis() - 10L);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(System.currentTimeMillis());
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_COLUMNS);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertNull((Object)result.getRow());
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
    }

    @Test
    public void testDeleteSingleTimestamp() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testDeleteSingleTimestamp".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        long timestamp1 = System.currentTimeMillis() - 10L;
        long timestamp2 = System.currentTimeMillis();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(timestamp1);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(timestamp2);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_COLUMN);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        Assert.assertEquals((long)timestamp1, (long)((TColumnValue)result.getColumnValues().get(0)).getTimestamp());
    }

    @Test
    public void testIncrement() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testIncrement".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>();
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement increment = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        handler.increment(table, increment);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        TColumnValue columnValue = (TColumnValue)result.getColumnValues().get(0);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((long)2L), (byte[])columnValue.getValue());
    }

    @Test
    public void testAppend() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testAppend".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] v1 = Bytes.toBytes((String)"42");
        byte[] v2 = Bytes.toBytes((String)"23");
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(v1)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        ArrayList<TColumnValue> appendColumns = new ArrayList<TColumnValue>();
        appendColumns.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(v2)));
        TAppend append = new TAppend(ByteBuffer.wrap(rowName), appendColumns);
        handler.append(table, append);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        TColumnValue columnValue = (TColumnValue)result.getColumnValues().get(0);
        Assert.assertArrayEquals((byte[])Bytes.add((byte[])v1, (byte[])v2), (byte[])columnValue.getValue());
    }

    @Test
    public void testCheckAndPut() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testCheckAndPut".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>();
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        Assert.assertFalse((boolean)handler.checkAndPut(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), putB));
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
        handler.put(table, putA);
        Assert.assertTrue((boolean)handler.checkAndPut(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), putB));
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<TColumnValue> expectedColumnValues = new ArrayList<TColumnValue>();
        expectedColumnValues.add(columnValueA);
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testCheckAndDelete() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testCheckAndDelete".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>();
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        handler.put(table, putB);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.checkAndDelete(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), delete));
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        this.assertTColumnValuesEqual(columnValuesB, result.getColumnValues());
        handler.put(table, putA);
        Assert.assertTrue((boolean)handler.checkAndDelete(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), delete));
        result = handler.get(table, get);
        Assert.assertFalse((boolean)result.isSetRow());
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
    }

    @Test
    public void testScan() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(("testScan" + i).getBytes()), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow("testScan".getBytes());
        scan.setStopRow("testScan\uffff".getBytes());
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])("testScan" + i).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testLongLivedScan() throws Exception {
        int numTrials = 6;
        int trialPause = 1000;
        int cleanUpInterval = 100;
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setInt("hbase.thrift.connection.max-idletime", numTrials / 2 * trialPause);
        conf.setInt("hbase.thrift.connection.cleanup-interval", cleanUpInterval);
        ThriftHBaseServiceHandler handler = new ThriftHBaseServiceHandler(conf, UserProvider.instantiate((Configuration)conf));
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i = 0; i < numTrials; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(("testScan" + i).getBytes()), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow("testScan".getBytes());
        scan.setStopRow("testScan\uffff".getBytes());
        scan.setCaching(1);
        int scanId = handler.openScanner(table, scan);
        for (int i = 0; i < numTrials; ++i) {
            List results = handler.getScannerRows(scanId, 1);
            Assert.assertArrayEquals((byte[])("testScan" + i).getBytes(), (byte[])((TResult)results.get(0)).getRow());
            Thread.sleep(trialPause);
        }
    }

    @Test
    public void testReverseScan() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(("testReverseScan" + i).getBytes()), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        scan.setReversed(true);
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow("testReverseScan\uffff".getBytes());
        scan.setStopRow("testReverseScan".getBytes());
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])("testReverseScan" + (9 - i)).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testScanWithFilter() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(("testScanWithFilter" + i).getBytes()), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow("testScanWithFilter".getBytes());
        scan.setStopRow("testScanWithFilter\uffff".getBytes());
        scan.setFilterString(ByteBuffer.wrap("KeyOnlyFilter()".getBytes()));
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])("testScanWithFilter" + i).getBytes(), (byte[])((TResult)results.get(i)).getRow());
            Assert.assertEquals((long)0L, (long)((TColumnValue)((TResult)results.get(i)).getColumnValues().get(0)).getValue().length);
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testScanWithColumnFamilyTimeRange() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue familyAColumnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        TColumnValue familyBColumnValue = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        long minTimestamp = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            familyAColumnValue.setTimestamp(minTimestamp + (long)i);
            familyBColumnValue.setTimestamp(minTimestamp + (long)i);
            ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
            columnValues.add(familyAColumnValue);
            columnValues.add(familyBColumnValue);
            TPut put = new TPut(ByteBuffer.wrap(("testScanWithColumnFamilyTimeRange" + i).getBytes()), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        HashMap<ByteBuffer, TTimeRange> colFamTimeRangeMap = new HashMap<ByteBuffer, TTimeRange>(2);
        colFamTimeRangeMap.put(ByteBuffer.wrap(familyAname), new TTimeRange(minTimestamp + 3L, minTimestamp + 5L));
        colFamTimeRangeMap.put(ByteBuffer.wrap(familyBname), new TTimeRange(minTimestamp + 6L, minTimestamp + 9L));
        scan.setColFamTimeRangeMap(colFamTimeRangeMap);
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 5);
        Assert.assertEquals((long)5L, (long)results.size());
        int familyACount = 0;
        int familyBCount = 0;
        for (TResult result : results) {
            List columnValues = result.getColumnValues();
            if (!CollectionUtils.isNotEmpty((Collection)columnValues)) continue;
            if (Bytes.equals((byte[])familyAname, (byte[])((TColumnValue)columnValues.get(0)).getFamily())) {
                ++familyACount;
                continue;
            }
            if (!Bytes.equals((byte[])familyBname, (byte[])((TColumnValue)columnValues.get(0)).getFamily())) continue;
            ++familyBCount;
        }
        Assert.assertEquals((long)2L, (long)familyACount);
        Assert.assertEquals((long)3L, (long)familyBCount);
        results = handler.getScannerRows(scanId, 1);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 1);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testSmallScan() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(("testSmallScan" + i).getBytes()), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        scan.setStartRow("testSmallScan".getBytes());
        scan.setStopRow("testSmallScan\uffff".getBytes());
        scan.setSmall(true);
        scan.setCaching(2);
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])("testSmallScan" + i).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testPutTTL() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testPutTTL".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        HashMap<ByteBuffer, ByteBuffer> attributes = new HashMap<ByteBuffer, ByteBuffer>();
        long ttlTimeMs = 2000L;
        attributes.put(ByteBuffer.wrap(Bytes.toBytes((String)"_ttl")), ByteBuffer.wrap(Bytes.toBytes((long)ttlTimeMs)));
        put.setAttributes(attributes);
        handler.put(table, put);
        TGet getOne = new TGet(ByteBuffer.wrap(rowName));
        TResult resultOne = handler.get(table, getOne);
        Assert.assertArrayEquals((byte[])rowName, (byte[])resultOne.getRow());
        Assert.assertEquals((long)1L, (long)resultOne.getColumnValuesSize());
        Thread.sleep(ttlTimeMs * 15L);
        TGet getTwo = new TGet(ByteBuffer.wrap(rowName));
        TResult resultTwo = handler.get(table, getTwo);
        Assert.assertNull((Object)resultTwo.getRow());
        Assert.assertEquals((long)0L, (long)resultTwo.getColumnValuesSize());
    }

    private String pad(int n, byte pad) {
        Object res = Integer.toString(n);
        while (((String)res).length() < pad) {
            res = "0" + (String)res;
        }
        return res;
    }

    @Test
    public void testScanWithBatchSize() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        for (int i = 0; i < 100; ++i) {
            String colNum = this.pad(i, (byte)3);
            TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(("col" + colNum).getBytes()), ByteBuffer.wrap(("val" + colNum).getBytes()));
            columnValues.add(columnValue);
        }
        TPut put = new TPut(ByteBuffer.wrap("testScanWithBatchSize".getBytes()), columnValues);
        handler.put(table, put);
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow("testScanWithBatchSize".getBytes());
        scan.setStopRow("testScanWithBatchSize\uffff".getBytes());
        scan.setBatchSize(10);
        int scanId = handler.openScanner(table, scan);
        List results = null;
        for (int i = 0; i < 10; ++i) {
            results = handler.getScannerRows(scanId, 1);
            Assert.assertEquals((long)1L, (long)results.size());
            List cols = ((TResult)results.get(0)).getColumnValues();
            Assert.assertEquals((long)10L, (long)cols.size());
            for (int y = 0; y < 10; ++y) {
                int colNum = y + 10 * i;
                String colNumPad = this.pad(colNum, (byte)3);
                Assert.assertArrayEquals((byte[])("col" + colNumPad).getBytes(), (byte[])((TColumnValue)cols.get(y)).getQualifier());
            }
        }
        results = handler.getScannerRows(scanId, 1);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 1);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testGetScannerResults() throws Exception {
        int i;
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i2 = 0; i2 < 20; ++i2) {
            TPut put = new TPut(ByteBuffer.wrap(("testGetScannerResults" + this.pad(i2, (byte)2)).getBytes()), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow("testGetScannerResults".getBytes());
        scan.setStopRow("testGetScannerResults05".getBytes());
        List results = handler.getScannerResults(table, scan, 5);
        Assert.assertEquals((long)5L, (long)results.size());
        for (i = 0; i < 5; ++i) {
            Assert.assertArrayEquals((byte[])("testGetScannerResults" + this.pad(i, (byte)2)).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
        scan.setStopRow("testGetScannerResults10".getBytes());
        results = handler.getScannerResults(table, scan, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])("testGetScannerResults" + this.pad(i, (byte)2)).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
        scan.setStopRow("testGetScannerResults20".getBytes());
        results = handler.getScannerResults(table, scan, 20);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertArrayEquals((byte[])("testGetScannerResults" + this.pad(i, (byte)2)).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
        scan = new TScan();
        scan.setColumns(columns);
        scan.setReversed(true);
        scan.setStartRow("testGetScannerResults20".getBytes());
        scan.setStopRow("testGetScannerResults".getBytes());
        results = handler.getScannerResults(table, scan, 20);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertArrayEquals((byte[])("testGetScannerResults" + this.pad(19 - i, (byte)2)).getBytes(), (byte[])((TResult)results.get(i)).getRow());
        }
    }

    @Test
    public void testFilterRegistration() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.thrift.filters", "MyFilter:filterclass");
        ThriftServer.registerFilters((Configuration)conf);
        Map registeredFilters = ParseFilter.getAllFilters();
        Assert.assertEquals((Object)"filterclass", registeredFilters.get("MyFilter"));
    }

    @Test
    public void testMetrics() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ThriftMetrics metrics = TestThriftHBaseServiceHandler.getMetrics(conf);
        ThriftHBaseServiceHandler hbaseHandler = this.createHandler();
        THBaseService.Iface handler = ThriftHBaseServiceHandler.newInstance((THBaseService.Iface)hbaseHandler, (ThriftMetrics)metrics);
        byte[] rowName = "testMetrics".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.exists(table, get));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        Assert.assertTrue((boolean)handler.exists(table, get));
        metricsHelper.assertCounter("put_num_ops", 1L, (BaseSource)metrics.getSource());
        metricsHelper.assertCounter("exists_num_ops", 2L, (BaseSource)metrics.getSource());
    }

    private static ThriftMetrics getMetrics(Configuration conf) throws Exception {
        ThriftMetrics m = new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.TWO);
        m.getSource().init();
        return m;
    }

    @Test
    public void testMetricsWithException() throws Exception {
        byte[] rowkey = Bytes.toBytes((String)"row1");
        byte[] family = Bytes.toBytes((String)"f");
        byte[] col = Bytes.toBytes((String)"c");
        TableName tableName = TableName.valueOf((String)"testMetricsWithException");
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        tableDesc.addCoprocessor(ErrorThrowingGetObserver.class.getName());
        tableDesc.addFamily(new HColumnDescriptor(family));
        HTable table = UTIL.createTable(tableDesc, null);
        table.put(new Put(rowkey).addColumn(family, col, Bytes.toBytes((String)"val1")));
        ThriftHBaseServiceHandler hbaseHandler = this.createHandler();
        ThriftMetrics metrics = TestThriftHBaseServiceHandler.getMetrics(UTIL.getConfiguration());
        THBaseService.Iface handler = ThriftHBaseServiceHandler.newInstance((THBaseService.Iface)hbaseHandler, (ThriftMetrics)metrics);
        ByteBuffer tTableName = ByteBuffer.wrap(tableName.getName());
        long preGetCounter = metricsHelper.checkCounterExists("get_num_ops", (BaseSource)metrics.getSource()) ? metricsHelper.getCounter("get_num_ops", (BaseSource)metrics.getSource()) : 0L;
        TGet tGet = new TGet(ByteBuffer.wrap(rowkey));
        TResult tResult = handler.get(tTableName, tGet);
        ArrayList expectedColumnValues = Lists.newArrayList((Object[])new TColumnValue[]{new TColumnValue(ByteBuffer.wrap(family), ByteBuffer.wrap(col), ByteBuffer.wrap(Bytes.toBytes((String)"val1")))});
        Assert.assertArrayEquals((byte[])rowkey, (byte[])tResult.getRow());
        List returnedColumnValues = tResult.getColumnValues();
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
        metricsHelper.assertCounter("get_num_ops", preGetCounter + 1L, (BaseSource)metrics.getSource());
        for (ErrorThrowingGetObserver.ErrorType type : ErrorThrowingGetObserver.ErrorType.values()) {
            this.testExceptionType(handler, metrics, tTableName, rowkey, type);
        }
    }

    private void testExceptionType(THBaseService.Iface handler, ThriftMetrics metrics, ByteBuffer tTableName, byte[] rowkey, ErrorThrowingGetObserver.ErrorType errorType) {
        long preGetCounter = metricsHelper.getCounter("get_num_ops", (BaseSource)metrics.getSource());
        String exceptionKey = errorType.getMetricName();
        long preExceptionCounter = metricsHelper.checkCounterExists(exceptionKey, (BaseSource)metrics.getSource()) ? metricsHelper.getCounter(exceptionKey, (BaseSource)metrics.getSource()) : 0L;
        TGet tGet = new TGet(ByteBuffer.wrap(rowkey));
        HashMap<ByteBuffer, ByteBuffer> attributes = new HashMap<ByteBuffer, ByteBuffer>();
        attributes.put(ByteBuffer.wrap(Bytes.toBytes((String)"error")), ByteBuffer.wrap(Bytes.toBytes((String)errorType.name())));
        tGet.setAttributes(attributes);
        try {
            TResult tResult = handler.get(tTableName, tGet);
            Assert.fail((String)"Get with error attribute should have thrown an exception");
        }
        catch (TException e) {
            LOG.info((Object)"Received exception: ", (Throwable)e);
            metricsHelper.assertCounter("get_num_ops", preGetCounter + 1L, (BaseSource)metrics.getSource());
            metricsHelper.assertCounter(exceptionKey, preExceptionCounter + 1L, (BaseSource)metrics.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsPrecision() throws Exception {
        byte[] rowkey = Bytes.toBytes((String)"row1");
        byte[] family = Bytes.toBytes((String)"f");
        byte[] col = Bytes.toBytes((String)"c");
        TableName tableName = TableName.valueOf((String)"testMetricsPrecision");
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        tableDesc.addCoprocessor(DelayingRegionObserver.class.getName());
        tableDesc.addFamily(new HColumnDescriptor(family));
        HTable table = null;
        try {
            table = UTIL.createTable(tableDesc, null);
            table.put(new Put(rowkey).addColumn(family, col, Bytes.toBytes((String)"val1")));
            ThriftHBaseServiceHandler hbaseHandler = this.createHandler();
            ThriftMetrics metrics = TestThriftHBaseServiceHandler.getMetrics(UTIL.getConfiguration());
            THBaseService.Iface handler = ThriftHBaseServiceHandler.newInstance((THBaseService.Iface)hbaseHandler, (ThriftMetrics)metrics);
            ByteBuffer tTableName = ByteBuffer.wrap(tableName.getName());
            TGet tGet = new TGet(ByteBuffer.wrap(rowkey));
            TResult tResult = handler.get(tTableName, tGet);
            ArrayList expectedColumnValues = Lists.newArrayList((Object[])new TColumnValue[]{new TColumnValue(ByteBuffer.wrap(family), ByteBuffer.wrap(col), ByteBuffer.wrap(Bytes.toBytes((String)"val1")))});
            Assert.assertArrayEquals((byte[])rowkey, (byte[])tResult.getRow());
            List returnedColumnValues = tResult.getColumnValues();
            this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
            metricsHelper.assertGaugeGt("get_max", 3000L, (BaseSource)metrics.getSource());
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
                UTIL.deleteTable(tableName);
            }
        }
    }

    @Test
    public void testAttribute() throws Exception {
        byte[] rowName = "testAttribute".getBytes();
        byte[] attributeKey = "attribute1".getBytes();
        byte[] attributeValue = "value1".getBytes();
        HashMap<ByteBuffer, ByteBuffer> attributes = new HashMap<ByteBuffer, ByteBuffer>();
        attributes.put(ByteBuffer.wrap(attributeKey), ByteBuffer.wrap(attributeValue));
        TGet tGet = new TGet(ByteBuffer.wrap(rowName));
        tGet.setAttributes(attributes);
        Get get = ThriftUtilities.getFromThrift((TGet)tGet);
        Assert.assertArrayEquals((byte[])get.getAttribute("attribute1"), (byte[])attributeValue);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        TPut tPut = new TPut(ByteBuffer.wrap(rowName), columnValues);
        tPut.setAttributes(attributes);
        Put put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertArrayEquals((byte[])put.getAttribute("attribute1"), (byte[])attributeValue);
        TScan tScan = new TScan();
        tScan.setAttributes(attributes);
        Scan scan = ThriftUtilities.scanFromThrift((TScan)tScan);
        Assert.assertArrayEquals((byte[])scan.getAttribute("attribute1"), (byte[])attributeValue);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>();
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement tIncrement = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        tIncrement.setAttributes(attributes);
        Increment increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertArrayEquals((byte[])increment.getAttribute("attribute1"), (byte[])attributeValue);
        TDelete tDelete = new TDelete(ByteBuffer.wrap(rowName));
        tDelete.setAttributes(attributes);
        Delete delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertArrayEquals((byte[])delete.getAttribute("attribute1"), (byte[])attributeValue);
    }

    @Test
    public void testMutateRow() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = "testMutateRow".getBytes();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        handler.put(table, putA);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<Object> expectedColumnValues = new ArrayList<TColumnValue>();
        expectedColumnValues.add(columnValueA);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>();
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        ArrayList<TMutation> mutations = new ArrayList<TMutation>();
        TMutation mutationA = TMutation.put((TPut)putB);
        mutations.add(mutationA);
        TMutation mutationB = TMutation.deleteSingle((TDelete)delete);
        mutations.add(mutationB);
        TRowMutations tRowMutations = new TRowMutations(ByteBuffer.wrap(rowName), mutations);
        handler.mutateRow(table, tRowMutations);
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        returnedColumnValues = result.getColumnValues();
        expectedColumnValues = new ArrayList();
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testDurability() throws Exception {
        byte[] rowName = "testDurability".getBytes();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>();
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TDelete tDelete = new TDelete(ByteBuffer.wrap(rowName));
        tDelete.setDurability(TDurability.SKIP_WAL);
        Delete delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)delete.getDurability(), (Object)Durability.SKIP_WAL);
        tDelete.setDurability(TDurability.ASYNC_WAL);
        delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)delete.getDurability(), (Object)Durability.ASYNC_WAL);
        tDelete.setDurability(TDurability.SYNC_WAL);
        delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)delete.getDurability(), (Object)Durability.SYNC_WAL);
        tDelete.setDurability(TDurability.FSYNC_WAL);
        delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)delete.getDurability(), (Object)Durability.FSYNC_WAL);
        TPut tPut = new TPut(ByteBuffer.wrap(rowName), columnValues);
        tPut.setDurability(TDurability.SKIP_WAL);
        Put put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)put.getDurability(), (Object)Durability.SKIP_WAL);
        tPut.setDurability(TDurability.ASYNC_WAL);
        put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)put.getDurability(), (Object)Durability.ASYNC_WAL);
        tPut.setDurability(TDurability.SYNC_WAL);
        put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)put.getDurability(), (Object)Durability.SYNC_WAL);
        tPut.setDurability(TDurability.FSYNC_WAL);
        put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)put.getDurability(), (Object)Durability.FSYNC_WAL);
        TIncrement tIncrement = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        tIncrement.setDurability(TDurability.SKIP_WAL);
        Increment increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)increment.getDurability(), (Object)Durability.SKIP_WAL);
        tIncrement.setDurability(TDurability.ASYNC_WAL);
        increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)increment.getDurability(), (Object)Durability.ASYNC_WAL);
        tIncrement.setDurability(TDurability.SYNC_WAL);
        increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)increment.getDurability(), (Object)Durability.SYNC_WAL);
        tIncrement.setDurability(TDurability.FSYNC_WAL);
        increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)increment.getDurability(), (Object)Durability.FSYNC_WAL);
    }

    @Test
    public void testCheckAndMutate() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ByteBuffer row = ByteBuffer.wrap("row".getBytes());
        ByteBuffer family = ByteBuffer.wrap(familyAname);
        ByteBuffer qualifier = ByteBuffer.wrap(qualifierAname);
        ByteBuffer value = ByteBuffer.wrap(valueAname);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>();
        TColumnValue columnValueB = new TColumnValue(family, ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(row, columnValuesB);
        putB.setColumnValues(columnValuesB);
        TRowMutations tRowMutations = new TRowMutations(row, Arrays.asList(TMutation.put((TPut)putB)));
        TResult result = handler.get(table, new TGet(row));
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
        Assert.assertFalse((String)"Expected condition to not pass", (boolean)handler.checkAndMutate(table, row, family, qualifier, TCompareOp.EQUAL, value, tRowMutations));
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(family, qualifier, value);
        columnValuesA.add(columnValueA);
        handler.put(table, new TPut(row, columnValuesA));
        result = handler.get(table, new TGet(row));
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        this.assertTColumnValueEqual(columnValueA, (TColumnValue)result.getColumnValues().get(0));
        Assert.assertTrue((String)"Expected condition to pass", (boolean)handler.checkAndMutate(table, row, family, qualifier, TCompareOp.EQUAL, value, tRowMutations));
        result = handler.get(table, new TGet(row));
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        this.assertTColumnValueEqual(columnValueA, (TColumnValue)result.getColumnValues().get(0));
        this.assertTColumnValueEqual(columnValueB, (TColumnValue)result.getColumnValues().get(1));
    }

    public static class DelayingRegionObserver
    extends BaseRegionObserver {
        private static final Log LOG = LogFactory.getLog(DelayingRegionObserver.class);
        private long delayMillis;

        public void start(CoprocessorEnvironment e) throws IOException {
            this.delayMillis = e.getConfiguration().getLong("delayingregionobserver.delay", 3000L);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            try {
                long start = System.currentTimeMillis();
                TimeUnit.MILLISECONDS.sleep(this.delayMillis);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Slept for " + (System.currentTimeMillis() - start) + " msec"));
                }
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted while sleeping");
            }
        }
    }
}

