/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.spark.JavaHBaseContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public final class JavaHBaseBulkGetExample {
    private JavaHBaseBulkGetExample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("JavaHBaseBulkGetExample  {tableName}");
            return;
        }
        String tableName = args[0];
        SparkConf sparkConf = new SparkConf().setAppName("JavaHBaseBulkGetExample " + tableName);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        try {
            ArrayList<byte[]> list = new ArrayList<byte[]>(5);
            list.add(Bytes.toBytes((String)"1"));
            list.add(Bytes.toBytes((String)"2"));
            list.add(Bytes.toBytes((String)"3"));
            list.add(Bytes.toBytes((String)"4"));
            list.add(Bytes.toBytes((String)"5"));
            JavaRDD rdd = jsc.parallelize(list);
            Configuration conf = HBaseConfiguration.create();
            JavaHBaseContext hbaseContext = new JavaHBaseContext(jsc, conf);
            hbaseContext.bulkGet(TableName.valueOf((String)tableName), 2, rdd, new GetFunction(), new ResultFunction());
        }
        finally {
            jsc.stop();
        }
    }

    public static class ResultFunction
    implements Function<Result, String> {
        private static final long serialVersionUID = 1L;

        public String call(Result result) throws Exception {
            Iterator it = result.listCells().iterator();
            StringBuilder b = new StringBuilder();
            b.append(Bytes.toString((byte[])result.getRow())).append(":");
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                String q = Bytes.toString((byte[])cell.getQualifierArray());
                if (q.equals("counter")) {
                    b.append("(").append(Bytes.toString((byte[])cell.getQualifierArray())).append(",").append(Bytes.toLong((byte[])cell.getValueArray())).append(")");
                    continue;
                }
                b.append("(").append(Bytes.toString((byte[])cell.getQualifierArray())).append(",").append(Bytes.toString((byte[])cell.getValueArray())).append(")");
            }
            return b.toString();
        }
    }

    public static class GetFunction
    implements Function<byte[], Get> {
        private static final long serialVersionUID = 1L;

        public Get call(byte[] v) throws Exception {
            return new Get(v);
        }
    }
}

