/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import org.apache.hadoop.hbase.spark.datasources.DoubleSerDes;
import org.apache.spark.sql.datasources.hbase.DataTypeParserWrapper$;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0004\t\u00017!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0003i\u0003BB\u001e\u0001A\u0003%a\u0006C\u0004=\u0001\t\u0007I\u0011A\u0017\t\ru\u0002\u0001\u0015!\u0003/\u0011\u001dq\u0004A1A\u0005\u00025Baa\u0010\u0001!\u0002\u0013q\u0003b\u0002!\u0001\u0005\u0004%\t!\f\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u0018\t\u000f\t\u0003!\u0019!C\u0001\u0007\"11\u000b\u0001Q\u0001\n\u0011Cq\u0001\u0016\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004a\u0001\u0001\u0006IA\u0016\u0005\u0006C\u0002!\tA\u0019\u0002\u0012\u0011\n\u000b7/Z\"bi\u0006dwnZ*vSR,'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#A\u0003iE\u0006\u001cXM\u0003\u0002\u0016-\u00051\u0001.\u00193p_BT!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001dE\u0015\u0002\"!\b\u0011\u000e\u0003yQ!a\b\r\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u0011\u001f\u0005!1UO\\*vSR,\u0007CA\u000f$\u0013\t!cD\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0007CA\u000f'\u0013\t9cDA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\t\u0002\u00075\f\u0007/F\u0001/!\ty\u0003H\u0004\u00021mA\u0011\u0011\u0007N\u0007\u0002e)\u00111GG\u0001\u0007yI|w\u000e\u001e \u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oQ\nA!\\1qA\u0005)\u0011M\u001d:bs\u00061\u0011M\u001d:bs\u0002\n\u0001\"\u0019:sCfl\u0015\r]\u0001\nCJ\u0014\u0018-_'ba\u0002\nqaY1uC2|w-\u0001\u0005dCR\fGn\\4!\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002\tB!QI\u0013'/\u001b\u00051%BA$I\u0003%IW.\\;uC\ndWM\u0003\u0002Ji\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-3%aA'baB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0005Y\u0006twMC\u0001R\u0003\u0011Q\u0017M^1\n\u0005er\u0015a\u00039be\u0006lW\r^3sg\u0002\n\u0011\u0001^\u000b\u0002-B\u0011qKX\u0007\u00021*\u00111#\u0017\u0006\u00035n\u000b1\u0002Z1uCN|WO]2fg*\u0011A,X\u0001\u0004gFd'BA\t\u0017\u0013\ty\u0006LA\tI\u0005\u0006\u001cX\rV1cY\u0016\u001c\u0015\r^1m_\u001e\f!\u0001\u001e\u0011\u0002\u001b\rDWmY6ECR\fG+\u001f9f)\r\u0019w-\u001b\t\u0003I\u0016l\u0011\u0001N\u0005\u0003MR\u0012A!\u00168ji\")\u0001N\u0004a\u0001]\u0005qA-\u0019;b)f\u0004Xm\u0015;sS:<\u0007\"\u00026\u000f\u0001\u0004Y\u0017\u0001E3ya\u0016\u001cG/\u001a3ECR\fG+\u001f9f!\taw.D\u0001n\u0015\tq7,A\u0003usB,7/\u0003\u0002q[\nAA)\u0019;b)f\u0004X\r")
public class HBaseCatalogSuite
extends FunSuite
implements BeforeAndAfterEach,
BeforeAndAfterAll {
    private final String map;
    private final String array;
    private final String arrayMap;
    private final String catalog;
    private final Map<String, String> parameters;
    private final HBaseTableCatalog t;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public void afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public String map() {
        return this.map;
    }

    public String array() {
        return this.array;
    }

    public String arrayMap() {
        return this.arrayMap;
    }

    public String catalog() {
        return this.catalog;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public HBaseTableCatalog t() {
        return this.t;
    }

    public void checkDataType(String dataTypeString, DataType expectedDataType) {
        this.test(new StringBuilder(6).append("parse ").append(dataTypeString.replace("\n", "")).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataTypeParserWrapper$.MODULE$.parse(dataTypeString));
            DataType $org_scalatest_assert_macro_right = expectedDataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    public HBaseCatalogSuite() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.map = "MAP<int, struct<varchar:string>>";
        this.array = "array<struct<tinYint:tinyint>>";
        this.arrayMap = "MAp<int, ARRAY<double>>";
        this.catalog = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(781).append("{\n                    |\"table\":{\"namespace\":\"default\", \"name\":\"htable\"},\n                    |\"rowkey\":\"key1:key2\",\n                    |\"columns\":{\n                    |\"col1\":{\"cf\":\"rowkey\", \"col\":\"key1\", \"type\":\"string\"},\n                    |\"col2\":{\"cf\":\"rowkey\", \"col\":\"key2\", \"type\":\"double\"},\n                    |\"col3\":{\"cf\":\"cf1\", \"col\":\"col2\", \"type\":\"binary\"},\n                    |\"col4\":{\"cf\":\"cf1\", \"col\":\"col3\", \"type\":\"timestamp\"},\n                    |\"col5\":{\"cf\":\"cf1\", \"col\":\"col4\", \"type\":\"double\", \"serdes\":\"").append(DoubleSerDes.class.getName()).append("\"},\n                    |\"col6\":{\"cf\":\"cf1\", \"col\":\"col5\", \"type\":\"").append(this.map()).append("\"},\n                    |\"col7\":{\"cf\":\"cf1\", \"col\":\"col6\", \"type\":\"").append(this.array()).append("\"},\n                    |\"col8\":{\"cf\":\"cf1\", \"col\":\"col7\", \"type\":\"").append(this.arrayMap()).append("\"}\n                    |}\n                    |}").toString())).stripMargin();
        this.parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.catalog())}));
        this.t = HBaseTableCatalog$.MODULE$.apply(this.parameters());
        this.test("basic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            boolean $org_scalatest_assert_macro_left = this.t().getField("col1").isRowKey();
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            String $org_scalatest_assert_macro_left2 = this.t().getPrimaryKey();
            String $org_scalatest_assert_macro_right2 = "key1";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            DataType $org_scalatest_assert_macro_left3 = this.t().getField("col3").dt();
            BinaryType$ $org_scalatest_assert_macro_right3 = BinaryType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left3;
            BinaryType$ binaryType$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            DataType $org_scalatest_assert_macro_left4 = this.t().getField("col4").dt();
            TimestampType$ $org_scalatest_assert_macro_right4 = TimestampType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left4;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType2 != null ? !dataType2.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            DataType $org_scalatest_assert_macro_left5 = this.t().getField("col5").dt();
            DoubleType$ $org_scalatest_assert_macro_right5 = DoubleType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left5;
            DoubleType$ doubleType$ = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(dataType3 != null ? !dataType3.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            Option $org_scalatest_assert_macro_left6 = this.t().getField("col5").serdes();
            None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
            Option option = $org_scalatest_assert_macro_left6;
            None$ none$ = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!=", (Object)$org_scalatest_assert_macro_right6, option == null ? none$ != null : !option.equals(none$), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            Option $org_scalatest_assert_macro_left7 = this.t().getField("col4").serdes();
            None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left7;
            None$ none$2 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(option2 != null ? !option2.equals(none$2) : none$2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(this.t().getField("col1").isRowKey(), "HBaseCatalogSuite.this.t.getField(\"col1\").isRowKey", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(this.t().getField("col2").isRowKey(), "HBaseCatalogSuite.this.t.getField(\"col2\").isRowKey", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.t().getField("col3").isRowKey(), "HBaseCatalogSuite.this.t.getField(\"col3\").isRowKey", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Field $org_scalatest_assert_macro_left8 = this.t().getField("col2");
            int $org_scalatest_assert_macro_right8 = 8;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Field $org_scalatest_assert_macro_left9 = this.t().getField("col1");
            int $org_scalatest_assert_macro_right9 = -1;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Field $org_scalatest_assert_macro_left10 = this.t().getField("col8");
            int $org_scalatest_assert_macro_right10 = -1;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.checkDataType(this.map(), this.t().getField("col6").dt());
        this.checkDataType(this.array(), this.t().getField("col7").dt());
        this.checkDataType(this.arrayMap(), this.t().getField("col8").dt());
        this.test("convert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Map m = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hbase.columns.mapping"), (Object)"KEY_FIELD STRING :key, A_FIELD STRING c:a, B_FIELD DOUBLE c:b, C_FIELD BINARY c:c,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hbase.table"), (Object)"t1")}));
            Map map = HBaseTableCatalog$.MODULE$.convert(m);
            String json = (String)map.get((Object)HBaseTableCatalog$.MODULE$.tableCatalog()).get();
            Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)json)}));
            HBaseTableCatalog t = HBaseTableCatalog$.MODULE$.apply(parameters);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(t.getField("KEY_FIELD").isRowKey(), "t.getField(\"KEY_FIELD\").isRowKey", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataTypeParserWrapper$.MODULE$.parse("STRING"));
            DataType $org_scalatest_assert_macro_right = t.getField("A_FIELD").dt();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t.getField("A_FIELD").isRowKey(), "t.getField(\"A_FIELD\").isRowKey", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DataTypeParserWrapper$.MODULE$.parse("DOUBLE"));
            DataType $org_scalatest_assert_macro_right2 = t.getField("B_FIELD").dt();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(DataTypeParserWrapper$.MODULE$.parse("BINARY"));
            DataType $org_scalatest_assert_macro_right3 = t.getField("C_FIELD").dt();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("compatiblity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Map m = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hbase.columns.mapping"), (Object)"KEY_FIELD STRING :key, A_FIELD STRING c:a, B_FIELD DOUBLE c:b, C_FIELD BINARY c:c,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hbase.table"), (Object)"t1")}));
            HBaseTableCatalog t = HBaseTableCatalog$.MODULE$.apply(m);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(t.getField("KEY_FIELD").isRowKey(), "t.getField(\"KEY_FIELD\").isRowKey", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataTypeParserWrapper$.MODULE$.parse("STRING"));
            DataType $org_scalatest_assert_macro_right = t.getField("A_FIELD").dt();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t.getField("A_FIELD").isRowKey(), "t.getField(\"A_FIELD\").isRowKey", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DataTypeParserWrapper$.MODULE$.parse("DOUBLE"));
            DataType $org_scalatest_assert_macro_right2 = t.getField("B_FIELD").dt();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(DataTypeParserWrapper$.MODULE$.parse("BINARY"));
            DataType $org_scalatest_assert_macro_right3 = t.getField("C_FIELD").dt();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("HBaseCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
    }
}

