/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.jruby.embed.ScriptingContainer;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractTestShell {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final ScriptingContainer jruby = new ScriptingContainer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", -1);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        SecureTestUtil.enableSecurity((Configuration)TEST_UTIL.getConfiguration());
        VisibilityTestUtil.enableVisiblityLabels((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster();
        ArrayList<String> loadPaths = new ArrayList<String>();
        loadPaths.add("src/main/ruby");
        loadPaths.add("src/test/ruby");
        jruby.setLoadPaths(loadPaths);
        jruby.put("$TEST_CLUSTER", (Object)TEST_UTIL);
        System.setProperty("jruby.jit.logging.verbose", "true");
        System.setProperty("jruby.jit.logging", "true");
        System.setProperty("jruby.native.verbose", "true");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

