/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DefaultWALProvider
implements WALProvider {
    private static final Log LOG = LogFactory.getLog(DefaultWALProvider.class);
    protected volatile FSHLog log = null;
    private WALFactory factory = null;
    private Configuration conf = null;
    private List<WALActionsListener> listeners = null;
    private String providerId = null;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private String logPrefix = null;
    private final Object walCreateLock = new Object();
    public static final String WAL_FILE_NAME_DELIMITER = ".";
    @VisibleForTesting
    public static final String META_WAL_PROVIDER_ID = ".meta";
    static final String DEFAULT_PROVIDER_ID = "default";
    public static final String SPLITTING_EXT = "-splitting";
    private static final Pattern pattern = Pattern.compile(".*\\.\\d*(.meta)*");

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        this.conf = conf;
        this.listeners = listeners;
        this.providerId = providerId;
        StringBuilder sb = new StringBuilder().append(factory.factoryId);
        if (providerId != null) {
            if (providerId.startsWith(WAL_FILE_NAME_DELIMITER)) {
                sb.append(providerId);
            } else {
                sb.append(WAL_FILE_NAME_DELIMITER).append(providerId);
            }
        }
        this.logPrefix = sb.toString();
    }

    @Override
    public List<WAL> getWALs() throws IOException {
        if (this.log == null) {
            return Collections.emptyList();
        }
        ArrayList<WAL> wals = new ArrayList<WAL>();
        wals.add(this.log);
        return wals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WAL getWAL(byte[] identifier, byte[] namespace) throws IOException {
        if (this.log == null) {
            Object object = this.walCreateLock;
            synchronized (object) {
                if (this.log == null) {
                    this.log = new FSHLog(FSUtils.getWALFileSystem(this.conf), FSUtils.getWALRootDir(this.conf), DefaultWALProvider.getWALDirectoryName(this.factory.factoryId), "oldWALs", this.conf, this.listeners, true, this.logPrefix, META_WAL_PROVIDER_ID.equals(this.providerId) ? META_WAL_PROVIDER_ID : null);
                }
            }
        }
        return this.log;
    }

    @Override
    public void close() throws IOException {
        if (this.log != null) {
            this.log.close();
        }
    }

    @Override
    public void shutdown() throws IOException {
        if (this.log != null) {
            this.log.shutdown();
        }
    }

    @Override
    public long getNumLogFiles() {
        return this.log == null ? 0L : (long)this.log.getNumLogFiles();
    }

    @Override
    public long getLogFileSize() {
        return this.log == null ? 0L : this.log.getLogFileSize();
    }

    @VisibleForTesting
    public static int getNumRolledLogFiles(WAL wal) {
        return ((FSHLog)wal).getNumRolledLogFiles();
    }

    @VisibleForTesting
    public static Path getCurrentFileName(WAL wal) {
        return ((FSHLog)wal).getCurrentFileName();
    }

    @VisibleForTesting
    static void requestLogRoll(WAL wal) {
        ((FSHLog)wal).requestLogRoll();
    }

    @VisibleForTesting
    public static long extractFileNumFromWAL(WAL wal) {
        Path walName = ((FSHLog)wal).getCurrentFileName();
        if (walName == null) {
            throw new IllegalArgumentException("The WAL path couldn't be null");
        }
        String[] walPathStrs = walName.toString().split("\\.");
        return Long.parseLong(walPathStrs[walPathStrs.length - (DefaultWALProvider.isMetaFile(walName) ? 2 : 1)]);
    }

    public static boolean validateWALFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    public static String getWALDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder("WALs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    public static ServerName getServerNameFromWALDirectoryName(Configuration conf, String path) throws IOException {
        String fullPath;
        if (path == null || path.length() <= "WALs".length()) {
            return null;
        }
        if (conf == null) {
            throw new IllegalArgumentException("parameter conf must be set");
        }
        String walDir = FSUtils.getWALRootDir(conf).toString();
        StringBuilder startPathSB = new StringBuilder(walDir);
        if (!walDir.endsWith("/")) {
            startPathSB.append('/');
        }
        startPathSB.append("WALs");
        if (!"WALs".endsWith("/")) {
            startPathSB.append('/');
        }
        String startPath = startPathSB.toString();
        try {
            fullPath = FileSystem.get((Configuration)conf).makeQualified(new Path(path)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.info((Object)("Call to makeQualified failed on " + path + " " + e.getMessage()));
            return null;
        }
        if (!fullPath.startsWith(startPath)) {
            return null;
        }
        String serverNameAndFile = fullPath.substring(startPath.length());
        if (serverNameAndFile.indexOf(47) < "a,0,0".length()) {
            return null;
        }
        Path p = new Path(path);
        return DefaultWALProvider.getServerNameFromWALDirectoryName(p);
    }

    public static ServerName getServerNameFromWALDirectoryName(Path logFile) {
        String logDirName = logFile.getParent().getName();
        if (logDirName.equals("WALs")) {
            logDirName = logFile.getName();
        }
        ServerName serverName = null;
        if (logDirName.endsWith(SPLITTING_EXT)) {
            logDirName = logDirName.substring(0, logDirName.length() - SPLITTING_EXT.length());
        }
        try {
            serverName = ServerName.parseServerName((String)logDirName);
        }
        catch (IllegalArgumentException ex) {
            serverName = null;
            LOG.warn((Object)("Cannot parse a server name from path=" + logFile + "; " + ex.getMessage()));
        }
        if (serverName != null && serverName.getStartcode() < 0L) {
            LOG.warn((Object)("Invalid log file path=" + logFile));
            serverName = null;
        }
        return serverName;
    }

    public static boolean isMetaFile(Path p) {
        return DefaultWALProvider.isMetaFile(p.getName());
    }

    public static boolean isMetaFile(String p) {
        return p != null && p.endsWith(META_WAL_PROVIDER_ID);
    }

    public static Writer createWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable) throws IOException {
        Class logWriterClass = conf.getClass("hbase.regionserver.hlog.writer.impl", ProtobufLogWriter.class, Writer.class);
        Writer writer = null;
        try {
            writer = (Writer)logWriterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            FileSystem rootFs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
            writer.init(rootFs, path, conf, overwritable);
            return writer;
        }
        catch (Exception e) {
            LOG.debug((Object)"Error instantiating log writer.", (Throwable)e);
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ee) {
                    LOG.error((Object)"cannot close log writer", (Throwable)ee);
                }
            }
            throw new IOException("cannot get log writer", e);
        }
    }

    public static String getWALPrefixFromWALName(String name) {
        int endIndex = name.replaceAll(META_WAL_PROVIDER_ID, "").lastIndexOf(WAL_FILE_NAME_DELIMITER);
        return name.substring(0, endIndex);
    }

    public static Path getWALArchivePath(Path archiveDir, Path p) {
        return new Path(archiveDir, p.getName());
    }

    public static interface Writer
    extends WALProvider.Writer {
        public void init(FileSystem var1, Path var2, Configuration var3, boolean var4) throws IOException;
    }

    public static interface Reader
    extends WAL.Reader {
        public void init(FileSystem var1, Path var2, Configuration var3, FSDataInputStream var4) throws IOException;
    }
}

