/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.scram;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.scram.CredentialCache;
import org.apache.hadoop.security.scram.ScramCredential;
import org.apache.hadoop.security.scram.ScramCredentialCallback;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;

public class ScramServerCallbackHandler
implements CallbackHandler {
    private final CredentialCache.Cache<ScramCredential> credentialCache;
    private SecretManager<TokenIdentifier> secretManager;
    private RpcServer.Connection connection;

    public ScramServerCallbackHandler(CredentialCache.Cache<ScramCredential> credentialCache, SecretManager<TokenIdentifier> secretManager, RpcServer.Connection connection) {
        this.credentialCache = credentialCache;
        this.secretManager = secretManager;
        this.connection = connection;
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = ScramServerCallbackHandler.decodeIdentifier(id);
        TokenIdentifier tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause((Throwable)e);
        }
        return (T)tokenIdentifier;
    }

    public static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64((byte[])identifier.getBytes());
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                username = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof ScramCredentialCallback) {
                TokenIdentifier tokenIdentifier = ScramServerCallbackHandler.getIdentifier(username, this.secretManager);
                this.connection.attemptingUser = tokenIdentifier.getUser();
                ((ScramCredentialCallback)callback).scramCredential((ScramCredential)this.credentialCache.get(UserGroupInformation.getLoginUser().getUserName()));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

