/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class BucketCacheStats
extends CacheStats {
    private final Counter ioHitCount = new Counter(0L);
    private final Counter ioHitTime = new Counter(0L);
    private static final int nanoTime = 1000000;
    private long lastLogTime = EnvironmentEdgeManager.currentTime();

    BucketCacheStats() {
        super("BucketCache");
    }

    @Override
    public String toString() {
        return super.toString() + ", ioHitsPerSecond=" + this.getIOHitsPerSecond() + ", ioTimePerHit=" + this.getIOTimePerHit();
    }

    public void ioHit(long time) {
        this.ioHitCount.increment();
        this.ioHitTime.add(time);
    }

    public long getIOHitsPerSecond() {
        long now = EnvironmentEdgeManager.currentTime();
        long took = (now - this.lastLogTime) / 1000L;
        this.lastLogTime = now;
        return took == 0L ? 0L : this.ioHitCount.get() / took;
    }

    public double getIOTimePerHit() {
        long time = this.ioHitTime.get() / 1000000L;
        long count = this.ioHitCount.get();
        return (float)time / (float)count;
    }

    public void reset() {
        this.ioHitCount.set(0L);
        this.ioHitTime.set(0L);
    }
}

