/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CustomHeadersFilter
implements Filter {
    private Properties customHeadersProps = new Properties();

    public void init(FilterConfig filterConfig) throws ServletException {
        String headersFileLocation = filterConfig.getInitParameter("hbase.custom.headers.file");
        File headersFile = new File(headersFileLocation);
        if (headersFile.exists()) {
            try {
                this.customHeadersProps.loadFromXML(new FileInputStream(headersFile));
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            throw new ServletException((Throwable)new FileNotFoundException("Headers file does not exist: " + headersFileLocation));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.customHeadersProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> httpResponse.addHeader((String)k, (String)v)));
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

