/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.TestReplicationSyncUpTool;
import org.apache.hadoop.hbase.replication.regionserver.TestSourceFSConfigurationProvider;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationSyncUpToolWithBulkLoadedData
extends TestReplicationSyncUpTool {
    private static final Log LOG = LogFactory.getLog(TestReplicationSyncUpToolWithBulkLoadedData.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.setBoolean("hbase.replication.bulkload.enabled", true);
        conf1.set("hbase.replication.cluster.id", "12345");
        conf1.set("hbase.replication.source.fs.conf.provider", TestSourceFSConfigurationProvider.class.getCanonicalName());
        Object classes = conf1.get("hbase.coprocessor.region.classes", "");
        if (!((String)classes).contains("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint")) {
            classes = (String)classes + ",org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint";
            conf1.set("hbase.coprocessor.region.classes", (String)classes);
        }
        TestReplicationBase.setUpBeforeClass();
    }

    @Override
    public void testSyncUpTool() throws Exception {
        this.setupReplication();
        Iterator<String> randomHFileRangeListIterator = null;
        HashSet<String> randomHFileRanges = new HashSet<String>(16);
        for (int i = 0; i < 16; ++i) {
            randomHFileRanges.add(UUID.randomUUID().toString());
        }
        ArrayList randomHFileRangeList = new ArrayList(randomHFileRanges);
        Collections.sort(randomHFileRangeList);
        randomHFileRangeListIterator = randomHFileRangeList.iterator();
        this.loadAndReplicateHFiles(true, randomHFileRangeListIterator);
        this.mimicSyncUpAfterBulkLoad(randomHFileRangeListIterator);
    }

    private void mimicSyncUpAfterBulkLoad(Iterator<String> randomHFileRangeListIterator) throws Exception {
        LOG.debug((Object)"mimicSyncUpAfterBulkLoad");
        utility2.shutdownMiniHBaseCluster();
        this.loadAndReplicateHFiles(false, randomHFileRangeListIterator);
        int rowCount_ht1Source = utility1.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 206 rows on source, after bulk load of another 103 hfiles", (long)206L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = utility1.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 406 rows on source, after bulk load of another 203 hfiles", (long)406L, (long)rowCount_ht2Source);
        utility1.shutdownMiniHBaseCluster();
        utility2.restartHBaseCluster(1);
        Thread.sleep(500L);
        int rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
        int rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should still have 100 rows", (long)100L, (long)rowCount_ht1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should still have 200 rows", (long)200L, (long)rowCount_ht2TargetAtPeer1);
        this.syncUp(utility1);
        for (int i = 0; i < 10; ++i) {
            this.syncUp(utility1);
            rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
            rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
            if (i == 9) {
                if (rowCount_ht1TargetAtPeer1 != 200 || rowCount_ht2TargetAtPeer1 != 400) {
                    utility1.restartHBaseCluster(1);
                    rowCount_ht1Source = utility1.countRows(this.ht1Source);
                    LOG.debug((Object)("t1_syncup should have 206 rows at source, and it is " + rowCount_ht1Source));
                    rowCount_ht2Source = utility1.countRows(this.ht2Source);
                    LOG.debug((Object)("t2_syncup should have 406 rows at source, and it is " + rowCount_ht2Source));
                }
                Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 200 rows", (long)200L, (long)rowCount_ht1TargetAtPeer1);
                Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 400 rows", (long)400L, (long)rowCount_ht2TargetAtPeer1);
            }
            if (rowCount_ht1TargetAtPeer1 == 200 && rowCount_ht2TargetAtPeer1 == 400) {
                LOG.info((Object)("SyncUpAfterBulkLoad succeeded at retry = " + i));
                break;
            }
            LOG.debug((Object)("SyncUpAfterBulkLoad failed at retry = " + i + ", with rowCount_ht1TargetPeer1 =" + rowCount_ht1TargetAtPeer1 + " and rowCount_ht2TargetAtPeer1 =" + rowCount_ht2TargetAtPeer1));
            Thread.sleep(500L);
        }
    }

    private void loadAndReplicateHFiles(boolean verifyReplicationOnSlave, Iterator<String> randomHFileRangeListIterator) throws Exception {
        LOG.debug((Object)"loadAndReplicateHFiles");
        byte[][][] hfileRanges = new byte[][][]{new byte[][]{Bytes.toBytes((String)randomHFileRangeListIterator.next()), Bytes.toBytes((String)randomHFileRangeListIterator.next())}};
        this.loadAndValidateHFileReplication("HFileReplication_1", row, famName, this.ht1Source, hfileRanges, 100);
        hfileRanges = new byte[][][]{new byte[][]{Bytes.toBytes((String)randomHFileRangeListIterator.next()), Bytes.toBytes((String)randomHFileRangeListIterator.next())}};
        this.loadAndValidateHFileReplication("HFileReplication_1", row, noRepfamName, this.ht1Source, hfileRanges, 3);
        hfileRanges = new byte[][][]{new byte[][]{Bytes.toBytes((String)randomHFileRangeListIterator.next()), Bytes.toBytes((String)randomHFileRangeListIterator.next())}};
        this.loadAndValidateHFileReplication("HFileReplication_1", row, famName, this.ht2Source, hfileRanges, 200);
        hfileRanges = new byte[][][]{new byte[][]{Bytes.toBytes((String)randomHFileRangeListIterator.next()), Bytes.toBytes((String)randomHFileRangeListIterator.next())}};
        this.loadAndValidateHFileReplication("HFileReplication_1", row, noRepfamName, this.ht2Source, hfileRanges, 3);
        if (verifyReplicationOnSlave) {
            this.wait(this.ht1TargetAtPeer1, utility1.countRows(this.ht1Source) - 3, "t1_syncup has 103 rows on source, and 100 on slave1");
            this.wait(this.ht2TargetAtPeer1, utility1.countRows(this.ht2Source) - 3, "t2_syncup has 203 rows on source, and 200 on slave1");
        }
    }

    private void loadAndValidateHFileReplication(String testName, byte[] row, byte[] fam, Table source, byte[][][] hfileRanges, int numOfRows) throws Exception {
        Path dir = utility1.getDataTestDirOnTestFS(testName);
        FileSystem fs = utility1.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])fam));
        int hfileIdx = 0;
        for (byte[][] range : hfileRanges) {
            byte[] from = range[0];
            byte[] to = range[1];
            HFileTestUtil.createHFile(utility1.getConfiguration(), fs, new Path(familyDir, "hfile_" + hfileIdx++), fam, row, from, to, numOfRows);
        }
        TableName tableName = source.getName();
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(utility1.getConfiguration());
        String[] args = new String[]{dir.toString(), tableName.toString()};
        loader.run(args);
    }

    private void wait(Table target, int expectedCount, String msg) throws IOException, InterruptedException {
        for (int i = 0; i < 10; ++i) {
            int rowCount_ht2TargetAtPeer1 = utility2.countRows(target);
            if (i == 9) {
                Assert.assertEquals((String)msg, (long)expectedCount, (long)rowCount_ht2TargetAtPeer1);
            }
            if (expectedCount == rowCount_ht2TargetAtPeer1) break;
            Thread.sleep(500L);
        }
    }
}

