/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.regionserver.HeapMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreChunkPool;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMemStoreLAB {
    @Test
    public void testLABRandomAllocation() {
        Random rand = new Random();
        HeapMemStoreLAB mslab = new HeapMemStoreLAB();
        int expectedOff = 0;
        byte[] lastBuffer = null;
        for (int i = 0; i < 100000; ++i) {
            int size = rand.nextInt(1000);
            ByteRange alloc = mslab.allocateBytes(size);
            if (alloc.getBytes() != lastBuffer) {
                expectedOff = 0;
                lastBuffer = alloc.getBytes();
            }
            Assert.assertEquals((long)expectedOff, (long)alloc.getOffset());
            Assert.assertTrue((String)"Allocation overruns buffer", (alloc.getOffset() + size <= alloc.getBytes().length ? 1 : 0) != 0);
            expectedOff += size;
        }
    }

    @Test
    public void testLABLargeAllocation() {
        HeapMemStoreLAB mslab = new HeapMemStoreLAB();
        ByteRange alloc = mslab.allocateBytes(0x200000);
        Assert.assertNull((String)"2MB allocation shouldn't be satisfied by LAB.", (Object)alloc);
    }

    @Test
    public void testLABThreading() throws Exception {
        Configuration conf = new Configuration();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
        AtomicInteger totalAllocated = new AtomicInteger();
        HeapMemStoreLAB mslab = new HeapMemStoreLAB();
        ArrayList allocations = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            LinkedList allocsByThisThread = Lists.newLinkedList();
            allocations.add(allocsByThisThread);
            MultithreadedTestUtil.RepeatingTestThread t = new MultithreadedTestUtil.RepeatingTestThread(ctx, (MemStoreLAB)mslab, totalAllocated, allocsByThisThread){
                private Random r;
                final /* synthetic */ MemStoreLAB val$mslab;
                final /* synthetic */ AtomicInteger val$totalAllocated;
                final /* synthetic */ List val$allocsByThisThread;
                {
                    this.val$mslab = memStoreLAB;
                    this.val$totalAllocated = atomicInteger;
                    this.val$allocsByThisThread = list;
                    super(ctx);
                    this.r = new Random();
                }

                @Override
                public void doAnAction() throws Exception {
                    int size = this.r.nextInt(1000);
                    ByteRange alloc = this.val$mslab.allocateBytes(size);
                    this.val$totalAllocated.addAndGet(size);
                    this.val$allocsByThisThread.add(new AllocRecord(alloc, size));
                }
            };
            ctx.addThread(t);
        }
        ctx.startThreads();
        while (totalAllocated.get() < 0x3200000 && ctx.shouldRun()) {
            Thread.sleep(10L);
        }
        ctx.stop();
        HashMap mapsByChunk = Maps.newHashMap();
        int sizeCounted = 0;
        for (AllocRecord rec : Iterables.concat((Iterable)allocations)) {
            sizeCounted += rec.size;
            if (rec.size == 0) continue;
            Map mapForThisByteArray = (Map)mapsByChunk.get(rec.alloc.getBytes());
            if (mapForThisByteArray == null) {
                mapForThisByteArray = Maps.newTreeMap();
                mapsByChunk.put(rec.alloc.getBytes(), mapForThisByteArray);
            }
            AllocRecord oldVal = mapForThisByteArray.put(rec.alloc.getOffset(), rec);
            Assert.assertNull((String)("Already had an entry " + oldVal + " for allocation " + rec), (Object)oldVal);
        }
        Assert.assertEquals((String)"Sanity check test", (long)sizeCounted, (long)totalAllocated.get());
        for (Map allocsInChunk : mapsByChunk.values()) {
            int expectedOff = 0;
            for (AllocRecord alloc : allocsInChunk.values()) {
                Assert.assertEquals((long)expectedOff, (long)alloc.alloc.getOffset());
                Assert.assertTrue((String)"Allocation overruns buffer", (alloc.alloc.getOffset() + alloc.size <= alloc.alloc.getBytes().length ? 1 : 0) != 0);
                expectedOff += alloc.size;
            }
        }
    }

    @Test
    public void testLABChunkQueue() throws Exception {
        HeapMemStoreLAB mslab = new HeapMemStoreLAB();
        Assert.assertNull((Object)mslab.getChunkQueue());
        Configuration conf = HBaseConfiguration.create();
        conf.setDouble("hbase.hregion.memstore.chunkpool.maxsize", 0.1);
        conf.setLong("hbase.hregion.memstore.mslab.chunksize", 262144L);
        MemStoreChunkPool.clearDisableFlag();
        mslab = new HeapMemStoreLAB(conf);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            threads.add(this.getChunkQueueTestThread(mslab, "testLABChunkQueue-" + i));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        Thread.sleep(1000L);
        for (Thread thread : threads) {
            thread.interrupt();
        }
        boolean threadsRunning = true;
        while (threadsRunning) {
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                threadsRunning = true;
                break;
            }
            threadsRunning = false;
        }
        mslab.close();
        int n = mslab.getChunkQueue().size();
        Assert.assertTrue((String)("All chunks in chunk queue should be reclaimed or removed after mslab closed but actually: " + n), (n == 0 ? 1 : 0) != 0);
    }

    private Thread getChunkQueueTestThread(final HeapMemStoreLAB mslab, String threadName) {
        Thread thread = new Thread(){
            boolean stopped = false;

            @Override
            public void run() {
                while (!this.stopped) {
                    mslab.allocateBytes(262143);
                }
            }

            @Override
            public void interrupt() {
                this.stopped = true;
            }
        };
        thread.setName(threadName);
        thread.setDaemon(true);
        return thread;
    }

    private static class AllocRecord
    implements Comparable<AllocRecord> {
        private final ByteRange alloc;
        private final int size;

        public AllocRecord(ByteRange alloc, int size) {
            this.alloc = alloc;
            this.size = size;
        }

        @Override
        public int compareTo(AllocRecord e) {
            if (this.alloc.getBytes() != e.alloc.getBytes()) {
                throw new RuntimeException("Can only compare within a particular array");
            }
            return Ints.compare((int)this.alloc.getOffset(), (int)e.alloc.getOffset());
        }

        public String toString() {
            return "AllocRecord(offset=" + this.alloc.getOffset() + ", size=" + this.size + ")";
        }
    }
}

