/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestMasterProcedureScheduler {
    private static final Log LOG = LogFactory.getLog(TestMasterProcedureScheduler.class);
    private MasterProcedureScheduler queue;
    private Configuration conf;

    @Before
    public void setUp() throws IOException {
        this.conf = HBaseConfiguration.create();
        this.queue = new MasterProcedureScheduler(this.conf, (TableLockManager)new TableLockManager.NullTableLockManager());
    }

    @After
    public void tearDown() throws IOException {
        Assert.assertEquals((long)0L, (long)this.queue.size());
    }

    @Test
    public void testConcurrentCreateDelete() throws Exception {
        final MasterProcedureScheduler procQueue = this.queue;
        final TableName table = TableName.valueOf((String)"testtb");
        final AtomicBoolean running = new AtomicBoolean(true);
        final AtomicBoolean failure = new AtomicBoolean(false);
        Thread createThread = new Thread(){

            @Override
            public void run() {
                try {
                    TestTableProcedure proc = new TestTableProcedure(1L, table, TableProcedureInterface.TableOperationType.CREATE);
                    while (running.get() && !failure.get()) {
                        if (!procQueue.tryAcquireTableExclusiveLock((Procedure)proc, table)) continue;
                        procQueue.releaseTableExclusiveLock((Procedure)proc, table);
                    }
                }
                catch (Throwable e) {
                    LOG.error((Object)"create failed", e);
                    failure.set(true);
                }
            }
        };
        Thread deleteThread = new Thread(){

            @Override
            public void run() {
                try {
                    TestTableProcedure proc = new TestTableProcedure(2L, table, TableProcedureInterface.TableOperationType.DELETE);
                    while (running.get() && !failure.get()) {
                        if (procQueue.tryAcquireTableExclusiveLock((Procedure)proc, table)) {
                            procQueue.releaseTableExclusiveLock((Procedure)proc, table);
                        }
                        procQueue.markTableAsDeleted(table);
                    }
                }
                catch (Throwable e) {
                    LOG.error((Object)"delete failed", e);
                    failure.set(true);
                }
            }
        };
        createThread.start();
        deleteThread.start();
        for (int i = 0; i < 100 && running.get() && !failure.get(); ++i) {
            Thread.sleep(100L);
        }
        running.set(false);
        createThread.join();
        deleteThread.join();
        Assert.assertEquals((Object)false, (Object)failure.get());
    }

    @Test
    public void testSimpleTableOpsQueues() throws Exception {
        int i;
        int NUM_TABLES = 10;
        int NUM_ITEMS = 10;
        int count = 0;
        for (i = 1; i <= 10; ++i) {
            TableName tableName = TableName.valueOf((String)String.format("test-%04d", i));
            for (int j = 1; j <= 10; ++j) {
                this.queue.addBack((Procedure)new TestTableProcedure(i * 1000 + j, tableName, TableProcedureInterface.TableOperationType.EDIT));
                Assert.assertEquals((long)(++count), (long)this.queue.size());
            }
        }
        Assert.assertEquals((long)100L, (long)this.queue.size());
        for (int j = 1; j <= 10; ++j) {
            for (int i2 = 1; i2 <= 10; ++i2) {
                Procedure proc = this.queue.poll();
                Assert.assertTrue((proc != null ? 1 : 0) != 0);
                TableName tableName = ((TestTableProcedure)proc).getTableName();
                this.queue.tryAcquireTableExclusiveLock(proc, tableName);
                this.queue.releaseTableExclusiveLock(proc, tableName);
                this.queue.completionCleanup(proc);
                Assert.assertEquals((long)(--count), (long)this.queue.size());
                Assert.assertEquals((long)(i2 * 1000 + j), (long)proc.getProcId());
            }
        }
        Assert.assertEquals((long)0L, (long)this.queue.size());
        for (i = 1; i <= 10; ++i) {
            TableName tableName = TableName.valueOf((String)String.format("test-%04d", i));
            Assert.assertTrue((boolean)this.queue.markTableAsDeleted(tableName));
        }
    }

    @Test
    public void testCreateDeleteTableOperationsWithWriteLock() throws Exception {
        TableName tableName = TableName.valueOf((String)"testtb");
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertTrue((boolean)this.queue.tryAcquireTableExclusiveLock(proc, tableName));
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName));
        this.queue.releaseTableExclusiveLock(proc, tableName);
        Assert.assertTrue((boolean)this.queue.markTableAsDeleted(tableName));
    }

    @Test
    public void testCreateDeleteTableOperationsWithReadLock() throws Exception {
        int i;
        TableName tableName = TableName.valueOf((String)"testtb");
        int nitems = 2;
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.queue.addBack((Procedure)new TestTableProcedure(i2, tableName, TableProcedureInterface.TableOperationType.READ));
        }
        Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName));
        Procedure[] procs = new Procedure[2];
        for (i = 0; i < 2; ++i) {
            Procedure proc = procs[i] = this.queue.poll();
            Assert.assertEquals((long)(i + 1), (long)proc.getProcId());
            Assert.assertTrue((boolean)this.queue.tryAcquireTableSharedLock(proc, tableName));
            Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName));
        }
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName));
            this.queue.releaseTableSharedLock(procs[i], tableName);
        }
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertTrue((boolean)this.queue.markTableAsDeleted(tableName));
    }

    @Test
    public void testVerifyRwLocks() throws Exception {
        TableName tableName = TableName.valueOf((String)"testtb");
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName, TableProcedureInterface.TableOperationType.READ));
        this.queue.addBack((Procedure)new TestTableProcedure(3L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(4L, tableName, TableProcedureInterface.TableOperationType.READ));
        this.queue.addBack((Procedure)new TestTableProcedure(5L, tableName, TableProcedureInterface.TableOperationType.READ));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireTableExclusiveLock(proc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.releaseTableExclusiveLock(proc, tableName);
        Procedure rdProc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)rdProc.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireTableSharedLock(rdProc, tableName));
        Procedure wrProc = this.queue.poll();
        Assert.assertEquals((long)3L, (long)wrProc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.tryAcquireTableExclusiveLock(wrProc, tableName));
        this.queue.releaseTableSharedLock(rdProc, tableName);
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireTableExclusiveLock(wrProc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.releaseTableExclusiveLock(wrProc, tableName);
        rdProc = this.queue.poll();
        Assert.assertEquals((long)4L, (long)rdProc.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireTableSharedLock(rdProc, tableName));
        Procedure rdProc2 = this.queue.poll();
        Assert.assertEquals((long)5L, (long)rdProc2.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireTableSharedLock(rdProc2, tableName));
        this.queue.releaseTableSharedLock(rdProc, tableName);
        this.queue.releaseTableSharedLock(rdProc2, tableName);
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertTrue((String)"queue should be deleted", (boolean)this.queue.markTableAsDeleted(tableName));
    }

    @Test
    public void testVerifyNamespaceRwLocks() throws Exception {
        String nsName1 = "ns1";
        String nsName2 = "ns2";
        TableName tableName1 = TableName.valueOf((String)nsName1, (String)"testtb");
        TableName tableName2 = TableName.valueOf((String)nsName2, (String)"testtb");
        this.queue.addBack((Procedure)new TestNamespaceProcedure(1L, nsName1, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName1, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(3L, tableName2, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestNamespaceProcedure(4L, nsName2, TableProcedureInterface.TableOperationType.EDIT));
        Procedure procNs1 = this.queue.poll();
        Assert.assertEquals((long)1L, (long)procNs1.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireNamespaceExclusiveLock(procNs1, nsName1));
        Procedure procNs2 = this.queue.poll();
        Assert.assertEquals((long)4L, (long)procNs2.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireNamespaceExclusiveLock(procNs2, nsName2));
        this.queue.releaseNamespaceExclusiveLock(procNs2, nsName2);
        this.queue.yield(procNs2);
        procNs2 = this.queue.poll();
        Assert.assertEquals((long)3L, (long)procNs2.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.tryAcquireTableExclusiveLock(procNs2, tableName2));
        Procedure procNs2b = this.queue.poll();
        Assert.assertEquals((long)4L, (long)procNs2b.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.tryAcquireNamespaceExclusiveLock(procNs2b, nsName2));
        this.queue.yield(procNs2b);
        this.queue.releaseNamespaceExclusiveLock(procNs1, nsName1);
        long procId = this.queue.poll().getProcId();
        Assert.assertEquals((long)2L, (long)procId);
        this.queue.releaseTableExclusiveLock(procNs2, tableName2);
        procId = this.queue.poll().getProcId();
        Assert.assertEquals((long)4L, (long)procId);
    }

    @Test(timeout=90000L)
    public void testConcurrentWriteOps() throws Exception {
        int i;
        final TestTableProcSet procSet = new TestTableProcSet(this.queue);
        int NUM_ITEMS = 10;
        int NUM_TABLES = 4;
        final AtomicInteger opsCount = new AtomicInteger(0);
        for (int i2 = 0; i2 < 4; ++i2) {
            TableName tableName = TableName.valueOf((String)String.format("testtb-%04d", i2));
            for (int j = 1; j < 10; ++j) {
                procSet.addBack((Procedure)new TestTableProcedure(i2 * 100 + j, tableName, TableProcedureInterface.TableOperationType.EDIT));
                opsCount.incrementAndGet();
            }
        }
        Assert.assertEquals((long)opsCount.get(), (long)this.queue.size());
        Thread[] threads = new Thread[8];
        final HashSet concurrentTables = new HashSet();
        final ArrayList failures = new ArrayList();
        final AtomicInteger concurrentCount = new AtomicInteger(0);
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (opsCount.get() > 0) {
                        try {
                            Procedure proc = procSet.acquire();
                            if (proc == null) {
                                TestMasterProcedureScheduler.this.queue.signalAll();
                                if (opsCount.get() <= 0) break;
                                continue;
                            }
                            TableName tableId = procSet.getTableName(proc);
                            HashSet hashSet = concurrentTables;
                            synchronized (hashSet) {
                                Assert.assertTrue((String)("unexpected concurrency on " + tableId), (boolean)concurrentTables.add(tableId));
                            }
                            Assert.assertTrue((opsCount.decrementAndGet() >= 0 ? 1 : 0) != 0);
                            try {
                                long procId = proc.getProcId();
                                int concurrent = concurrentCount.incrementAndGet();
                                Assert.assertTrue((String)("inc-concurrent=" + concurrent + " 1 <= concurrent <= 4"), (concurrent >= 1 && concurrent <= 4 ? 1 : 0) != 0);
                                LOG.debug((Object)("[S] tableId=" + tableId + " procId=" + procId + " concurrent=" + concurrent));
                                Thread.sleep(2000L);
                                concurrent = concurrentCount.decrementAndGet();
                                LOG.debug((Object)("[E] tableId=" + tableId + " procId=" + procId + " concurrent=" + concurrent));
                                Assert.assertTrue((String)("dec-concurrent=" + concurrent), (concurrent < 4 ? 1 : 0) != 0);
                            }
                            finally {
                                hashSet = concurrentTables;
                                synchronized (hashSet) {
                                    Assert.assertTrue((boolean)concurrentTables.remove(tableId));
                                }
                                procSet.release(proc);
                            }
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Failed " + e.getMessage()), e);
                            ArrayList arrayList = failures;
                            synchronized (arrayList) {
                                failures.add(e.getMessage());
                            }
                        }
                        finally {
                            TestMasterProcedureScheduler.this.queue.signalAll();
                        }
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((String)failures.toString(), (boolean)failures.isEmpty());
        Assert.assertEquals((long)0L, (long)opsCount.get());
        Assert.assertEquals((long)0L, (long)this.queue.size());
        for (i = 1; i <= 4; ++i) {
            TableName table = TableName.valueOf((String)String.format("testtb-%04d", i));
            Assert.assertTrue((String)("queue should be deleted, table=" + table), (boolean)this.queue.markTableAsDeleted(table));
        }
    }

    public static class TestNamespaceProcedure
    extends ProcedureTestingUtility.TestProcedure
    implements TableProcedureInterface {
        private final TableProcedureInterface.TableOperationType opType;
        private final String nsName;

        public TestNamespaceProcedure() {
            throw new UnsupportedOperationException("recovery should not be triggered here");
        }

        public TestNamespaceProcedure(long procId, String nsName, TableProcedureInterface.TableOperationType opType) {
            super(procId);
            this.nsName = nsName;
            this.opType = opType;
        }

        public TableName getTableName() {
            return TableName.NAMESPACE_TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return this.opType;
        }
    }

    public static class TestTableProcedure
    extends ProcedureTestingUtility.TestProcedure
    implements TableProcedureInterface {
        private final TableProcedureInterface.TableOperationType opType;
        private final TableName tableName;

        public TestTableProcedure() {
            throw new UnsupportedOperationException("recovery should not be triggered here");
        }

        public TestTableProcedure(long procId, TableName tableName, TableProcedureInterface.TableOperationType opType) {
            super(procId);
            this.tableName = tableName;
            this.opType = opType;
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return this.opType;
        }
    }

    public static class TestTableProcSet {
        private final MasterProcedureScheduler queue;

        public TestTableProcSet(MasterProcedureScheduler queue) {
            this.queue = queue;
        }

        public void addBack(Procedure proc) {
            this.queue.addBack(proc);
        }

        public void addFront(Procedure proc) {
            this.queue.addFront(proc);
        }

        public Procedure acquire() {
            Procedure proc = null;
            boolean avail = false;
            while (!avail && (proc = this.queue.poll()) != null) {
                switch (this.getTableOperationType(proc)) {
                    case CREATE: 
                    case DELETE: 
                    case EDIT: {
                        avail = this.queue.tryAcquireTableExclusiveLock(proc, this.getTableName(proc));
                        break;
                    }
                    case READ: {
                        avail = this.queue.tryAcquireTableSharedLock(proc, this.getTableName(proc));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                if (avail) continue;
                this.addFront(proc);
                LOG.debug((Object)("yield procId=" + proc));
            }
            return proc;
        }

        public void release(Procedure proc) {
            switch (this.getTableOperationType(proc)) {
                case CREATE: 
                case DELETE: 
                case EDIT: {
                    this.queue.releaseTableExclusiveLock(proc, this.getTableName(proc));
                    break;
                }
                case READ: {
                    this.queue.releaseTableSharedLock(proc, this.getTableName(proc));
                    break;
                }
            }
        }

        public TableName getTableName(Procedure proc) {
            return ((TableProcedureInterface)proc).getTableName();
        }

        public TableProcedureInterface.TableOperationType getTableOperationType(Procedure proc) {
            return ((TableProcedureInterface)proc).getTableOperationType();
        }
    }
}

