/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce.mapr;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.mapr.UnionMapper;
import org.apache.hadoop.hbase.mapreduce.mapr.UnionReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;

public class UnionJob
extends Configured
implements Tool {
    public static final String MapRTName1 = "/tmp/tmr1";
    public static final String MapRTName2 = "/tmp/tmr2";
    public static final String MapRTNamec = "/tmp/tmrc";
    public static final String HBaseTName1 = "hmr1";
    public static final String HBaseTName2 = "hmr2";
    public static final String HBaseTNamec = "hmrc";
    public static String TableName1 = null;
    public static String TableName2 = null;
    public static String TableNamec = null;
    private static final byte[] CF1 = Bytes.toBytes((String)"cf1");
    private static final byte[] CF2 = Bytes.toBytes((String)"cf2");
    String defaultdb = null;

    private void printUsage() {
        System.out.println("Test the TableMapReduceUtil::initTableMapperJob with Scan list Usage:\nTo test in MapR DB\n\t hbase org.apache.hadoop.hbase.mapreduce.mapr.UnionJob MapRDB\nTo test in HBase\n\t hbase org.apache.hadoop.hbase.mapreduce.mapr.UnionJob HBase\nTo test in mixed Mapr/Hbase tables\n\t hbase org.apache.hadoop.hbase.mapreduce.mapr.UnionJob Mix");
    }

    private int parseArgs(String[] args) {
        if (args.length < 1) {
            this.printUsage();
            return -1;
        }
        if (args.length >= 1) {
            this.defaultdb = args[0];
        }
        return 0;
    }

    private void setup(Configuration conf) {
        if (this.defaultdb.equalsIgnoreCase("maprdb")) {
            TableName1 = MapRTName1;
            TableName2 = MapRTName2;
            TableNamec = MapRTNamec;
        } else if (this.defaultdb.equalsIgnoreCase("hbase")) {
            TableName1 = HBaseTName1;
            TableName2 = HBaseTName2;
            TableNamec = HBaseTNamec;
        } else if (this.defaultdb.equalsIgnoreCase("mix")) {
            TableName1 = HBaseTName1;
            TableName2 = MapRTName2;
            TableNamec = MapRTNamec;
        } else {
            this.printUsage();
            System.exit(-1);
        }
        TableName tn1 = TableName.valueOf((String)TableName1);
        TableName tn2 = TableName.valueOf((String)TableName2);
        TableName tnc = TableName.valueOf((String)TableNamec);
        System.out.println("Input table name 1 is " + tn1.getNameAsString() + "Input table name 2 is " + tn2.getNameAsString() + "Input table name combined is " + tnc.getNameAsString());
        System.out.println("TableName1 is " + String.valueOf(TableName1) + "TableName2 is " + String.valueOf(TableName2) + "TableNamec combined is " + String.valueOf(TableNamec));
        Connection connection = null;
        Table table1 = null;
        Table table2 = null;
        Table tablec = null;
        Admin admin = null;
        try {
            connection = ConnectionFactory.createConnection((Configuration)conf);
            admin = connection.getAdmin();
            if (admin.tableExists(tn1)) {
                admin.disableTable(tn1);
                admin.deleteTable(tn1);
            }
            if (admin.tableExists(tn2)) {
                admin.disableTable(tn2);
                admin.deleteTable(tn2);
            }
            if (admin.tableExists(tnc)) {
                admin.disableTable(tnc);
                admin.deleteTable(tnc);
            }
            HTableDescriptor tableDesc1 = new HTableDescriptor(tn1);
            HColumnDescriptor hcd1 = new HColumnDescriptor(CF1);
            tableDesc1.addFamily(hcd1);
            admin.createTable(tableDesc1);
            HTableDescriptor tableDesc2 = new HTableDescriptor(tn2);
            HColumnDescriptor hcd2 = new HColumnDescriptor(CF2);
            tableDesc2.addFamily(hcd2);
            admin.createTable(tableDesc2);
            HTableDescriptor tableDescC = new HTableDescriptor(tnc);
            tableDescC.addFamily(hcd1);
            admin.createTable(tableDescC);
            table1 = connection.getTable(tn1);
            table2 = connection.getTable(tn2);
            tablec = connection.getTable(tnc);
            Put p = new Put(Bytes.toBytes((String)"20130101#1"));
            p.addColumn(CF1, Bytes.toBytes((String)"sSales"), Bytes.toBytes((String)"100"));
            table1.put(p);
            p = new Put(Bytes.toBytes((String)"20130101#2"));
            p.addColumn(CF1, Bytes.toBytes((String)"sSales"), Bytes.toBytes((String)"110"));
            table1.put(p);
            p = new Put(Bytes.toBytes((String)"20130102#1"));
            p.addColumn(CF1, Bytes.toBytes((String)"sSales"), Bytes.toBytes((String)"200"));
            table1.put(p);
            p = new Put(Bytes.toBytes((String)"20130102#2"));
            p.addColumn(CF1, Bytes.toBytes((String)"sSales"), Bytes.toBytes((String)"210"));
            table1.put(p);
            Put p2 = new Put(Bytes.toBytes((String)"20130101"));
            p2.addColumn(CF2, Bytes.toBytes((String)"oSales"), Bytes.toBytes((String)"400"));
            table2.put(p2);
            p2 = new Put(Bytes.toBytes((String)"20130102"));
            p2.addColumn(CF2, Bytes.toBytes((String)"oSales"), Bytes.toBytes((String)"130"));
            table2.put(p2);
            Scan scan = new Scan();
            System.out.println("-----Setup " + tn1 + " with data -----");
            ResultScanner scanner1 = table1.getScanner(scan);
            Result result = scanner1.next();
            while (result != null) {
                for (KeyValue keyValue : result.list()) {
                    System.out.println("Qualifier : " + keyValue.getKeyString() + " : Value : " + Bytes.toString((byte[])keyValue.getValue()));
                }
                result = scanner1.next();
            }
            System.out.println("-----Setup " + tn2 + " with data -----");
            ResultScanner scanner2 = table2.getScanner(scan);
            Result result2 = scanner2.next();
            while (result2 != null) {
                for (KeyValue keyValue : result2.list()) {
                    System.out.println("Qualifier : " + keyValue.getKeyString() + " : Value : " + Bytes.toString((byte[])keyValue.getValue()));
                }
                result2 = scanner2.next();
            }
            if (admin != null) {
                admin.close();
            }
            if (table1 != null) {
                table1.close();
            }
            if (table2 != null) {
                table2.close();
            }
            if (tablec != null) {
                tablec.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            System.out.println("setup failed with error");
            e.printStackTrace();
        }
    }

    public int run(String[] args) throws Exception {
        Configuration config = HBaseConfiguration.create();
        String defaultdb = config.get("mapr.hbase.default.db");
        int ret = this.parseArgs(args);
        if (ret != 0) {
            return ret;
        }
        System.out.println("-----Set DB " + defaultdb + "-----");
        this.setup(config);
        ArrayList<Scan> scans = new ArrayList<Scan>();
        Scan scan1 = new Scan();
        scan1.setAttribute("scan.attributes.table.name", TableName1.getBytes());
        System.out.println(scan1.getAttribute("scan.attributes.table.name"));
        scans.add(scan1);
        Scan scan2 = new Scan();
        scan2.setAttribute("scan.attributes.table.name", TableName2.getBytes());
        System.out.println(scan2.getAttribute("scan.attributes.table.name"));
        scans.add(scan2);
        Configuration conf = new Configuration();
        Job job = new Job(conf);
        job.setJarByClass(UnionJob.class);
        TableMapReduceUtil.initTableMapperJob(scans, UnionMapper.class, Text.class, IntWritable.class, (Job)job);
        TableMapReduceUtil.initTableReducerJob((String)String.valueOf(TableNamec), UnionReducer.class, (Job)job);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        UnionJob runJob = new UnionJob();
        runJob.run(args);
    }
}

