/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnPrefixFilter {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnPrefixFilter() throws IOException {
        String family = "Family";
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"TestColumnPrefixFilter"));
        htd.addFamily(new HColumnDescriptor(family).setMaxVersions(3));
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        try {
            List<String> rows = this.generateRandomWords(100, "row");
            List<String> columns = this.generateRandomWords(10000, "column");
            long maxTimestamp = 2L;
            ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
            HashMap prefixMap = new HashMap();
            prefixMap.put("p", new ArrayList());
            prefixMap.put("s", new ArrayList());
            String valueString = "ValueString";
            for (String row : rows) {
                Put p = new Put(Bytes.toBytes((String)row));
                p.setDurability(Durability.SKIP_WAL);
                for (String column : columns) {
                    for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                        KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)column, (long)timestamp, (String)valueString);
                        p.add((Cell)kv);
                        kvList.add(kv);
                        for (String s : prefixMap.keySet()) {
                            if (!column.startsWith(s)) continue;
                            ((List)prefixMap.get(s)).add(kv);
                        }
                    }
                }
                region.put(p);
            }
            Scan scan = new Scan();
            scan.setMaxVersions();
            for (String s : prefixMap.keySet()) {
                ColumnPrefixFilter filter = new ColumnPrefixFilter(Bytes.toBytes((String)s));
                scan.setFilter((Filter)filter);
                RegionScanner scanner = region.getScanner(scan);
                ArrayList results = new ArrayList();
                while (scanner.next(results)) {
                }
                Assert.assertEquals((long)((List)prefixMap.get(s)).size(), (long)results.size());
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
        HRegion.closeHRegion((HRegion)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnPrefixFilterWithFilterList() throws IOException {
        String family = "Family";
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"TestColumnPrefixFilter"));
        htd.addFamily(new HColumnDescriptor(family).setMaxVersions(3));
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        try {
            List<String> rows = this.generateRandomWords(100, "row");
            List<String> columns = this.generateRandomWords(10000, "column");
            long maxTimestamp = 2L;
            ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
            HashMap prefixMap = new HashMap();
            prefixMap.put("p", new ArrayList());
            prefixMap.put("s", new ArrayList());
            String valueString = "ValueString";
            for (String row : rows) {
                Put p = new Put(Bytes.toBytes((String)row));
                p.setDurability(Durability.SKIP_WAL);
                for (String column : columns) {
                    for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                        KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)column, (long)timestamp, (String)valueString);
                        p.add((Cell)kv);
                        kvList.add(kv);
                        for (String s : prefixMap.keySet()) {
                            if (!column.startsWith(s)) continue;
                            ((List)prefixMap.get(s)).add(kv);
                        }
                    }
                }
                region.put(p);
            }
            Scan scan = new Scan();
            scan.setMaxVersions();
            for (String s : prefixMap.keySet()) {
                ColumnPrefixFilter filter = new ColumnPrefixFilter(Bytes.toBytes((String)s));
                FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                filterList.addFilter((Filter)filter);
                scan.setFilter((Filter)filterList);
                RegionScanner scanner = region.getScanner(scan);
                ArrayList results = new ArrayList();
                while (scanner.next(results)) {
                }
                Assert.assertEquals((long)((List)prefixMap.get(s)).size(), (long)results.size());
            }
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
        HRegion.closeHRegion((HRegion)region);
    }

    List<String> generateRandomWords(int numberOfWords, String suffix) {
        HashSet<Object> wordSet = new HashSet<Object>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * 2.0) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            Object word = suffix == null ? new String(wordChar) : new String(wordChar) + suffix;
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

