/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAdmin2 {
    private static final Log LOG = LogFactory.getLog(TestAdmin2.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 30);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.getConfiguration().setLong("hbase.master.maximum.logsplit.keeptime", 100L);
        TEST_UTIL.getConfiguration().setInt("hbase.client.sync.wait.timeout.msec", 30000);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : this.admin.listTables()) {
            TEST_UTIL.deleteTable(htd.getName());
        }
    }

    @Test(timeout=300000L)
    public void testCreateBadTables() throws IOException {
        int i;
        String msg = null;
        try {
            this.admin.createTable(new HTableDescriptor(TableName.META_TABLE_NAME));
        }
        catch (TableExistsException e) {
            msg = e.toString();
        }
        Assert.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(TableExistsException.class.getName()) && msg.contains(TableName.META_TABLE_NAME.getNameAsString()) ? 1 : 0) != 0);
        final HTableDescriptor threadDesc = new HTableDescriptor(TableName.valueOf((String)"threaded_testCreateBadTables"));
        threadDesc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        int count = 10;
        Thread[] threads = new Thread[count];
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicInteger failures = new AtomicInteger(0);
        final Admin localAdmin = this.admin;
        for (i = 0; i < count; ++i) {
            threads[i] = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    try {
                        localAdmin.createTable(threadDesc);
                        successes.incrementAndGet();
                    }
                    catch (TableExistsException e) {
                        failures.incrementAndGet();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed threaded create" + this.getName(), e);
                    }
                }
            };
        }
        for (i = 0; i < count; ++i) {
            threads[i].start();
        }
        for (i = 0; i < count; ++i) {
            while (threads[i].isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Assert.assertEquals((long)1L, (long)successes.get());
        Assert.assertEquals((long)(count - 1), (long)failures.get());
    }

    @Test(timeout=300000L)
    public void testTableNameClash() throws Exception {
        String name = "testTableNameClash";
        HTableDescriptor htd1 = new HTableDescriptor(TableName.valueOf((String)(name + "SOMEUPPERCASE")));
        HTableDescriptor htd2 = new HTableDescriptor(TableName.valueOf((String)name));
        htd1.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        htd2.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(htd1);
        this.admin.createTable(htd2);
        new HTable(TEST_UTIL.getConfiguration(), htd2.getTableName()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCreateTableRPCTimeOut() throws Exception {
        String name = "testCreateTableRPCTimeOut";
        int oldTimeout = TEST_UTIL.getConfiguration().getInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 1500);
        try {
            int expectedRegions = 100;
            byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
            byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
            HBaseAdmin hbaseadmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)name));
            htd.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
            hbaseadmin.createTable(htd, startKey, endKey, expectedRegions);
            hbaseadmin.close();
        }
        finally {
            TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", oldTimeout);
        }
    }

    @Test(timeout=300000L)
    public void testReadOnlyTable() throws Exception {
        TableName name = TableName.valueOf((String)"testReadOnlyTable");
        HTable table = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        byte[] value = Bytes.toBytes((String)"somedata");
        Put put = new Put(value);
        put.add(HConstants.CATALOG_FAMILY, HConstants.CATALOG_FAMILY, value);
        table.put(put);
        table.close();
    }

    @Test(timeout=300000L)
    public void testTableNames() throws IOException {
        byte[][] illegalNames;
        for (byte[] illegalName : illegalNames = new byte[][]{Bytes.toBytes((String)"-bad"), Bytes.toBytes((String)".bad")}) {
            try {
                new HTableDescriptor(TableName.valueOf((byte[])illegalName));
                throw new IOException("Did not detect '" + Bytes.toString((byte[])illegalName) + "' as an illegal user table name");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        byte[] legalName = Bytes.toBytes((String)"g-oo.d");
        try {
            new HTableDescriptor(TableName.valueOf((byte[])legalName));
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Legal user table name: '" + Bytes.toString((byte[])legalName) + "' caused IllegalArgumentException: " + e.getMessage());
        }
    }

    @Test(expected=TableExistsException.class, timeout=300000L)
    public void testTableExistsExceptionWithATable() throws IOException {
        TableName name = TableName.valueOf((String)"testTableExistsExceptionWithATable");
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
    }

    @Test(expected=TableNotEnabledException.class, timeout=300000L)
    public void testTableNotEnabledExceptionWithATable() throws IOException {
        TableName name = TableName.valueOf((String)"testTableNotEnabledExceptionWithATable");
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        this.admin.disableTable(name);
        this.admin.disableTable(name);
    }

    @Test(expected=TableNotDisabledException.class, timeout=300000L)
    public void testTableNotDisabledExceptionWithATable() throws IOException {
        TableName name = TableName.valueOf((String)"testTableNotDisabledExceptionWithATable");
        try (HTable t = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);){
            this.admin.enableTable(name);
        }
    }

    @Test(expected=TableNotFoundException.class, timeout=300000L)
    public void testTableNotFoundExceptionWithoutAnyTables() throws IOException {
        TableName tableName = TableName.valueOf((String)"testTableNotFoundExceptionWithoutAnyTables");
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        ht.get(new Get("e".getBytes()));
    }

    @Test(timeout=300000L)
    public void testShouldCloseTheRegionBasedOnTheEncodedRegionName() throws Exception {
        TableName TABLENAME = TableName.valueOf((String)"TestHBACloseRegion");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.getTable().isSystemTable()) continue;
            info = regionInfo;
            this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), rs.getServerName().getServerName());
        }
        boolean isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout && isInList) {
            Thread.sleep(100L);
            isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        }
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)isInList);
    }

    @Test(timeout=300000L)
    public void testCloseRegionIfInvalidRegionNameIsPassed() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion1");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TableName.valueOf((byte[])TABLENAME));
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion1")) continue;
            info = regionInfo;
            try {
                this.admin.closeRegionWithEncodedRegionName("sample", rs.getServerName().getServerName());
            }
            catch (NotServingRegionException notServingRegionException) {}
        }
        onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        Assert.assertTrue((String)"The region should be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    @Test(timeout=300000L)
    public void testCloseRegionThatFetchesTheHRIFromMeta() throws Exception {
        TableName TABLENAME = TableName.valueOf((String)"TestHBACloseRegion2");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion2")) continue;
            info = regionInfo;
            this.admin.closeRegion(regionInfo.getRegionNameAsString(), rs.getServerName().getServerName());
        }
        boolean isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout && isInList) {
            Thread.sleep(100L);
            isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        }
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)isInList);
    }

    @Test(timeout=300000L)
    public void testCloseRegionWhenServerNameIsNull() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion3");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TableName.valueOf((byte[])TABLENAME));
        try {
            List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
            for (HRegionInfo regionInfo : onlineRegions) {
                if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion3")) continue;
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), null);
            }
            Assert.fail((String)"The test should throw exception if the servername passed is null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testCloseRegionWhenServerNameIsEmpty() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegionWhenServerNameIsEmpty");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TableName.valueOf((byte[])TABLENAME));
        try {
            List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
            for (HRegionInfo regionInfo : onlineRegions) {
                if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegionWhenServerNameIsEmpty")) continue;
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), " ");
            }
            Assert.fail((String)"The test should throw exception if the servername passed is empty.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testCloseRegionWhenEncodedRegionNameIsNotGiven() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"TestHBACloseRegion4");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TableName.valueOf((byte[])TABLENAME));
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion4")) continue;
            info = regionInfo;
            try {
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getRegionNameAsString(), rs.getServerName().getServerName());
            }
            catch (NotServingRegionException notServingRegionException) {}
        }
        onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        Assert.assertTrue((String)"The region should be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    private HBaseAdmin createTable(byte[] TABLENAME) throws IOException {
        Configuration config = TEST_UTIL.getConfiguration();
        HBaseAdmin admin = new HBaseAdmin(config);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])TABLENAME));
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable(htd, null);
        return admin;
    }

    private void createTableWithDefaultConf(byte[] TABLENAME) throws IOException {
        this.createTableWithDefaultConf(TableName.valueOf((byte[])TABLENAME));
    }

    private void createTableWithDefaultConf(TableName TABLENAME) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TABLENAME);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        this.admin.createTable(htd, null);
    }

    @Test(timeout=300000L)
    public void testGetTableRegions() throws IOException {
        TableName tableName = TableName.valueOf((String)"testGetTableRegions");
        int expectedRegions = 10;
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        List RegionInfos = this.admin.getTableRegions(tableName);
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + RegionInfos.size()), (long)expectedRegions, (long)RegionInfos.size());
    }

    @Test(timeout=300000L)
    public void testWALRollWriting() throws Exception {
        this.setUpforLogRolling();
        String className = this.getClass().getName();
        StringBuilder v = new StringBuilder(className);
        while (v.length() < 1000) {
            v.append(className);
        }
        byte[] value = Bytes.toBytes((String)v.toString());
        HRegionServer regionServer = this.startAndWriteData(TableName.valueOf((String)"TestLogRolling"), value);
        LOG.info((Object)("after writing there are " + DefaultWALProvider.getNumRolledLogFiles((WAL)regionServer.getWAL(null)) + " log files"));
        for (Region r : regionServer.getOnlineRegionsLocalContext()) {
            r.flush(true);
        }
        this.admin.rollWALWriter(regionServer.getServerName());
        int count = DefaultWALProvider.getNumRolledLogFiles((WAL)regionServer.getWAL(null));
        LOG.info((Object)("after flushing all regions and rolling logs there are " + count + " log files"));
        Assert.assertTrue((String)("actual count: " + count), (count <= 2 ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void testMoveToPreviouslyAssignedRS() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testMoveToPreviouslyAssignedRS");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        HBaseAdmin localAdmin = this.createTable(tableName);
        List tableRegions = localAdmin.getTableRegions(tableName);
        HRegionInfo hri = (HRegionInfo)tableRegions.get(0);
        AssignmentManager am = master.getAssignmentManager();
        Assert.assertTrue((String)("Region " + hri.getRegionNameAsString() + " should be assigned properly"), (boolean)am.waitForAssignment(hri));
        ServerName server = am.getRegionStates().getRegionServerOfRegion(hri);
        localAdmin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)server.getServerName()));
        Assert.assertEquals((String)"Current region server and region server before move should be same.", (Object)server, (Object)am.getRegionStates().getRegionServerOfRegion(hri));
    }

    private void setUpforLogRolling() {
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 786432L);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.maxlogentries", 32);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.optionalflushcount", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.flush.size", 8192);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 10000L);
        TEST_UTIL.getConfiguration().setInt("hbase.server.thread.wakefrequency", 2000);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 30);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.tolerable.lowreplication", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.lowreplication.rolllimit", 3);
    }

    private HRegionServer startAndWriteData(TableName tableName, byte[] value) throws IOException, InterruptedException {
        new HTable(TEST_UTIL.getConfiguration(), TableName.META_TABLE_NAME).close();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        for (int i = 1; i <= 256; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + String.format("%1$04d", i))));
            put.add(HConstants.CATALOG_FAMILY, null, value);
            table.put(put);
            if (i % 32 != 0) continue;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        table.close();
        return regionServer;
    }

    @Test(timeout=300000L)
    public void testCheckHBaseAvailableClosesConnection() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        int initialCount = HConnectionTestingUtility.getConnectionCount();
        HBaseAdmin.checkHBaseAvailable((Configuration)conf);
        int finalCount = HConnectionTestingUtility.getConnectionCount();
        Assert.assertEquals((long)initialCount, (long)finalCount);
    }

    @Test(timeout=300000L)
    public void testCheckHBaseAvailableWithoutCluster() {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.zookeeper.property.clientPort", conf.getInt("hbase.zookeeper.property.clientPort", 9999) + 10);
        int initialCount = HConnectionTestingUtility.getConnectionCount();
        long start = System.currentTimeMillis();
        try {
            HBaseAdmin.checkHBaseAvailable((Configuration)conf);
            Assert.assertTrue((boolean)false);
        }
        catch (MasterNotRunningException masterNotRunningException) {
        }
        catch (ZooKeeperConnectionException zooKeeperConnectionException) {
        }
        catch (ServiceException serviceException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        int finalCount = HConnectionTestingUtility.getConnectionCount();
        Assert.assertEquals((long)initialCount, (long)finalCount);
        LOG.info((Object)("It took " + (end - start) + " ms to find out that HBase was not available"));
    }

    @Test(timeout=300000L)
    public void testDisableCatalogTable() throws Exception {
        try {
            this.admin.disableTable(TableName.META_TABLE_NAME);
            Assert.fail((String)"Expected to throw ConstraintException");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])"testDisableCatalogTable".getBytes()));
        HColumnDescriptor hcd = new HColumnDescriptor("cf1".getBytes());
        htd.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(htd);
    }

    @Test(timeout=300000L)
    public void testIsEnabledOrDisabledOnUnknownTable() throws Exception {
        try {
            this.admin.isTableEnabled(TableName.valueOf((String)"unkownTable"));
            Assert.fail((String)"Test should fail if isTableEnabled called on unknown table.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.admin.isTableDisabled(TableName.valueOf((String)"unkownTable"));
            Assert.fail((String)"Test should fail if isTableDisabled called on unknown table.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testGetRegion() throws Exception {
        HBaseAdmin rawAdmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        TableName tableName = TableName.valueOf((String)"testGetRegion");
        LOG.info((Object)("Started " + tableName));
        HTable t = TEST_UTIL.createMultiRegionTable(tableName, HConstants.CATALOG_FAMILY);
        HRegionLocation regionLocation = t.getRegionLocation("mmm");
        HRegionInfo region = regionLocation.getRegionInfo();
        byte[] regionName = region.getRegionName();
        Pair pair = rawAdmin.getRegion(regionName);
        Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])((HRegionInfo)pair.getFirst()).getRegionName()));
        pair = rawAdmin.getRegion(region.getEncodedNameAsBytes());
        Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])((HRegionInfo)pair.getFirst()).getRegionName()));
    }

    @Test(timeout=30000L)
    public void testBalancer() throws Exception {
        boolean initialState = this.admin.isBalancerEnabled();
        boolean prevState = this.admin.setBalancerRunning(!initialState, true);
        Assert.assertEquals((Object)initialState, (Object)prevState);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)this.admin.isBalancerEnabled());
        prevState = this.admin.setBalancerRunning(initialState, true);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)prevState);
        Assert.assertEquals((Object)initialState, (Object)this.admin.isBalancerEnabled());
    }

    @Test(timeout=30000L)
    public void testAbortProcedureFail() throws Exception {
        Random randomGenerator = new Random();
        long procId = randomGenerator.nextLong();
        boolean abortResult = this.admin.abortProcedure(procId, true);
        Assert.assertFalse((boolean)abortResult);
    }

    @Test(timeout=300000L)
    public void testListProcedures() throws Exception {
        ProcedureInfo[] procList = this.admin.listProcedures();
        Assert.assertTrue((procList.length > 0 ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testRegionNormalizer() throws Exception {
        boolean initialState = this.admin.isNormalizerEnabled();
        boolean prevState = this.admin.setNormalizerRunning(!initialState);
        Assert.assertEquals((Object)initialState, (Object)prevState);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)this.admin.isNormalizerEnabled());
        prevState = this.admin.setNormalizerRunning(initialState);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)prevState);
        Assert.assertEquals((Object)initialState, (Object)this.admin.isNormalizerEnabled());
    }

    @Test(timeout=30000L)
    public void testEnableTableAfterprocessedServersCleaned() throws Exception {
        String TABLENAME = "testEnableTableAfterprocessedServersCleaned";
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor hds = new HTableDescriptor(TableName.valueOf((String)TABLENAME));
        HColumnDescriptor hcs = new HColumnDescriptor("cf".getBytes());
        hds.addFamily(hcs);
        admin.createTable(hds);
        HRegionServer server = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        ServerName serverName = server.getServerName();
        HRegionInfo region = (HRegionInfo)admin.getTableRegions(TableName.valueOf((String)TABLENAME)).get(0);
        admin.move(region.getEncodedNameAsBytes(), Bytes.toBytes((String)serverName.toString()));
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.valueOf((String)TABLENAME));
        admin.disableTable(TABLENAME);
        server.abort("abort");
        Thread.sleep(5000L);
        TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().logSplit(ServerName.valueOf((String)"fakeServer", (int)5000, (long)0L));
        admin.enableTable(TABLENAME);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.valueOf((String)TABLENAME), 10000L);
    }

    @Test
    public void testGetRegionInfo() throws Exception {
        TableName tableName = TableName.valueOf((String)"testGetRegionInfo");
        HTable table = TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"));
        for (int i = 0; i < 100; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), Bytes.toBytes((int)i)));
        }
        this.admin.flush(tableName);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(table.getName());
        List regions = rs.getOnlineRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        Region region = (Region)regions.get(0);
        byte[] regionName = region.getRegionInfo().getRegionName();
        Store store = region.getStore(Bytes.toBytes((String)"f"));
        long expectedStoreFilesSize = store.getStorefilesSize();
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((long)expectedStoreFilesSize, (long)store.getSize());
        ClusterConnection conn = (ClusterConnection)this.admin.getConnection();
        HBaseRpcController controller = conn.getRpcControllerFactory().newController();
        for (int i = 0; i < 10; ++i) {
            HRegionInfo ri = ProtobufUtil.getRegionInfo((RpcController)controller, (AdminProtos.AdminService.BlockingInterface)conn.getAdmin(rs.getServerName()), (byte[])regionName);
            Assert.assertEquals((Object)region.getRegionInfo(), (Object)ri);
            Assert.assertNull((Object)store.getSplitPoint());
            Assert.assertEquals((long)expectedStoreFilesSize, (long)store.getSize());
        }
    }
}

