// Autogenerated Jamon implementation
// /data/jenkins/workspace/h-1.4.14-mapr-mep-10.0.1-fy26-q1/mapr-hbase-1.4.14/dl/mapr-hbase-1.4.14/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/BlockCacheTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 37, 1
import java.util.Map;
// 38, 1
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil.CachedBlocksByFile;
// 39, 1
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
// 40, 1
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
// 41, 1
import org.apache.hadoop.conf.Configuration;
// 42, 1
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
// 43, 1
import org.apache.hadoop.hbase.io.hfile.BlockCache;
// 44, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCacheStats;
// 45, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
// 46, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
// 47, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator.Bucket;
// 48, 1
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class BlockCacheTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.Intf

{
  private final CacheConfig cacheConfig;
  private final Configuration config;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public BlockCacheTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    cacheConfig = p_implData.getCacheConfig();
    config = p_implData.getConfig();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 24, 1
    
  BlockCache bc = cacheConfig == null? null: cacheConfig.getBlockCache();
  String bcUrl = null;
  String bcName = null;
  if (bc != null) {
    bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
    bcName = bc.getClass().getSimpleName();
  }
  BlockCache [] bcs = cacheConfig == null? null: cacheConfig.getBlockCache() == null? null: cacheConfig.getBlockCache().getBlockCaches();
  // If more than one bc, show evictions in each bc listing so can compare
  boolean evictions = bcs != null && bcs.length > 1;

    // 50, 1
    jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_bc_baseInfo\" data-toggle=\"tab\">Base Info</a></li>\n        <li class=\"\"><a href=\"#tab_bc_config\" data-toggle=\"tab\">Config</a></li>\n        <li class=\"\"><a href=\"#tab_bc_stats\" data-toggle=\"tab\">Stats</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l1\" data-toggle=\"tab\">L1</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l2\" data-toggle=\"tab\">L2</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_bc_baseInfo\">\n            ");
    // 60, 13
    {
      // 60, 13
      __jamon_innerUnit__bc_baseInfo(jamonWriter, cacheConfig, bcUrl, bcName);
    }
    // 60, 91
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_config\">\n            ");
    // 63, 13
    {
      // 63, 13
      __jamon_innerUnit__bc_config(jamonWriter, cacheConfig );
    }
    // 63, 55
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_stats\">\n            ");
    // 66, 13
    {
      // 66, 13
      __jamon_innerUnit__bc_stats(jamonWriter, cacheConfig );
    }
    // 66, 54
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l1\">\n            ");
    // 69, 13
    {
      // 69, 13
      __jamon_innerUnit__bc_l(jamonWriter, bcs == null? bc: bcs[0], "L1", evictions);
    }
    // 69, 90
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l2\">\n            ");
    // 72, 13
    {
      // 72, 13
      __jamon_innerUnit__bc_l(jamonWriter, bcs == null? null: bcs.length <= 1? null: bcs[1], "L2", evictions);
    }
    // 72, 115
    jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
  }
  
  
  // 268, 1
  private void __jamon_innerUnit__bc_l(final java.io.Writer jamonWriter, final BlockCache bc, final String name, final boolean evictions)
    throws java.io.IOException
  {
    // 274, 1
    if (bc == null )
    {
      // 274, 19
      jamonWriter.write("\n<p>No ");
      // 275, 7
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
      // 275, 17
      jamonWriter.write(" deployed</p>\n");
    }
    // 276, 1
    else
    {
      // 276, 8
      jamonWriter.write("\n");
      // 277, 1
      {
        // 277, 1
        __jamon_innerUnit__block_cache(jamonWriter, bc, name, evictions);
      }
      // 277, 65
      jamonWriter.write("\n");
    }
    // 278, 7
    jamonWriter.write("\n");
  }
  
  
  // 281, 1
  private void __jamon_innerUnit__block_cache(final java.io.Writer jamonWriter, final BlockCache bc, final String name, final boolean evictions)
    throws java.io.IOException
  {
    // 287, 1
    
  String bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
  String bcName = bc.getClass().getSimpleName();
  org.apache.hadoop.hbase.io.hfile.BlockCacheUtil.CachedBlocksByFile cbsbf =
    org.apache.hadoop.hbase.io.hfile.BlockCacheUtil.getLoadedCachedBlocksByFile(config, bc);
  AgeSnapshot cbsbfSnapshot = cbsbf.getAgeInCacheSnapshot();

  boolean bucketCache = bc.getClass().getSimpleName().equals("BucketCache");
  BucketCacheStats bucketCacheStats = null;
  BucketAllocator bucketAllocator = null;

  if (bucketCache) {
    bucketCacheStats = (BucketCacheStats)bc.getStats();
    bucketAllocator = ((BucketCache)bc).getAllocator();
  }

    // 303, 1
    if (cbsbf.isFull() )
    {
      // 303, 23
      jamonWriter.write("\n<p>\n<div class=\"alert alert-danger\">\n<strong>The stats below are incomplete!</strong> We ran into our accounting limit of ");
      // 306, 86
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cbsbf.getCount()), jamonWriter);
      // 306, 108
      jamonWriter.write(" blocks. Up the configuration <i>hbase.ui.blockcache.by.file.max</i>.\n</div>\n</p> \n");
    }
    // 309, 7
    jamonWriter.write("\n<table id=\"blocks_summary\" class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
    // 318, 22
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcUrl), jamonWriter);
    // 318, 33
    jamonWriter.write("\">");
    // 318, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bc.getClass().getSimpleName()), jamonWriter);
    // 318, 70
    jamonWriter.write("</a></td>\n        <td>Class implementing this block cache Level</td>\n    </tr>\n");
    // 321, 1
    if (bucketCache )
    {
      // 321, 20
      jamonWriter.write("\n    <tr>\n        <td>Implementation</td>\n        <td>");
      // 324, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(((BucketCache)bc).getIoEngine()), jamonWriter);
      // 324, 50
      jamonWriter.write("</a></td>\n        <td>IOEngine</td>\n    </tr>\n");
    }
    // 327, 7
    jamonWriter.write("\n    <tr>\n        <td>Cache Size Limit</td>\n        <td>");
    // 330, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getMaxSize(), "B", 1)), jamonWriter);
    // 330, 79
    jamonWriter.write("</td>\n        <td>Max size of cache</td>\n    </tr>\n    <tr>\n        <td>Block Count</td>\n        <td>");
    // 335, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getBlockCount())), jamonWriter);
    // 335, 59
    jamonWriter.write("</td>\n        <td>Count of Blocks</td>\n    </tr>\n");
    // 338, 1
    if (!bucketCache )
    {
      // 338, 21
      jamonWriter.write("\n    <tr>\n        <td>Data Block Count</td>\n        <td>");
      // 341, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getDataBlockCount())), jamonWriter);
      // 341, 63
      jamonWriter.write("</td>\n        <td>Count of DATA Blocks</td>\n    </tr>\n");
    }
    // 344, 7
    jamonWriter.write("\n    <tr>\n        <td>Size of Blocks</td>\n        <td>");
    // 347, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentSize(), "B", 1)), jamonWriter);
    // 347, 83
    jamonWriter.write("</td>\n        <td>Size of Blocks</td>\n    </tr>\n");
    // 350, 1
    if (!bucketCache )
    {
      // 350, 21
      jamonWriter.write("\n    <tr>\n        <td>Size of Data Blocks</td>\n        <td>");
      // 353, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentDataSize(), "B", 1)), jamonWriter);
      // 353, 87
      jamonWriter.write("</td>\n        <td>Size of DATA Blocks</td>\n    </tr>\n");
    }
    // 356, 7
    jamonWriter.write(" \n");
    // 357, 1
    {
      // 357, 1
      __jamon_innerUnit__evictions_tmpl(jamonWriter, bc);
    }
    // 357, 31
    jamonWriter.write("\n");
    // 358, 1
    {
      // 358, 1
      __jamon_innerUnit__hits_tmpl(jamonWriter, bc);
    }
    // 358, 26
    jamonWriter.write("\n\n");
    // 360, 1
    if (bucketCache )
    {
      // 360, 20
      jamonWriter.write("\n    <tr>\n        <td>Hits per Second</td>\n        <td>");
      // 363, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bucketCacheStats.getIOHitsPerSecond()), jamonWriter);
      // 363, 56
      jamonWriter.write("</td>\n        <td>Block gets against this cache per second</td>\n    </tr>\n    <tr>\n        <td>Time per Hit</td>\n        <td>");
      // 368, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bucketCacheStats.getIOTimePerHit()), jamonWriter);
      // 368, 53
      jamonWriter.write("</td>\n        <td>Time per cache hit</td>\n    </tr>\n");
    }
    // 371, 7
    jamonWriter.write("\n</table>\n<p>View block cache <a href=\"?format=json&bcn=");
    // 374, 47
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
    // 374, 57
    jamonWriter.write("\">as JSON</a> | Block cache <a href=\"?format=json&bcn=");
    // 374, 111
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
    // 374, 121
    jamonWriter.write("&bcv=file\">as JSON by file</a></p>\n");
    // 375, 1
    
cbsbf = null;

  }
  
  
  // 230, 1
  private void __jamon_innerUnit__bc_stats(final java.io.Writer jamonWriter, final CacheConfig cacheConfig)
    throws java.io.IOException
  {
    // 234, 1
    if (cacheConfig == null || cacheConfig.getBlockCache() == null )
    {
      // 234, 67
      jamonWriter.write("\n<p>CacheConfig is null</p>\n");
    }
    // 236, 1
    else
    {
      // 236, 8
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Size</td>\n        <td>");
      // 245, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(cacheConfig.getBlockCache().getCurrentSize(),
            "B", 1)), jamonWriter);
      // 246, 23
      jamonWriter.write("</td>\n        <td>Current size of block cache in use (bytes)</td>\n    </tr>\n    <tr>\n        <td>Free</td>\n        <td>");
      // 251, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(cacheConfig.getBlockCache().getFreeSize(),
            "B", 1)), jamonWriter);
      // 252, 23
      jamonWriter.write("</td>\n        <td>The total free memory currently available to store more cache entries (bytes)</td>\n    </tr>\n    <tr>\n        <td>Count</td>\n        <td>");
      // 257, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", cacheConfig.getBlockCache().getBlockCount())), jamonWriter);
      // 257, 84
      jamonWriter.write("</td>\n        <td>Number of blocks in block cache</td>\n    </tr>\n    ");
      // 260, 5
      {
        // 260, 5
        __jamon_innerUnit__evictions_tmpl(jamonWriter, cacheConfig.getBlockCache());
      }
      // 260, 60
      jamonWriter.write("\n    ");
      // 261, 5
      {
        // 261, 5
        __jamon_innerUnit__hits_tmpl(jamonWriter, cacheConfig.getBlockCache());
      }
      // 261, 55
      jamonWriter.write("\n</table>\n<p>If block cache is made up of more than one cache -- i.e. a L1 and a L2 -- then the above\nare combined counts. Request count is sum of hits and misses.</p>\n");
    }
    // 265, 7
    jamonWriter.write("\n");
  }
  
  
  // 119, 1
  private void __jamon_innerUnit__bc_config(final java.io.Writer jamonWriter, final CacheConfig cacheConfig)
    throws java.io.IOException
  {
    // 123, 1
    if (cacheConfig == null )
    {
      // 123, 28
      jamonWriter.write("\n<p>CacheConfig is null</p>\n");
    }
    // 125, 1
    else
    {
      // 125, 8
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Cache DATA on Read</td>\n        <td>");
      // 134, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataOnRead()), jamonWriter);
      // 134, 54
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on read\n        (INDEX & BLOOM blocks are always cached)</td>\n    </tr>\n    <tr>\n        <td>Cache DATA on Write</td>\n        <td>");
      // 140, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataOnWrite()), jamonWriter);
      // 140, 55
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on write.</td>\n    </tr>\n    <tr>\n        <td>Cache INDEX on Write</td>\n        <td>");
      // 145, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheIndexesOnWrite()), jamonWriter);
      // 145, 58
      jamonWriter.write("</td>\n        <td>True if INDEX blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Cache BLOOM on Write</td>\n        <td>");
      // 150, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheBloomsOnWrite()), jamonWriter);
      // 150, 57
      jamonWriter.write("</td>\n        <td>True if BLOOM blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Evict blocks on Close</td>\n        <td>");
      // 155, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldEvictOnClose()), jamonWriter);
      // 155, 51
      jamonWriter.write("</td>\n        <td>True if blocks are evicted from cache when an HFile\n        reader is closed</td>\n    </tr>\n    <tr>\n        <td>Cache DATA in compressed format</td>\n        <td>");
      // 161, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataCompressed()), jamonWriter);
      // 161, 58
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached in their compressed form</td>\n    </tr>\n    <tr>\n        <td>Prefetch on Open</td>\n        <td>");
      // 166, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldPrefetchOnOpen()), jamonWriter);
      // 166, 53
      jamonWriter.write("</td>\n        <td>True if blocks are prefetched into cache on open</td>\n    </tr>\n</table>\n");
    }
    // 170, 7
    jamonWriter.write("\n");
  }
  
  
  // 77, 1
  private void __jamon_innerUnit__bc_baseInfo(final java.io.Writer jamonWriter, final CacheConfig cacheConfig, final String bcUrl, final String bcName)
    throws java.io.IOException
  {
    // 83, 1
    
  BlockCache bc = cacheConfig == null? null: cacheConfig.getBlockCache();
  BlockCache [] bcs = bc == null? null: bc.getBlockCaches();
  String bcl1Url = null;
  String bcl1Name = null;
  String bcl2Url = null;
  String bcl2Name = null;
  if (bcs != null) {
    BlockCache bcl1 = bcs[0];
    if (bcl1 != null) {
      bcl1Url = "http://hbase.apache.org/devapidocs/" + bcl1.getClass().getName().replaceAll("\\.", "/") + ".html";
      bcl1Name = bcl1.getClass().getSimpleName();
    }
    if (bcs.length == 2) {
      BlockCache bcl2 = bcs[1];
      bcl2Url = "http://hbase.apache.org/devapidocs/" + bcl2.getClass().getName().replaceAll("\\.", "/") + ".html";
      bcl2Name = bcl2.getClass().getSimpleName();
    }
  }

    // 103, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
    // 112, 22
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcUrl), jamonWriter);
    // 112, 33
    jamonWriter.write("\">");
    // 112, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcName), jamonWriter);
    // 112, 47
    jamonWriter.write("</a></td>\n        <td>Block cache implementing class</td>\n    </tr>\n</table>\n<p>See <a href=\"http://hbase.apache.org/book.html#block.cache\">block cache</a> in the HBase Reference Guide for help.</p>\n");
  }
  
  
  // 173, 1
  private void __jamon_innerUnit__evictions_tmpl(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 177, 1
    
  AgeSnapshot ageAtEvictionSnapshot = bc.getStats().getAgeAtEvictionSnapshot();
  // Only show if non-zero mean and stddev as is the case in combinedblockcache

    // 181, 5
    jamonWriter.write("<tr>\n        <td>Evicted</td>\n        <td>");
    // 183, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getEvictedCount())), jamonWriter);
    // 183, 72
    jamonWriter.write("</td>\n        <td>The total number of blocks evicted</td>\n    </tr>\n    <tr>\n        <td>Evictions</td>\n        <td>");
    // 188, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getEvictionCount())), jamonWriter);
    // 188, 73
    jamonWriter.write("</td>\n        <td>The total number of times an eviction has occurred</td>\n    </tr>\n    <tr>\n        <td>Mean</td>\n        <td>");
    // 193, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", (long)ageAtEvictionSnapshot.getMean())), jamonWriter);
    // 193, 78
    jamonWriter.write("</td>\n        <td>Mean age of Blocks at eviction time (seconds)</td>\n    </tr>\n");
  }
  
  
  // 198, 1
  private void __jamon_innerUnit__hits_tmpl(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 202, 5
    jamonWriter.write("<tr>\n        <td>Hits</td>\n        <td>");
    // 204, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getHitCount())), jamonWriter);
    // 204, 68
    jamonWriter.write("</td>\n        <td>Number requests that were cache hits</td>\n    </tr>\n    <tr>\n        <td>Hits Caching</td>\n        <td>");
    // 209, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getHitCachingCount())), jamonWriter);
    // 209, 75
    jamonWriter.write("</td>\n        <td>Cache hit block requests but only requests set to cache block if a miss</td>\n    </tr>\n    <tr>\n        <td>Misses</td>\n        <td>");
    // 214, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getMissCount())), jamonWriter);
    // 214, 69
    jamonWriter.write("</td>\n        <td>Block requests that were cache misses but set to cache missed blocks</td>\n    </tr>\n    <tr>\n        <td>Misses Caching</td>\n        <td>");
    // 219, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getMissCount())), jamonWriter);
    // 219, 69
    jamonWriter.write("</td>\n        <td>Block requests that were cache misses but only requests set to use block cache</td>\n    </tr>\n    <tr>\n        <td>Hit Ratio</td>\n        <td>");
    // 224, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,.2f", bc.getStats().getHitRatio() * 100)), jamonWriter);
    // 224, 76
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 224, 85
    jamonWriter.write("</td>\n        <td>Hit Count divided by total requests count</td>\n    </tr>\n\n");
  }
  
  
}
